/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.InstantiationException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public final class ClassUtils {
    private static final String INSTANTIATION_ERROR_PREFIX = "Unable to create instance of class: ";

    private ClassUtils() {
    }

    public static <T> Predicate<T> instantiatePredicateClass(Class<? extends Predicate<T>> clazz) {
        try {
            Constructor<Predicate<T>> c = clazz.getConstructor(new Class[0]);
            if (c != null) {
                return c.newInstance(new Object[0]);
            }
            throw new InstantiationException(INSTANTIATION_ERROR_PREFIX + clazz.getName());
        }
        catch (Exception e) {
            throw new InstantiationException(INSTANTIATION_ERROR_PREFIX + clazz.getName(), e);
        }
    }

    public static <T> T instantiateClassDefConstructor(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class to instantiate should not be null");
        if (clazz.getConstructors().length > 0 && Arrays.stream(clazz.getConstructors()).noneMatch(c -> c.getParameterCount() == 0)) {
            throw new InstantiationException("Default constructor is required to create instance of public class: " + clazz.getName());
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InstantiationException(INSTANTIATION_ERROR_PREFIX + clazz.getName(), e);
        }
    }
}

