/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.core.Assertions;

public class LegacyESVersion
extends Version {
    public static final LegacyESVersion V_7_0_0 = new LegacyESVersion(7000099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_0_1 = new LegacyESVersion(7000199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_1_0 = new LegacyESVersion(7010099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_1_1 = new LegacyESVersion(7010199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_2_0 = new LegacyESVersion(7020099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_2_1 = new LegacyESVersion(7020199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final LegacyESVersion V_7_3_0 = new LegacyESVersion(7030099, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final LegacyESVersion V_7_3_1 = new LegacyESVersion(7030199, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final LegacyESVersion V_7_3_2 = new LegacyESVersion(7030299, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final LegacyESVersion V_7_4_0 = new LegacyESVersion(7040099, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final LegacyESVersion V_7_4_1 = new LegacyESVersion(7040199, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final LegacyESVersion V_7_4_2 = new LegacyESVersion(7040299, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final LegacyESVersion V_7_5_0 = new LegacyESVersion(7050099, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final LegacyESVersion V_7_5_1 = new LegacyESVersion(7050199, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final LegacyESVersion V_7_5_2 = new LegacyESVersion(7050299, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final LegacyESVersion V_7_6_0 = new LegacyESVersion(7060099, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final LegacyESVersion V_7_6_1 = new LegacyESVersion(7060199, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final LegacyESVersion V_7_6_2 = new LegacyESVersion(0x6BBB4B, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final LegacyESVersion V_7_7_0 = new LegacyESVersion(7070099, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final LegacyESVersion V_7_7_1 = new LegacyESVersion(7070199, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final LegacyESVersion V_7_8_0 = new LegacyESVersion(7080099, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final LegacyESVersion V_7_8_1 = new LegacyESVersion(7080199, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final LegacyESVersion V_7_9_0 = new LegacyESVersion(7090099, org.apache.lucene.util.Version.LUCENE_8_6_0);
    public static final LegacyESVersion V_7_9_1 = new LegacyESVersion(7090199, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final LegacyESVersion V_7_9_2 = new LegacyESVersion(7090299, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final LegacyESVersion V_7_9_3 = new LegacyESVersion(7090399, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final LegacyESVersion V_7_10_0 = new LegacyESVersion(7100099, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final LegacyESVersion V_7_10_1 = new LegacyESVersion(7100199, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final LegacyESVersion V_7_10_2 = new LegacyESVersion(7100299, org.apache.lucene.util.Version.LUCENE_8_7_0);
    protected static final Map<Integer, Version> idToVersion;
    protected static final Map<String, Version> stringToVersion;

    protected LegacyESVersion(int id, org.apache.lucene.util.Version luceneVersion) {
        super(id ^ 0x8000000, luceneVersion);
    }

    @Override
    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    @Override
    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public static Version fromString(String version) {
        if (!LegacyESVersion.stringHasLength(version)) {
            return Version.CURRENT;
        }
        Version cached = stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return LegacyESVersion.fromStringSlow(version);
    }

    static Version fromStringSlow(String version) {
        String[] parts;
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a alpha build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    @Override
    protected int maskId(int id) {
        return id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    static {
        HashMap<Integer, Version> builder = new HashMap<Integer, Version>();
        HashMap<String, Version> builderByString = new HashMap<String, Version>();
        for (Field declaredField : LegacyESVersion.class.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(Version.class) && !declaredField.getType().equals(LegacyESVersion.class) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+(_alpha[1,2]|_beta[1,2]|_rc[1,2])?")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED) {
                    String[] fields = fieldName.split("_");
                    if (fields.length == 5) {
                        assert ((fields[1].equals("1") || fields[1].equals("6")) && fields[2].equals("0")) : "field " + fieldName + " should not have a build qualifier";
                    } else {
                        int major = Integer.valueOf(fields[1]) * 1000000;
                        int minor = Integer.valueOf(fields[2]) * 10000;
                        int revision = Integer.valueOf(fields[3]) * 100;
                        int expectedId = major > 0 && major < 6000000 ? 0x8000000 ^ major + minor + revision + 99 : major + minor + revision + 99;
                        assert (version.id == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.id + "]";
                    }
                }
                Version maybePrevious = builder.put(version.id, version);
                builderByString.put(version.toString(), version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.id + "] to be uniquely mapped but saw [" + String.valueOf(maybePrevious) + "] and [" + String.valueOf(version) + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
            catch (RuntimeException e) {
                assert (false) : "Version field [" + fieldName + "] threw [" + String.valueOf(e) + "] during initialization";
            }
        }
        assert (LegacyESVersion.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + String.valueOf(org.apache.lucene.util.Version.LATEST) + "] is still set to [" + String.valueOf(LegacyESVersion.CURRENT.luceneVersion) + "]";
        builder.put(0, V_EMPTY);
        builderByString.put(V_EMPTY.toString(), V_EMPTY);
        idToVersion = Map.copyOf(builder);
        stringToVersion = Map.copyOf(builderByString);
    }
}

