/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrserverless.model.Architecture;
import com.amazonaws.services.emrserverless.model.AutoStartConfig;
import com.amazonaws.services.emrserverless.model.AutoStopConfig;
import com.amazonaws.services.emrserverless.model.Configuration;
import com.amazonaws.services.emrserverless.model.ImageConfigurationInput;
import com.amazonaws.services.emrserverless.model.InitialCapacityConfig;
import com.amazonaws.services.emrserverless.model.MaximumAllowedResources;
import com.amazonaws.services.emrserverless.model.MonitoringConfiguration;
import com.amazonaws.services.emrserverless.model.NetworkConfiguration;
import com.amazonaws.services.emrserverless.model.WorkerTypeSpecificationInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private String clientToken;
    private Map<String, InitialCapacityConfig> initialCapacity;
    private MaximumAllowedResources maximumCapacity;
    private AutoStartConfig autoStartConfiguration;
    private AutoStopConfig autoStopConfiguration;
    private NetworkConfiguration networkConfiguration;
    private String architecture;
    private ImageConfigurationInput imageConfiguration;
    private Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications;
    private String releaseLabel;
    private List<Configuration> runtimeConfiguration;
    private MonitoringConfiguration monitoringConfiguration;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public UpdateApplicationRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateApplicationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, InitialCapacityConfig> getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public UpdateApplicationRequest withInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        return this;
    }

    public UpdateApplicationRequest addInitialCapacityEntry(String key, InitialCapacityConfig value) {
        if (null == this.initialCapacity) {
            this.initialCapacity = new HashMap<String, InitialCapacityConfig>();
        }
        if (this.initialCapacity.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.initialCapacity.put(key, value);
        return this;
    }

    public UpdateApplicationRequest clearInitialCapacityEntries() {
        this.initialCapacity = null;
        return this;
    }

    public void setMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public MaximumAllowedResources getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public UpdateApplicationRequest withMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.setMaximumCapacity(maximumCapacity);
        return this;
    }

    public void setAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.autoStartConfiguration = autoStartConfiguration;
    }

    public AutoStartConfig getAutoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public UpdateApplicationRequest withAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.setAutoStartConfiguration(autoStartConfiguration);
        return this;
    }

    public void setAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.autoStopConfiguration = autoStopConfiguration;
    }

    public AutoStopConfig getAutoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public UpdateApplicationRequest withAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.setAutoStopConfiguration(autoStopConfiguration);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public UpdateApplicationRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public UpdateApplicationRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public UpdateApplicationRequest withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public void setImageConfiguration(ImageConfigurationInput imageConfiguration) {
        this.imageConfiguration = imageConfiguration;
    }

    public ImageConfigurationInput getImageConfiguration() {
        return this.imageConfiguration;
    }

    public UpdateApplicationRequest withImageConfiguration(ImageConfigurationInput imageConfiguration) {
        this.setImageConfiguration(imageConfiguration);
        return this;
    }

    public Map<String, WorkerTypeSpecificationInput> getWorkerTypeSpecifications() {
        return this.workerTypeSpecifications;
    }

    public void setWorkerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
        this.workerTypeSpecifications = workerTypeSpecifications;
    }

    public UpdateApplicationRequest withWorkerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
        this.setWorkerTypeSpecifications(workerTypeSpecifications);
        return this;
    }

    public UpdateApplicationRequest addWorkerTypeSpecificationsEntry(String key, WorkerTypeSpecificationInput value) {
        if (null == this.workerTypeSpecifications) {
            this.workerTypeSpecifications = new HashMap<String, WorkerTypeSpecificationInput>();
        }
        if (this.workerTypeSpecifications.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.workerTypeSpecifications.put(key, value);
        return this;
    }

    public UpdateApplicationRequest clearWorkerTypeSpecificationsEntries() {
        this.workerTypeSpecifications = null;
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public UpdateApplicationRequest withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public List<Configuration> getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void setRuntimeConfiguration(Collection<Configuration> runtimeConfiguration) {
        if (runtimeConfiguration == null) {
            this.runtimeConfiguration = null;
            return;
        }
        this.runtimeConfiguration = new ArrayList<Configuration>(runtimeConfiguration);
    }

    public UpdateApplicationRequest withRuntimeConfiguration(Configuration ... runtimeConfiguration) {
        if (this.runtimeConfiguration == null) {
            this.setRuntimeConfiguration(new ArrayList<Configuration>(runtimeConfiguration.length));
        }
        for (Configuration ele : runtimeConfiguration) {
            this.runtimeConfiguration.add(ele);
        }
        return this;
    }

    public UpdateApplicationRequest withRuntimeConfiguration(Collection<Configuration> runtimeConfiguration) {
        this.setRuntimeConfiguration(runtimeConfiguration);
        return this;
    }

    public void setMonitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
        this.monitoringConfiguration = monitoringConfiguration;
    }

    public MonitoringConfiguration getMonitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public UpdateApplicationRequest withMonitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
        this.setMonitoringConfiguration(monitoringConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInitialCapacity() != null) {
            sb.append("InitialCapacity: ").append(this.getInitialCapacity()).append(",");
        }
        if (this.getMaximumCapacity() != null) {
            sb.append("MaximumCapacity: ").append(this.getMaximumCapacity()).append(",");
        }
        if (this.getAutoStartConfiguration() != null) {
            sb.append("AutoStartConfiguration: ").append(this.getAutoStartConfiguration()).append(",");
        }
        if (this.getAutoStopConfiguration() != null) {
            sb.append("AutoStopConfiguration: ").append(this.getAutoStopConfiguration()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getImageConfiguration() != null) {
            sb.append("ImageConfiguration: ").append(this.getImageConfiguration()).append(",");
        }
        if (this.getWorkerTypeSpecifications() != null) {
            sb.append("WorkerTypeSpecifications: ").append(this.getWorkerTypeSpecifications()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getRuntimeConfiguration() != null) {
            sb.append("RuntimeConfiguration: ").append(this.getRuntimeConfiguration()).append(",");
        }
        if (this.getMonitoringConfiguration() != null) {
            sb.append("MonitoringConfiguration: ").append(this.getMonitoringConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInitialCapacity() == null ^ this.getInitialCapacity() == null) {
            return false;
        }
        if (other.getInitialCapacity() != null && !other.getInitialCapacity().equals(this.getInitialCapacity())) {
            return false;
        }
        if (other.getMaximumCapacity() == null ^ this.getMaximumCapacity() == null) {
            return false;
        }
        if (other.getMaximumCapacity() != null && !other.getMaximumCapacity().equals(this.getMaximumCapacity())) {
            return false;
        }
        if (other.getAutoStartConfiguration() == null ^ this.getAutoStartConfiguration() == null) {
            return false;
        }
        if (other.getAutoStartConfiguration() != null && !other.getAutoStartConfiguration().equals(this.getAutoStartConfiguration())) {
            return false;
        }
        if (other.getAutoStopConfiguration() == null ^ this.getAutoStopConfiguration() == null) {
            return false;
        }
        if (other.getAutoStopConfiguration() != null && !other.getAutoStopConfiguration().equals(this.getAutoStopConfiguration())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getImageConfiguration() == null ^ this.getImageConfiguration() == null) {
            return false;
        }
        if (other.getImageConfiguration() != null && !other.getImageConfiguration().equals(this.getImageConfiguration())) {
            return false;
        }
        if (other.getWorkerTypeSpecifications() == null ^ this.getWorkerTypeSpecifications() == null) {
            return false;
        }
        if (other.getWorkerTypeSpecifications() != null && !other.getWorkerTypeSpecifications().equals(this.getWorkerTypeSpecifications())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getRuntimeConfiguration() == null ^ this.getRuntimeConfiguration() == null) {
            return false;
        }
        if (other.getRuntimeConfiguration() != null && !other.getRuntimeConfiguration().equals(this.getRuntimeConfiguration())) {
            return false;
        }
        if (other.getMonitoringConfiguration() == null ^ this.getMonitoringConfiguration() == null) {
            return false;
        }
        return other.getMonitoringConfiguration() == null || other.getMonitoringConfiguration().equals(this.getMonitoringConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInitialCapacity() == null ? 0 : this.getInitialCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumCapacity() == null ? 0 : this.getMaximumCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStartConfiguration() == null ? 0 : this.getAutoStartConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStopConfiguration() == null ? 0 : this.getAutoStopConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getImageConfiguration() == null ? 0 : this.getImageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkerTypeSpecifications() == null ? 0 : this.getWorkerTypeSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeConfiguration() == null ? 0 : this.getRuntimeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringConfiguration() == null ? 0 : this.getMonitoringConfiguration().hashCode());
        return hashCode;
    }

    public UpdateApplicationRequest clone() {
        return (UpdateApplicationRequest)super.clone();
    }
}

