/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.sql;

import com.opencsv.CSVParserWriter;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.sql.SQLDBConfig;

public class SQLToCSV {
    private static final Logger logger = Logger.getLogger(SQLToCSV.class.getName());

    public static void main(String[] args) {
        String query;
        Serializable qsb;
        LabsLogFormatter.setAllLogFormatters();
        SQLToCSVOptions opts = new SQLToCSVOptions();
        try {
            ConfigurationManager cm = new ConfigurationManager(args, (Options)opts);
        }
        catch (UsageException e) {
            logger.info(e.getUsage());
            System.exit(1);
        }
        if (opts.dbConfig == null) {
            if (opts.connString == null) {
                logger.log(Level.SEVERE, "Must specify connection string with -n");
                System.exit(1);
            }
            if (!(opts.username == null && opts.password == null || opts.username != null && opts.password != null)) {
                logger.log(Level.SEVERE, "Must specify both of user and password with -u, -p if one is specified!");
                System.exit(1);
            }
        } else if (opts.username != null || opts.password != null || opts.connString != null) {
            logger.warning("dbConfig provided but username/password/connstring also provided. Options from -u, -p, -n being ignored");
        }
        try (BufferedReader br = opts.inputPath != null ? Files.newBufferedReader(opts.inputPath) : new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
            String l;
            qsb = new StringBuilder();
            while ((l = br.readLine()) != null) {
                ((StringBuilder)qsb).append(l);
                ((StringBuilder)qsb).append("\n");
            }
            query = ((StringBuilder)qsb).toString().trim();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error reading query: " + ex);
            System.exit(1);
            return;
        }
        if (query.isEmpty()) {
            logger.log(Level.SEVERE, "Query is empty string");
            System.exit(1);
        }
        Connection conn = null;
        try {
            conn = opts.dbConfig != null ? opts.dbConfig.getConnection() : (opts.username != null ? DriverManager.getConnection(opts.connString, opts.username, opts.password) : DriverManager.getConnection(opts.connString));
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, "Can't connect to database: " + opts.connString, ex);
            System.exit(1);
        }
        try {
            Statement stmt = conn.createStatement();
            qsb = null;
            try {
                ResultSet results;
                stmt.setFetchSize(1000);
                stmt.setFetchDirection(1000);
                try {
                    results = stmt.executeQuery(query);
                }
                catch (SQLException ex) {
                    logger.log(Level.SEVERE, "Error running query", ex);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex1) {
                        logger.log(Level.SEVERE, "Failed to close connection", ex1);
                    }
                    if (stmt != null) {
                        if (qsb != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)qsb).addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                    return;
                }
                try (CSVParserWriter writer = new CSVParserWriter((Writer)(opts.outputPath != null ? Files.newBufferedWriter(opts.outputPath, new OpenOption[0]) : new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), 0x100000)), (ICSVParser)new RFC4180Parser(), "\n");){
                    writer.writeAll(results, true);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Error writing CSV", ex);
                    System.exit(1);
                }
                catch (SQLException ex) {
                    logger.log(Level.SEVERE, "Error retrieving results", ex);
                    System.exit(1);
                }
            }
            catch (Throwable throwable) {
                qsb = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (qsb != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)qsb).addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, "Couldn't create statement", ex);
            try {
                conn.close();
            }
            catch (SQLException ex1) {
                logger.log(Level.SEVERE, "Failed to close connection", ex1);
            }
            System.exit(1);
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException ex1) {
            logger.log(Level.SEVERE, "Failed to close connection", ex1);
        }
    }

    public static class SQLToCSVOptions
    implements Options {
        @Option(charName=110, longName="connection", usage="Connection string to the SQL database")
        public String connString;
        @Option(charName=112, longName="password", usage="Password for the SQL database")
        public String password;
        @Option(charName=117, longName="username", usage="Username for the SQL database")
        public String username;
        @Option(charName=105, longName="input-sql", usage="SQL File to run as a query, defaults to stdin")
        public Path inputPath;
        @Option(charName=111, longName="output-csv", usage="File to write query results as CSV, defaults to stdout")
        public Path outputPath;
        @Option(longName="db-config", usage="Name of the DBConfig to use")
        public SQLDBConfig dbConfig;
    }
}

