/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.model;

public enum MLResultDataType {
    FLOAT32(Format.FLOATING, 4),
    FLOAT64(Format.FLOATING, 8),
    FLOAT16(Format.FLOATING, 2),
    UINT8(Format.UINT, 1),
    INT32(Format.INT, 4),
    INT8(Format.INT, 1),
    INT64(Format.INT, 8),
    BOOLEAN(Format.BOOLEAN, 1),
    UNKNOWN(Format.UNKNOWN, 0),
    STRING(Format.STRING, -1);

    private Format format;
    private int numOfBytes;

    private MLResultDataType(Format format, int numOfBytes) {
        this.format = format;
        this.numOfBytes = numOfBytes;
    }

    public boolean isFloating() {
        return this.format == Format.FLOATING;
    }

    public boolean isInteger() {
        return this.format == Format.UINT || this.format == Format.INT;
    }

    public boolean isBoolean() {
        return this.format == Format.BOOLEAN;
    }

    public boolean isString() {
        return this.format == Format.STRING;
    }

    public static enum Format {
        FLOATING,
        UINT,
        INT,
        BOOLEAN,
        STRING,
        UNKNOWN;

    }
}

