# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("tapi32.dll")
prototypes = \
    {
        #
        'lineAccept': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpsUserUserInfo", "dwSize"]),
        #
        'lineAddProvider': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszProviderFilename", "hwndOwner", "lpdwPermanentProviderID"]),
        #
        'lineAddProviderA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszProviderFilename", "hwndOwner", "lpdwPermanentProviderID"]),
        #
        'lineAddProviderW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszProviderFilename", "hwndOwner", "lpdwPermanentProviderID"]),
        #
        'lineAddToConference': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hConfCall", "hConsultCall"]),
        #
        'lineAgentSpecific': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "dwAgentExtensionIDIndex", "lpParams", "dwSize"]),
        #
        'lineAnswer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpsUserUserInfo", "dwSize"]),
        #
        'lineBlindTransfer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineBlindTransferA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineBlindTransferW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddressW", "dwCountryCode"]),
        #
        'lineClose': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine"]),
        #
        'lineCompleteCall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpdwCompletionID", "dwCompletionMode", "dwMessageID"]),
        #
        'lineCompleteTransfer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "hConsultCall", "lphConfCall", "dwTransferMode"]),
        #
        'lineConfigDialog': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'lineConfigDialogA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'lineConfigDialogW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'lineConfigDialogEdit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass", "lpDeviceConfigIn", "dwSize", "lpDeviceConfigOut"]),
        #
        'lineConfigDialogEditA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass", "lpDeviceConfigIn", "dwSize", "lpDeviceConfigOut"]),
        #
        'lineConfigDialogEditW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass", "lpDeviceConfigIn", "dwSize", "lpDeviceConfigOut"]),
        #
        'lineConfigProvider': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndOwner", "dwPermanentProviderID"]),
        #
        'lineCreateAgentW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpszAgentID", "lpszAgentPIN", "lphAgent"]),
        #
        'lineCreateAgentA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpszAgentID", "lpszAgentPIN", "lphAgent"]),
        #
        'lineCreateAgentSessionW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "lpszAgentPIN", "dwWorkingAddressID", "lpGroupID", "lphAgentSession"]),
        #
        'lineCreateAgentSessionA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "lpszAgentPIN", "dwWorkingAddressID", "lpGroupID", "lphAgentSession"]),
        #
        'lineDeallocateCall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineDevSpecific': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "lpParams", "dwSize"]),
        #
        'lineDevSpecificFeature': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwFeature", "lpParams", "dwSize"]),
        #
        'lineDial': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineDialA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineDialW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineDrop': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpsUserUserInfo", "dwSize"]),
        #
        'lineForward': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "ForwardList": SimTypePointer(SimStruct({"dwForwardMode": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDestCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEFORWARD", pack=False, align=None), offset=0)}, name="LINEFORWARDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "bAllAddresses", "dwAddressID", "lpForwardList", "dwNumRingsNoAnswer", "lphConsultCall", "lpCallParams"]),
        #
        'lineForwardA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "ForwardList": SimTypePointer(SimStruct({"dwForwardMode": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDestCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEFORWARD", pack=False, align=None), offset=0)}, name="LINEFORWARDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "bAllAddresses", "dwAddressID", "lpForwardList", "dwNumRingsNoAnswer", "lphConsultCall", "lpCallParams"]),
        #
        'lineForwardW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "ForwardList": SimTypePointer(SimStruct({"dwForwardMode": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDestCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDestAddressOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEFORWARD", pack=False, align=None), offset=0)}, name="LINEFORWARDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "bAllAddresses", "dwAddressID", "lpForwardList", "dwNumRingsNoAnswer", "lphConsultCall", "lpCallParams"]),
        #
        'lineGatherDigits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitModes", "lpsDigits", "dwNumDigits", "lpszTerminationDigits", "dwFirstDigitTimeout", "dwInterDigitTimeout"]),
        #
        'lineGatherDigitsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitModes", "lpsDigits", "dwNumDigits", "lpszTerminationDigits", "dwFirstDigitTimeout", "dwInterDigitTimeout"]),
        #
        'lineGatherDigitsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitModes", "lpsDigits", "dwNumDigits", "lpszTerminationDigits", "dwFirstDigitTimeout", "dwInterDigitTimeout"]),
        #
        'lineGenerateDigits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitMode", "lpszDigits", "dwDuration"]),
        #
        'lineGenerateDigitsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitMode", "lpszDigits", "dwDuration"]),
        #
        'lineGenerateDigitsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitMode", "lpszDigits", "dwDuration"]),
        #
        'lineGenerateTone': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwFrequency": SimTypeInt(signed=False, label="UInt32"), "dwCadenceOn": SimTypeInt(signed=False, label="UInt32"), "dwCadenceOff": SimTypeInt(signed=False, label="UInt32"), "dwVolume": SimTypeInt(signed=False, label="UInt32")}, name="LINEGENERATETONE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwToneMode", "dwDuration", "dwNumTones", "lpTones"]),
        #
        'lineGetAddressCaps': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressSharing": SimTypeInt(signed=False, label="UInt32"), "dwAddressStates": SimTypeInt(signed=False, label="UInt32"), "dwCallInfoStates": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwDialToneModes": SimTypeInt(signed=False, label="UInt32"), "dwBusyModes": SimTypeInt(signed=False, label="UInt32"), "dwSpecialInfo": SimTypeInt(signed=False, label="UInt32"), "dwDisconnectModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldPendingCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumConference": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumTransConf": SimTypeInt(signed=False, label="UInt32"), "dwAddrCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfCaps": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfState": SimTypeInt(signed=False, label="UInt32"), "dwTransferModes": SimTypeInt(signed=False, label="UInt32"), "dwParkModes": SimTypeInt(signed=False, label="UInt32"), "dwForwardModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxForwardEntries": SimTypeInt(signed=False, label="UInt32"), "dwMaxSpecificEntries": SimTypeInt(signed=False, label="UInt32"), "dwMinFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionConds": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionModes": SimTypeInt(signed=False, label="UInt32"), "dwNumCompletionMessages": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextSize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwNumCallTreatments": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListSize": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures2": SimTypeInt(signed=False, label="UInt32"), "dwMaxNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwConnectedModes": SimTypeInt(signed=False, label="UInt32"), "dwOfferingModes": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAddressID", "dwAPIVersion", "dwExtVersion", "lpAddressCaps"]),
        #
        'lineGetAddressCapsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressSharing": SimTypeInt(signed=False, label="UInt32"), "dwAddressStates": SimTypeInt(signed=False, label="UInt32"), "dwCallInfoStates": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwDialToneModes": SimTypeInt(signed=False, label="UInt32"), "dwBusyModes": SimTypeInt(signed=False, label="UInt32"), "dwSpecialInfo": SimTypeInt(signed=False, label="UInt32"), "dwDisconnectModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldPendingCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumConference": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumTransConf": SimTypeInt(signed=False, label="UInt32"), "dwAddrCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfCaps": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfState": SimTypeInt(signed=False, label="UInt32"), "dwTransferModes": SimTypeInt(signed=False, label="UInt32"), "dwParkModes": SimTypeInt(signed=False, label="UInt32"), "dwForwardModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxForwardEntries": SimTypeInt(signed=False, label="UInt32"), "dwMaxSpecificEntries": SimTypeInt(signed=False, label="UInt32"), "dwMinFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionConds": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionModes": SimTypeInt(signed=False, label="UInt32"), "dwNumCompletionMessages": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextSize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwNumCallTreatments": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListSize": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures2": SimTypeInt(signed=False, label="UInt32"), "dwMaxNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwConnectedModes": SimTypeInt(signed=False, label="UInt32"), "dwOfferingModes": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAddressID", "dwAPIVersion", "dwExtVersion", "lpAddressCaps"]),
        #
        'lineGetAddressCapsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressSharing": SimTypeInt(signed=False, label="UInt32"), "dwAddressStates": SimTypeInt(signed=False, label="UInt32"), "dwCallInfoStates": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwDialToneModes": SimTypeInt(signed=False, label="UInt32"), "dwBusyModes": SimTypeInt(signed=False, label="UInt32"), "dwSpecialInfo": SimTypeInt(signed=False, label="UInt32"), "dwDisconnectModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumOnHoldPendingCalls": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumConference": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumTransConf": SimTypeInt(signed=False, label="UInt32"), "dwAddrCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfCaps": SimTypeInt(signed=False, label="UInt32"), "dwRemoveFromConfState": SimTypeInt(signed=False, label="UInt32"), "dwTransferModes": SimTypeInt(signed=False, label="UInt32"), "dwParkModes": SimTypeInt(signed=False, label="UInt32"), "dwForwardModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxForwardEntries": SimTypeInt(signed=False, label="UInt32"), "dwMaxSpecificEntries": SimTypeInt(signed=False, label="UInt32"), "dwMinFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxFwdNumRings": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionConds": SimTypeInt(signed=False, label="UInt32"), "dwCallCompletionModes": SimTypeInt(signed=False, label="UInt32"), "dwNumCompletionMessages": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextSize": SimTypeInt(signed=False, label="UInt32"), "dwCompletionMsgTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwNumCallTreatments": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListSize": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatmentListOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwMaxCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures2": SimTypeInt(signed=False, label="UInt32"), "dwMaxNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwConnectedModes": SimTypeInt(signed=False, label="UInt32"), "dwOfferingModes": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAddressID", "dwAPIVersion", "dwExtVersion", "lpAddressCaps"]),
        #
        'lineGetAddressID': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpdwAddressID", "dwAddressMode", "lpsAddress", "dwSize"]),
        #
        'lineGetAddressIDA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpdwAddressID", "dwAddressMode", "lpsAddress", "dwSize"]),
        #
        'lineGetAddressIDW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpdwAddressID", "dwAddressMode", "lpsAddress", "dwSize"]),
        #
        'lineGetAddressStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumInUse": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumRingsNoAnswer": SimTypeInt(signed=False, label="UInt32"), "dwForwardNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwForwardSize": SimTypeInt(signed=False, label="UInt32"), "dwForwardOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAddressStatus"]),
        #
        'lineGetAddressStatusA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumInUse": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumRingsNoAnswer": SimTypeInt(signed=False, label="UInt32"), "dwForwardNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwForwardSize": SimTypeInt(signed=False, label="UInt32"), "dwForwardOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAddressStatus"]),
        #
        'lineGetAddressStatusW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumInUse": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwAddressFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumRingsNoAnswer": SimTypeInt(signed=False, label="UInt32"), "dwForwardNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwForwardSize": SimTypeInt(signed=False, label="UInt32"), "dwForwardOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEADDRESSSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAddressStatus"]),
        #
        'lineGetAgentActivityListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTACTIVITYLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentActivityList"]),
        #
        'lineGetAgentActivityListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTACTIVITYLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentActivityList"]),
        #
        'lineGetAgentCapsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwCapsVersion": SimTypeInt(signed=False, label="UInt32"), "dwFeatures": SimTypeInt(signed=False, label="UInt32"), "dwStates": SimTypeInt(signed=False, label="UInt32"), "dwNextStates": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumGroupEntries": SimTypeInt(signed=False, label="UInt32"), "dwAgentStatusMessages": SimTypeInt(signed=False, label="UInt32"), "dwNumAgentExtensionIDs": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListOffset": SimTypeInt(signed=False, label="UInt32"), "ProxyGUID": SimTypeBottom(label="Guid")}, name="LINEAGENTCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAddressID", "dwAppAPIVersion", "lpAgentCaps"]),
        #
        'lineGetAgentCapsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwCapsVersion": SimTypeInt(signed=False, label="UInt32"), "dwFeatures": SimTypeInt(signed=False, label="UInt32"), "dwStates": SimTypeInt(signed=False, label="UInt32"), "dwNextStates": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumGroupEntries": SimTypeInt(signed=False, label="UInt32"), "dwAgentStatusMessages": SimTypeInt(signed=False, label="UInt32"), "dwNumAgentExtensionIDs": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListOffset": SimTypeInt(signed=False, label="UInt32"), "ProxyGUID": SimTypeBottom(label="Guid")}, name="LINEAGENTCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAddressID", "dwAppAPIVersion", "lpAgentCaps"]),
        #
        'lineGetAgentGroupListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentGroupList"]),
        #
        'lineGetAgentGroupListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentGroupList"]),
        #
        'lineGetAgentInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentState": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32"), "cyOverallCallRate": SimTypeBottom(label="CY"), "dwNumberOfACDCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfIncomingCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfOutgoingCalls": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDCallTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDWrapUpTime": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "lpAgentInfo"]),
        #
        'lineGetAgentSessionInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentSessionState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentSessionState": SimTypeInt(signed=False, label="UInt32"), "dateSessionStartTime": SimTypeFloat(size=64), "dwSessionDuration": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfCalls": SimTypeInt(signed=False, label="UInt32"), "dwTotalTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageCallTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalWrapUpTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageWrapUpTime": SimTypeInt(signed=False, label="UInt32"), "cyACDCallRate": SimTypeBottom(label="CY"), "dwLongestTimeToAnswer": SimTypeInt(signed=False, label="UInt32"), "dwAverageTimeToAnswer": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSESSIONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgentSession", "lpAgentSessionInfo"]),
        #
        'lineGetAgentSessionList': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSESSIONLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "lpAgentSessionList"]),
        #
        'lineGetAgentStatusA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwGroupListSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupListOffset": SimTypeInt(signed=False, label="UInt32"), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwNextState": SimTypeInt(signed=False, label="UInt32"), "dwActivityID": SimTypeInt(signed=False, label="UInt32"), "dwActivitySize": SimTypeInt(signed=False, label="UInt32"), "dwActivityOffset": SimTypeInt(signed=False, label="UInt32"), "dwAgentFeatures": SimTypeInt(signed=False, label="UInt32"), "dwValidStates": SimTypeInt(signed=False, label="UInt32"), "dwValidNextStates": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentStatus"]),
        #
        'lineGetAgentStatusW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwGroupListSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupListOffset": SimTypeInt(signed=False, label="UInt32"), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwNextState": SimTypeInt(signed=False, label="UInt32"), "dwActivityID": SimTypeInt(signed=False, label="UInt32"), "dwActivitySize": SimTypeInt(signed=False, label="UInt32"), "dwActivityOffset": SimTypeInt(signed=False, label="UInt32"), "dwAgentFeatures": SimTypeInt(signed=False, label="UInt32"), "dwValidStates": SimTypeInt(signed=False, label="UInt32"), "dwValidNextStates": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentStatus"]),
        #
        'lineGetAppPriority': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpExtensionName", "lpdwPriority"]),
        #
        'lineGetAppPriorityA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpExtensionName", "lpdwPriority"]),
        #
        'lineGetAppPriorityW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpExtensionName", "lpdwPriority"]),
        #
        'lineGetCallInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "hLine": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwAppSpecific": SimTypeInt(signed=False, label="UInt32"), "dwCallID": SimTypeInt(signed=False, label="UInt32"), "dwRelatedCallID": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorMediaModes": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigin": SimTypeInt(signed=False, label="UInt32"), "dwReason": SimTypeInt(signed=False, label="UInt32"), "dwCompletionID": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwTrunk": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwAppNameSize": SimTypeInt(signed=False, label="UInt32"), "dwAppNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatment": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallInfo"]),
        #
        'lineGetCallInfoA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "hLine": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwAppSpecific": SimTypeInt(signed=False, label="UInt32"), "dwCallID": SimTypeInt(signed=False, label="UInt32"), "dwRelatedCallID": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorMediaModes": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigin": SimTypeInt(signed=False, label="UInt32"), "dwReason": SimTypeInt(signed=False, label="UInt32"), "dwCompletionID": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwTrunk": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwAppNameSize": SimTypeInt(signed=False, label="UInt32"), "dwAppNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatment": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallInfo"]),
        #
        'lineGetCallInfoW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "hLine": SimTypeInt(signed=False, label="UInt32"), "dwLineDeviceID": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwAppSpecific": SimTypeInt(signed=False, label="UInt32"), "dwCallID": SimTypeInt(signed=False, label="UInt32"), "dwRelatedCallID": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorMediaModes": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigin": SimTypeInt(signed=False, label="UInt32"), "dwReason": SimTypeInt(signed=False, label="UInt32"), "dwCompletionID": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwTrunk": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCallerIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwCalledIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwConnectedIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectionIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDFlags": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameSize": SimTypeInt(signed=False, label="UInt32"), "dwRedirectingIDNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwAppNameSize": SimTypeInt(signed=False, label="UInt32"), "dwAppNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwChargingInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallTreatment": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallInfo"]),
        #
        'lineGetCallStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwCallState": SimTypeInt(signed=False, label="UInt32"), "dwCallStateMode": SimTypeInt(signed=False, label="UInt32"), "dwCallPrivilege": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallFeatures2": SimTypeInt(signed=False, label="UInt32"), "tStateEntryTime": SimTypeBottom(label="SYSTEMTIME")}, name="LINECALLSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallStatus"]),
        #
        'lineGetConfRelatedCalls': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwCallsNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwCallsSize": SimTypeInt(signed=False, label="UInt32"), "dwCallsOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallList"]),
        #
        'lineGetCountry': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumCountries": SimTypeInt(signed=False, label="UInt32"), "dwCountryListSize": SimTypeInt(signed=False, label="UInt32"), "dwCountryListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECOUNTRYLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCountryID", "dwAPIVersion", "lpLineCountryList"]),
        #
        'lineGetCountryA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumCountries": SimTypeInt(signed=False, label="UInt32"), "dwCountryListSize": SimTypeInt(signed=False, label="UInt32"), "dwCountryListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECOUNTRYLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCountryID", "dwAPIVersion", "lpLineCountryList"]),
        #
        'lineGetCountryW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumCountries": SimTypeInt(signed=False, label="UInt32"), "dwCountryListSize": SimTypeInt(signed=False, label="UInt32"), "dwCountryListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECOUNTRYLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCountryID", "dwAPIVersion", "lpLineCountryList"]),
        #
        'lineGetDevCaps': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentLineID": SimTypeInt(signed=False, label="UInt32"), "dwLineNameSize": SimTypeInt(signed=False, label="UInt32"), "dwLineNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwAddressModes": SimTypeInt(signed=False, label="UInt32"), "dwNumAddresses": SimTypeInt(signed=False, label="UInt32"), "dwBearerModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwGenerateDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMinTimeout": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMaxTimeout": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlDigitMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlMediaMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlToneMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlCallStateMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwDevCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwAnswerMode": SimTypeInt(signed=False, label="UInt32"), "dwRingModes": SimTypeInt(signed=False, label="UInt32"), "dwLineStates": SimTypeInt(signed=False, label="UInt32"), "dwUUIAcceptSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIAnswerSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIMakeCallSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIDropSize": SimTypeInt(signed=False, label="UInt32"), "dwUUISendUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUUICallInfoSize": SimTypeInt(signed=False, label="UInt32"), "MinDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "MaxDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "DefaultDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwNumTerminals": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableDevStatus": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "PermanentLineGuid": SimTypeBottom(label="Guid")}, name="LINEDEVCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpLineDevCaps"]),
        #
        'lineGetDevCapsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentLineID": SimTypeInt(signed=False, label="UInt32"), "dwLineNameSize": SimTypeInt(signed=False, label="UInt32"), "dwLineNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwAddressModes": SimTypeInt(signed=False, label="UInt32"), "dwNumAddresses": SimTypeInt(signed=False, label="UInt32"), "dwBearerModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwGenerateDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMinTimeout": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMaxTimeout": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlDigitMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlMediaMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlToneMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlCallStateMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwDevCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwAnswerMode": SimTypeInt(signed=False, label="UInt32"), "dwRingModes": SimTypeInt(signed=False, label="UInt32"), "dwLineStates": SimTypeInt(signed=False, label="UInt32"), "dwUUIAcceptSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIAnswerSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIMakeCallSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIDropSize": SimTypeInt(signed=False, label="UInt32"), "dwUUISendUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUUICallInfoSize": SimTypeInt(signed=False, label="UInt32"), "MinDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "MaxDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "DefaultDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwNumTerminals": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableDevStatus": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "PermanentLineGuid": SimTypeBottom(label="Guid")}, name="LINEDEVCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpLineDevCaps"]),
        #
        'lineGetDevCapsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwSwitchInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentLineID": SimTypeInt(signed=False, label="UInt32"), "dwLineNameSize": SimTypeInt(signed=False, label="UInt32"), "dwLineNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwAddressModes": SimTypeInt(signed=False, label="UInt32"), "dwNumAddresses": SimTypeInt(signed=False, label="UInt32"), "dwBearerModes": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneModes": SimTypeInt(signed=False, label="UInt32"), "dwGenerateToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwGenerateDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumFreq": SimTypeInt(signed=False, label="UInt32"), "dwMonitorToneMaxNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwMonitorDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMinTimeout": SimTypeInt(signed=False, label="UInt32"), "dwGatherDigitsMaxTimeout": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlDigitMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlMediaMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlToneMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwMedCtlCallStateMaxListSize": SimTypeInt(signed=False, label="UInt32"), "dwDevCapFlags": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwAnswerMode": SimTypeInt(signed=False, label="UInt32"), "dwRingModes": SimTypeInt(signed=False, label="UInt32"), "dwLineStates": SimTypeInt(signed=False, label="UInt32"), "dwUUIAcceptSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIAnswerSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIMakeCallSize": SimTypeInt(signed=False, label="UInt32"), "dwUUIDropSize": SimTypeInt(signed=False, label="UInt32"), "dwUUISendUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUUICallInfoSize": SimTypeInt(signed=False, label="UInt32"), "MinDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "MaxDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "DefaultDialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwNumTerminals": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalCapsOffset": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextEntrySize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableDevStatus": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "PermanentLineGuid": SimTypeBottom(label="Guid")}, name="LINEDEVCAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpLineDevCaps"]),
        #
        'lineGetDevConfig': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "lpszDeviceClass"]),
        #
        'lineGetDevConfigA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "lpszDeviceClass"]),
        #
        'lineGetDevConfigW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "lpszDeviceClass"]),
        #
        'lineGetGroupListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpGroupList"]),
        #
        'lineGetGroupListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpGroupList"]),
        #
        'lineGetIcon': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'lineGetIconA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'lineGetIconW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'lineGetID': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "dwSelect", "lpDeviceID", "lpszDeviceClass"]),
        #
        'lineGetIDA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "dwSelect", "lpDeviceID", "lpszDeviceClass"]),
        #
        'lineGetIDW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "dwSelect", "lpDeviceID", "lpszDeviceClass"]),
        #
        'lineGetLineDevStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumOpens": SimTypeInt(signed=False, label="UInt32"), "dwOpenMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwSignalLevel": SimTypeInt(signed=False, label="UInt32"), "dwBatteryLevel": SimTypeInt(signed=False, label="UInt32"), "dwRoamMode": SimTypeInt(signed=False, label="UInt32"), "dwDevStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEDEVSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpLineDevStatus"]),
        #
        'lineGetLineDevStatusA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumOpens": SimTypeInt(signed=False, label="UInt32"), "dwOpenMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwSignalLevel": SimTypeInt(signed=False, label="UInt32"), "dwBatteryLevel": SimTypeInt(signed=False, label="UInt32"), "dwRoamMode": SimTypeInt(signed=False, label="UInt32"), "dwDevStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEDEVSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpLineDevStatus"]),
        #
        'lineGetLineDevStatusW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumOpens": SimTypeInt(signed=False, label="UInt32"), "dwOpenMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwNumActiveCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumOnHoldPendCalls": SimTypeInt(signed=False, label="UInt32"), "dwLineFeatures": SimTypeInt(signed=False, label="UInt32"), "dwNumCallCompletions": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwSignalLevel": SimTypeInt(signed=False, label="UInt32"), "dwBatteryLevel": SimTypeInt(signed=False, label="UInt32"), "dwRoamMode": SimTypeInt(signed=False, label="UInt32"), "dwDevStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesSize": SimTypeInt(signed=False, label="UInt32"), "dwTerminalModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwAvailableMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAppInfoOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEDEVSTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpLineDevStatus"]),
        #
        'lineGetMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"hDevice": SimTypeInt(signed=False, label="UInt32"), "dwMessageID": SimTypeInt(signed=False, label="UInt32"), "dwCallbackInstance": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam3": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="LINEMESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "lpMessage", "dwTimeout"]),
        #
        'lineGetNewCalls': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwCallsNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwCallsSize": SimTypeInt(signed=False, label="UInt32"), "dwCallsOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "dwSelect", "lpCallList"]),
        #
        'lineGetNumRings': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpdwNumRings"]),
        #
        'lineGetProviderList': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumProviders": SimTypeInt(signed=False, label="UInt32"), "dwProviderListSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEPROVIDERLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwAPIVersion", "lpProviderList"]),
        #
        'lineGetProviderListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumProviders": SimTypeInt(signed=False, label="UInt32"), "dwProviderListSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEPROVIDERLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwAPIVersion", "lpProviderList"]),
        #
        'lineGetProviderListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumProviders": SimTypeInt(signed=False, label="UInt32"), "dwProviderListSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEPROVIDERLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwAPIVersion", "lpProviderList"]),
        #
        'lineGetProxyStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEPROXYREQUESTLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAppAPIVersion", "lpLineProxyReqestList"]),
        #
        'lineGetQueueInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsQueued": SimTypeInt(signed=False, label="UInt32"), "dwCurrentCallsQueued": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsAbandoned": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsFlowedIn": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsFlowedOut": SimTypeInt(signed=False, label="UInt32"), "dwLongestEverWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwCurrentLongestWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwFinalDisposition": SimTypeInt(signed=False, label="UInt32")}, name="LINEQUEUEINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwQueueID", "lpLineQueueInfo"]),
        #
        'lineGetQueueListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEQUEUELIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpGroupID", "lpQueueList"]),
        #
        'lineGetQueueListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEQUEUELIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpGroupID", "lpQueueList"]),
        #
        'lineGetRequest': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwRequestMode", "lpRequestBuffer"]),
        #
        'lineGetRequestA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwRequestMode", "lpRequestBuffer"]),
        #
        'lineGetRequestW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwRequestMode", "lpRequestBuffer"]),
        #
        'lineGetStatusMessages': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpdwLineStates", "lpdwAddressStates"]),
        #
        'lineGetTranslateCaps': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumLocations": SimTypeInt(signed=False, label="UInt32"), "dwLocationListSize": SimTypeInt(signed=False, label="UInt32"), "dwLocationListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentLocationID": SimTypeInt(signed=False, label="UInt32"), "dwNumCards": SimTypeInt(signed=False, label="UInt32"), "dwCardListSize": SimTypeInt(signed=False, label="UInt32"), "dwCardListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentPreferredCardID": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwAPIVersion", "lpTranslateCaps"]),
        #
        'lineGetTranslateCapsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumLocations": SimTypeInt(signed=False, label="UInt32"), "dwLocationListSize": SimTypeInt(signed=False, label="UInt32"), "dwLocationListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentLocationID": SimTypeInt(signed=False, label="UInt32"), "dwNumCards": SimTypeInt(signed=False, label="UInt32"), "dwCardListSize": SimTypeInt(signed=False, label="UInt32"), "dwCardListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentPreferredCardID": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwAPIVersion", "lpTranslateCaps"]),
        #
        'lineGetTranslateCapsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumLocations": SimTypeInt(signed=False, label="UInt32"), "dwLocationListSize": SimTypeInt(signed=False, label="UInt32"), "dwLocationListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentLocationID": SimTypeInt(signed=False, label="UInt32"), "dwNumCards": SimTypeInt(signed=False, label="UInt32"), "dwCardListSize": SimTypeInt(signed=False, label="UInt32"), "dwCardListOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentPreferredCardID": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwAPIVersion", "lpTranslateCaps"]),
        #
        'lineHandoff': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszFileName", "dwMediaMode"]),
        #
        'lineHandoffA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszFileName", "dwMediaMode"]),
        #
        'lineHandoffW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszFileName", "dwMediaMode"]),
        #
        'lineHold': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineInitialize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphLineApp", "hInstance", "lpfnCallback", "lpszAppName", "lpdwNumDevs"]),
        #
        'lineInitializeExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "Handles": SimUnion({"hEvent": SimTypeBottom(label="HANDLE"), "hCompletionPort": SimTypeBottom(label="HANDLE")}, name="<anon>", label="None"), "dwCompletionKey": SimTypeInt(signed=False, label="UInt32")}, name="LINEINITIALIZEEXPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphLineApp", "hInstance", "lpfnCallback", "lpszFriendlyAppName", "lpdwNumDevs", "lpdwAPIVersion", "lpLineInitializeExParams"]),
        #
        'lineInitializeExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "Handles": SimUnion({"hEvent": SimTypeBottom(label="HANDLE"), "hCompletionPort": SimTypeBottom(label="HANDLE")}, name="<anon>", label="None"), "dwCompletionKey": SimTypeInt(signed=False, label="UInt32")}, name="LINEINITIALIZEEXPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphLineApp", "hInstance", "lpfnCallback", "lpszFriendlyAppName", "lpdwNumDevs", "lpdwAPIVersion", "lpLineInitializeExParams"]),
        #
        'lineMakeCall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lphCall", "lpszDestAddress", "dwCountryCode", "lpCallParams"]),
        #
        'lineMakeCallA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lphCall", "lpszDestAddress", "dwCountryCode", "lpCallParams"]),
        #
        'lineMakeCallW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lphCall", "lpszDestAddress", "dwCountryCode", "lpCallParams"]),
        #
        'lineMonitorDigits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwDigitModes"]),
        #
        'lineMonitorMedia': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwMediaModes"]),
        #
        'lineMonitorTones': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwAppSpecific": SimTypeInt(signed=False, label="UInt32"), "dwDuration": SimTypeInt(signed=False, label="UInt32"), "dwFrequency1": SimTypeInt(signed=False, label="UInt32"), "dwFrequency2": SimTypeInt(signed=False, label="UInt32"), "dwFrequency3": SimTypeInt(signed=False, label="UInt32")}, name="LINEMONITORTONE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpToneList", "dwNumEntries"]),
        #
        'lineNegotiateAPIVersion': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPILowVersion", "dwAPIHighVersion", "lpdwAPIVersion", "lpExtensionID"]),
        #
        'lineNegotiateExtVersion': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "dwExtLowVersion", "dwExtHighVersion", "lpdwExtVersion"]),
        #
        'lineOpen': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lphLine", "dwAPIVersion", "dwExtVersion", "dwCallbackInstance", "dwPrivileges", "dwMediaModes", "lpCallParams"]),
        #
        'lineOpenA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lphLine", "dwAPIVersion", "dwExtVersion", "dwCallbackInstance", "dwPrivileges", "dwMediaModes", "lpCallParams"]),
        #
        'lineOpenW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lphLine", "dwAPIVersion", "dwExtVersion", "dwCallbackInstance", "dwPrivileges", "dwMediaModes", "lpCallParams"]),
        #
        'linePark': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwParkMode", "lpszDirAddress", "lpNonDirAddress"]),
        #
        'lineParkA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwParkMode", "lpszDirAddress", "lpNonDirAddress"]),
        #
        'lineParkW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwParkMode", "lpszDirAddress", "lpNonDirAddress"]),
        #
        'linePickup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress", "lpszGroupID"]),
        #
        'linePickupA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress", "lpszGroupID"]),
        #
        'linePickupW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress", "lpszGroupID"]),
        #
        'linePrepareAddToConference': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConfCall", "lphConsultCall", "lpCallParams"]),
        #
        'linePrepareAddToConferenceA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConfCall", "lphConsultCall", "lpCallParams"]),
        #
        'linePrepareAddToConferenceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConfCall", "lphConsultCall", "lpCallParams"]),
        #
        'lineProxyMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hCall", "dwMsg", "dwParam1", "dwParam2", "dwParam3"]),
        #
        'lineProxyResponse': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwClientMachineNameSize": SimTypeInt(signed=False, label="UInt32"), "dwClientMachineNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwClientUserNameSize": SimTypeInt(signed=False, label="UInt32"), "dwClientUserNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwClientAppAPIVersion": SimTypeInt(signed=False, label="UInt32"), "dwRequestType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"SetAgentGroup": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "GroupList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None)}, name="_SetAgentGroup_e__Struct", pack=False, align=None), "SetAgentState": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwAgentState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentState": SimTypeInt(signed=False, label="UInt32")}, name="_SetAgentState_e__Struct", pack=False, align=None), "SetAgentActivity": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwActivityID": SimTypeInt(signed=False, label="UInt32")}, name="_SetAgentActivity_e__Struct", pack=False, align=None), "GetAgentCaps": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "AgentCaps": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentHandlerInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwCapsVersion": SimTypeInt(signed=False, label="UInt32"), "dwFeatures": SimTypeInt(signed=False, label="UInt32"), "dwStates": SimTypeInt(signed=False, label="UInt32"), "dwNextStates": SimTypeInt(signed=False, label="UInt32"), "dwMaxNumGroupEntries": SimTypeInt(signed=False, label="UInt32"), "dwAgentStatusMessages": SimTypeInt(signed=False, label="UInt32"), "dwNumAgentExtensionIDs": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDListOffset": SimTypeInt(signed=False, label="UInt32"), "ProxyGUID": SimTypeBottom(label="Guid")}, name="LINEAGENTCAPS", pack=False, align=None)}, name="_GetAgentCaps_e__Struct", pack=False, align=None), "GetAgentStatus": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "AgentStatus": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwGroupListSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupListOffset": SimTypeInt(signed=False, label="UInt32"), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwNextState": SimTypeInt(signed=False, label="UInt32"), "dwActivityID": SimTypeInt(signed=False, label="UInt32"), "dwActivitySize": SimTypeInt(signed=False, label="UInt32"), "dwActivityOffset": SimTypeInt(signed=False, label="UInt32"), "dwAgentFeatures": SimTypeInt(signed=False, label="UInt32"), "dwValidStates": SimTypeInt(signed=False, label="UInt32"), "dwValidNextStates": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSTATUS", pack=False, align=None)}, name="_GetAgentStatus_e__Struct", pack=False, align=None), "AgentSpecific": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "dwAgentExtensionIDIndex": SimTypeInt(signed=False, label="UInt32"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "Params": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="_AgentSpecific_e__Struct", pack=False, align=None), "GetAgentActivityList": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "ActivityList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTACTIVITYLIST", pack=False, align=None)}, name="_GetAgentActivityList_e__Struct", pack=False, align=None), "GetAgentGroupList": SimStruct({"dwAddressID": SimTypeInt(signed=False, label="UInt32"), "GroupList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None)}, name="_GetAgentGroupList_e__Struct", pack=False, align=None), "CreateAgent": SimStruct({"hAgent": SimTypeInt(signed=False, label="UInt32"), "dwAgentIDSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentIDOffset": SimTypeInt(signed=False, label="UInt32"), "dwAgentPINSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentPINOffset": SimTypeInt(signed=False, label="UInt32")}, name="_CreateAgent_e__Struct", pack=False, align=None), "SetAgentStateEx": SimStruct({"hAgent": SimTypeInt(signed=False, label="UInt32"), "dwAgentState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentState": SimTypeInt(signed=False, label="UInt32")}, name="_SetAgentStateEx_e__Struct", pack=False, align=None), "SetAgentMeasurementPeriod": SimStruct({"hAgent": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32")}, name="_SetAgentMeasurementPeriod_e__Struct", pack=False, align=None), "GetAgentInfo": SimStruct({"hAgent": SimTypeInt(signed=False, label="UInt32"), "AgentInfo": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentState": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32"), "cyOverallCallRate": SimTypeBottom(label="CY"), "dwNumberOfACDCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfIncomingCalls": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfOutgoingCalls": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDCallTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalACDWrapUpTime": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTINFO", pack=False, align=None)}, name="_GetAgentInfo_e__Struct", pack=False, align=None), "CreateAgentSession": SimStruct({"hAgentSession": SimTypeInt(signed=False, label="UInt32"), "dwAgentPINSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentPINOffset": SimTypeInt(signed=False, label="UInt32"), "hAgent": SimTypeInt(signed=False, label="UInt32"), "GroupID": SimTypeBottom(label="Guid"), "dwWorkingAddressID": SimTypeInt(signed=False, label="UInt32")}, name="_CreateAgentSession_e__Struct", pack=False, align=None), "GetAgentSessionList": SimStruct({"hAgent": SimTypeInt(signed=False, label="UInt32"), "SessionList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSESSIONLIST", pack=False, align=None)}, name="_GetAgentSessionList_e__Struct", pack=False, align=None), "GetAgentSessionInfo": SimStruct({"hAgentSession": SimTypeInt(signed=False, label="UInt32"), "SessionInfo": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwAgentSessionState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentSessionState": SimTypeInt(signed=False, label="UInt32"), "dateSessionStartTime": SimTypeFloat(size=64), "dwSessionDuration": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfCalls": SimTypeInt(signed=False, label="UInt32"), "dwTotalTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageTalkTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageCallTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalWrapUpTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageWrapUpTime": SimTypeInt(signed=False, label="UInt32"), "cyACDCallRate": SimTypeBottom(label="CY"), "dwLongestTimeToAnswer": SimTypeInt(signed=False, label="UInt32"), "dwAverageTimeToAnswer": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTSESSIONINFO", pack=False, align=None)}, name="_GetAgentSessionInfo_e__Struct", pack=False, align=None), "SetAgentSessionState": SimStruct({"hAgentSession": SimTypeInt(signed=False, label="UInt32"), "dwAgentSessionState": SimTypeInt(signed=False, label="UInt32"), "dwNextAgentSessionState": SimTypeInt(signed=False, label="UInt32")}, name="_SetAgentSessionState_e__Struct", pack=False, align=None), "GetQueueList": SimStruct({"GroupID": SimTypeBottom(label="Guid"), "QueueList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEQUEUELIST", pack=False, align=None)}, name="_GetQueueList_e__Struct", pack=False, align=None), "SetQueueMeasurementPeriod": SimStruct({"dwQueueID": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32")}, name="_SetQueueMeasurementPeriod_e__Struct", pack=False, align=None), "GetQueueInfo": SimStruct({"dwQueueID": SimTypeInt(signed=False, label="UInt32"), "QueueInfo": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwMeasurementPeriod": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsQueued": SimTypeInt(signed=False, label="UInt32"), "dwCurrentCallsQueued": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsAbandoned": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsFlowedIn": SimTypeInt(signed=False, label="UInt32"), "dwTotalCallsFlowedOut": SimTypeInt(signed=False, label="UInt32"), "dwLongestEverWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwCurrentLongestWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwAverageWaitTime": SimTypeInt(signed=False, label="UInt32"), "dwFinalDisposition": SimTypeInt(signed=False, label="UInt32")}, name="LINEQUEUEINFO", pack=False, align=None)}, name="_GetQueueInfo_e__Struct", pack=False, align=None), "GetGroupList": SimStruct({"GroupList": SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None)}, name="_GetGroupList_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="LINEPROXYREQUEST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "lpProxyRequest", "dwResult"]),
        #
        'lineRedirect': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineRedirectA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineRedirectW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpszDestAddress", "dwCountryCode"]),
        #
        'lineRegisterRequestRecipient': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwRegistrationInstance", "dwRequestMode", "bEnable"]),
        #
        'lineReleaseUserUserInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineRemoveFromConference': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineRemoveProvider': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwPermanentProviderID", "hwndOwner"]),
        #
        'lineSecureCall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineSendUserUserInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpsUserUserInfo", "dwSize"]),
        #
        'lineSetAgentActivity': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "dwActivityID"]),
        #
        'lineSetAgentGroup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "dwListSize": SimTypeInt(signed=False, label="UInt32"), "dwListOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINEAGENTGROUPLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lpAgentGroupList"]),
        #
        'lineSetAgentMeasurementPeriod': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "dwMeasurementPeriod"]),
        #
        'lineSetAgentSessionState': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgentSession", "dwAgentSessionState", "dwNextAgentSessionState"]),
        #
        'lineSetAgentStateEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "hAgent", "dwAgentState", "dwNextAgentState"]),
        #
        'lineSetAgentState': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "dwAgentState", "dwNextAgentState"]),
        #
        'lineSetAppPriority': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpszExtensionName", "dwPriority"]),
        #
        'lineSetAppPriorityA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpszExtensionName", "dwPriority"]),
        #
        'lineSetAppPriorityW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="LINEEXTENSIONID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszAppFilename", "dwMediaMode", "lpExtensionID", "dwRequestMode", "lpszExtensionName", "dwPriority"]),
        #
        'lineSetAppSpecific': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwAppSpecific"]),
        #
        'lineSetCallData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpCallData", "dwSize"]),
        #
        'lineSetCallParams': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwBearerMode", "dwMinRate", "dwMaxRate", "lpDialParams"]),
        #
        'lineSetCallPrivilege': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwCallPrivilege"]),
        #
        'lineSetCallQualityOfService': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lpSendingFlowspec", "dwSendingFlowspecSize", "lpReceivingFlowspec", "dwReceivingFlowspecSize"]),
        #
        'lineSetCallTreatment': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwTreatment"]),
        #
        'lineSetCurrentLocation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwLocation"]),
        #
        'lineSetDevConfig': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "dwSize", "lpszDeviceClass"]),
        #
        'lineSetDevConfigA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "dwSize", "lpszDeviceClass"]),
        #
        'lineSetDevConfigW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpDeviceConfig", "dwSize", "lpszDeviceClass"]),
        #
        'lineSetLineDevStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwStatusToChange", "fStatus"]),
        #
        'lineSetMediaControl': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwDigit": SimTypeInt(signed=False, label="UInt32"), "dwDigitModes": SimTypeInt(signed=False, label="UInt32"), "dwMediaControl": SimTypeInt(signed=False, label="UInt32")}, name="LINEMEDIACONTROLDIGIT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwMediaModes": SimTypeInt(signed=False, label="UInt32"), "dwDuration": SimTypeInt(signed=False, label="UInt32"), "dwMediaControl": SimTypeInt(signed=False, label="UInt32")}, name="LINEMEDIACONTROLMEDIA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwAppSpecific": SimTypeInt(signed=False, label="UInt32"), "dwDuration": SimTypeInt(signed=False, label="UInt32"), "dwFrequency1": SimTypeInt(signed=False, label="UInt32"), "dwFrequency2": SimTypeInt(signed=False, label="UInt32"), "dwFrequency3": SimTypeInt(signed=False, label="UInt32"), "dwMediaControl": SimTypeInt(signed=False, label="UInt32")}, name="LINEMEDIACONTROLTONE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwCallStates": SimTypeInt(signed=False, label="UInt32"), "dwMediaControl": SimTypeInt(signed=False, label="UInt32")}, name="LINEMEDIACONTROLCALLSTATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "dwSelect", "lpDigitList", "dwDigitNumEntries", "lpMediaList", "dwMediaNumEntries", "lpToneList", "dwToneNumEntries", "lpCallStateList", "dwCallStateNumEntries"]),
        #
        'lineSetMediaMode': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "dwMediaModes"]),
        #
        'lineSetQueueMeasurementPeriod': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwQueueID", "dwMeasurementPeriod"]),
        #
        'lineSetNumRings': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "dwNumRings"]),
        #
        'lineSetStatusMessages': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwLineStates", "dwAddressStates"]),
        #
        'lineSetTerminal': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "hCall", "dwSelect", "dwTerminalModes", "dwTerminalID", "bEnable"]),
        #
        'lineSetTollList': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lpszAddressIn", "dwTollListOption"]),
        #
        'lineSetTollListA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lpszAddressIn", "dwTollListOption"]),
        #
        'lineSetTollListW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "lpszAddressInW", "dwTollListOption"]),
        #
        'lineSetupConference': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "hLine", "lphConfCall", "lphConsultCall", "dwNumParties", "lpCallParams"]),
        #
        'lineSetupConferenceA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "hLine", "lphConfCall", "lphConsultCall", "dwNumParties", "lpCallParams"]),
        #
        'lineSetupConferenceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "hLine", "lphConfCall", "lphConsultCall", "dwNumParties", "lpCallParams"]),
        #
        'lineSetupTransfer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lphConsultCall", "lpCallParams"]),
        #
        'lineSetupTransferA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lphConsultCall", "lpCallParams"]),
        #
        'lineSetupTransferW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwBearerMode": SimTypeInt(signed=False, label="UInt32"), "dwMinRate": SimTypeInt(signed=False, label="UInt32"), "dwMaxRate": SimTypeInt(signed=False, label="UInt32"), "dwMediaMode": SimTypeInt(signed=False, label="UInt32"), "dwCallParamFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressMode": SimTypeInt(signed=False, label="UInt32"), "dwAddressID": SimTypeInt(signed=False, label="UInt32"), "DialParams": SimStruct({"dwDialPause": SimTypeInt(signed=False, label="UInt32"), "dwDialSpeed": SimTypeInt(signed=False, label="UInt32"), "dwDigitDuration": SimTypeInt(signed=False, label="UInt32"), "dwWaitForDialtone": SimTypeInt(signed=False, label="UInt32")}, name="LINEDIALPARAMS", pack=False, align=None), "dwOrigAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwOrigAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartySize": SimTypeInt(signed=False, label="UInt32"), "dwCalledPartyOffset": SimTypeInt(signed=False, label="UInt32"), "dwCommentSize": SimTypeInt(signed=False, label="UInt32"), "dwCommentOffset": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwUserUserInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwHighLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompSize": SimTypeInt(signed=False, label="UInt32"), "dwLowLevelCompOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPredictiveAutoTransferStates": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressSize": SimTypeInt(signed=False, label="UInt32"), "dwTargetAddressOffset": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwSendingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecSize": SimTypeInt(signed=False, label="UInt32"), "dwReceivingFlowspecOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceConfigOffset": SimTypeInt(signed=False, label="UInt32"), "dwCallDataSize": SimTypeInt(signed=False, label="UInt32"), "dwCallDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNoAnswerTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDSize": SimTypeInt(signed=False, label="UInt32"), "dwCallingPartyIDOffset": SimTypeInt(signed=False, label="UInt32")}, name="LINECALLPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall", "lphConsultCall", "lpCallParams"]),
        #
        'lineShutdown': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp"]),
        #
        'lineSwapHold': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hActiveCall", "hHeldCall"]),
        #
        'lineTranslateAddress': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentCountry": SimTypeInt(signed=False, label="UInt32"), "dwDestCountry": SimTypeInt(signed=False, label="UInt32"), "dwTranslateResults": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATEOUTPUT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "lpszAddressIn", "dwCard", "dwTranslateOptions", "lpTranslateOutput"]),
        #
        'lineTranslateAddressA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentCountry": SimTypeInt(signed=False, label="UInt32"), "dwDestCountry": SimTypeInt(signed=False, label="UInt32"), "dwTranslateResults": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATEOUTPUT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "lpszAddressIn", "dwCard", "dwTranslateOptions", "lpTranslateOutput"]),
        #
        'lineTranslateAddressW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDialableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringSize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayableStringOffset": SimTypeInt(signed=False, label="UInt32"), "dwCurrentCountry": SimTypeInt(signed=False, label="UInt32"), "dwDestCountry": SimTypeInt(signed=False, label="UInt32"), "dwTranslateResults": SimTypeInt(signed=False, label="UInt32")}, name="LINETRANSLATEOUTPUT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "lpszAddressIn", "dwCard", "dwTranslateOptions", "lpTranslateOutput"]),
        #
        'lineTranslateDialog': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "hwndOwner", "lpszAddressIn"]),
        #
        'lineTranslateDialogA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "hwndOwner", "lpszAddressIn"]),
        #
        'lineTranslateDialogW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLineApp", "dwDeviceID", "dwAPIVersion", "hwndOwner", "lpszAddressIn"]),
        #
        'lineUncompleteCall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwCompletionID"]),
        #
        'lineUnhold': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCall"]),
        #
        'lineUnpark': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress"]),
        #
        'lineUnparkA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress"]),
        #
        'lineUnparkW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLine", "dwAddressID", "lphCall", "lpszDestAddress"]),
        #
        'phoneClose': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone"]),
        #
        'phoneConfigDialog': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'phoneConfigDialogA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'phoneConfigDialogW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "hwndOwner", "lpszDeviceClass"]),
        #
        'phoneDevSpecific': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpParams", "dwSize"]),
        #
        'phoneGetButtonInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneGetButtonInfoA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneGetButtonInfoW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneGetData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwDataID", "lpData", "dwSize"]),
        #
        'phoneGetDevCaps': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentPhoneID": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwPhoneStates": SimTypeInt(signed=False, label="UInt32"), "dwHookSwitchDevs": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwVolumeFlags": SimTypeInt(signed=False, label="UInt32"), "dwGainFlags": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumRows": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumColumns": SimTypeInt(signed=False, label="UInt32"), "dwNumRingModes": SimTypeInt(signed=False, label="UInt32"), "dwNumButtonLamps": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumSetData": SimTypeInt(signed=False, label="UInt32"), "dwSetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwSetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumGetData": SimTypeInt(signed=False, label="UInt32"), "dwGetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwGetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "PermanentPhoneGuid": SimTypeBottom(label="Guid")}, name="PHONECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpPhoneCaps"]),
        #
        'phoneGetDevCapsA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentPhoneID": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwPhoneStates": SimTypeInt(signed=False, label="UInt32"), "dwHookSwitchDevs": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwVolumeFlags": SimTypeInt(signed=False, label="UInt32"), "dwGainFlags": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumRows": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumColumns": SimTypeInt(signed=False, label="UInt32"), "dwNumRingModes": SimTypeInt(signed=False, label="UInt32"), "dwNumButtonLamps": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumSetData": SimTypeInt(signed=False, label="UInt32"), "dwSetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwSetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumGetData": SimTypeInt(signed=False, label="UInt32"), "dwGetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwGetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "PermanentPhoneGuid": SimTypeBottom(label="Guid")}, name="PHONECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpPhoneCaps"]),
        #
        'phoneGetDevCapsW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneInfoOffset": SimTypeInt(signed=False, label="UInt32"), "dwPermanentPhoneID": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameSize": SimTypeInt(signed=False, label="UInt32"), "dwPhoneNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwPhoneStates": SimTypeInt(signed=False, label="UInt32"), "dwHookSwitchDevs": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwVolumeFlags": SimTypeInt(signed=False, label="UInt32"), "dwGainFlags": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumRows": SimTypeInt(signed=False, label="UInt32"), "dwDisplayNumColumns": SimTypeInt(signed=False, label="UInt32"), "dwNumRingModes": SimTypeInt(signed=False, label="UInt32"), "dwNumButtonLamps": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunctionsOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumSetData": SimTypeInt(signed=False, label="UInt32"), "dwSetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwSetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwNumGetData": SimTypeInt(signed=False, label="UInt32"), "dwGetDataSize": SimTypeInt(signed=False, label="UInt32"), "dwGetDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesSize": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClassesOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32"), "dwSettableHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwSettableHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHandsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredSpeakerHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "dwMonitoredHeadsetHookSwitchModes": SimTypeInt(signed=False, label="UInt32"), "PermanentPhoneGuid": SimTypeBottom(label="Guid")}, name="PHONECAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "dwAPIVersion", "dwExtVersion", "lpPhoneCaps"]),
        #
        'phoneGetDisplay': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpDisplay"]),
        #
        'phoneGetGain': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwHookSwitchDev", "lpdwGain"]),
        #
        'phoneGetHookSwitch': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpdwHookSwitchDevs"]),
        #
        'phoneGetIcon': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'phoneGetIconA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'phoneGetIconW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwDeviceID", "lpszDeviceClass", "lphIcon"]),
        #
        'phoneGetID': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpDeviceID", "lpszDeviceClass"]),
        #
        'phoneGetIDA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpDeviceID", "lpszDeviceClass"]),
        #
        'phoneGetIDW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStringFormat": SimTypeInt(signed=False, label="UInt32"), "dwStringSize": SimTypeInt(signed=False, label="UInt32"), "dwStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="VARSTRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpDeviceID", "lpszDeviceClass"]),
        #
        'phoneGetLamp': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpdwLampMode"]),
        #
        'phoneGetMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"hDevice": SimTypeInt(signed=False, label="UInt32"), "dwMessageID": SimTypeInt(signed=False, label="UInt32"), "dwCallbackInstance": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam2": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwParam3": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="PHONEMESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "lpMessage", "dwTimeout"]),
        #
        'phoneGetRing': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpdwRingMode", "lpdwVolume"]),
        #
        'phoneGetStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwRingVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHandsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetGain": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerVolume": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerGain": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetGain": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameSize": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32")}, name="PHONESTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpPhoneStatus"]),
        #
        'phoneGetStatusA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwRingVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHandsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetGain": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerVolume": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerGain": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetGain": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameSize": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32")}, name="PHONESTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpPhoneStatus"]),
        #
        'phoneGetStatusW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwStatusFlags": SimTypeInt(signed=False, label="UInt32"), "dwNumOwners": SimTypeInt(signed=False, label="UInt32"), "dwNumMonitors": SimTypeInt(signed=False, label="UInt32"), "dwRingMode": SimTypeInt(signed=False, label="UInt32"), "dwRingVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHandsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHandsetGain": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerVolume": SimTypeInt(signed=False, label="UInt32"), "dwSpeakerGain": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetHookSwitchMode": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetVolume": SimTypeInt(signed=False, label="UInt32"), "dwHeadsetGain": SimTypeInt(signed=False, label="UInt32"), "dwDisplaySize": SimTypeInt(signed=False, label="UInt32"), "dwDisplayOffset": SimTypeInt(signed=False, label="UInt32"), "dwLampModesSize": SimTypeInt(signed=False, label="UInt32"), "dwLampModesOffset": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameSize": SimTypeInt(signed=False, label="UInt32"), "dwOwnerNameOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwPhoneFeatures": SimTypeInt(signed=False, label="UInt32")}, name="PHONESTATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpPhoneStatus"]),
        #
        'phoneGetStatusMessages': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "lpdwPhoneStates", "lpdwButtonModes", "lpdwButtonStates"]),
        #
        'phoneGetVolume': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwHookSwitchDev", "lpdwVolume"]),
        #
        'phoneInitialize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphPhoneApp", "hInstance", "lpfnCallback", "lpszAppName", "lpdwNumDevs"]),
        #
        'phoneInitializeExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "Handles": SimUnion({"hEvent": SimTypeBottom(label="HANDLE"), "hCompletionPort": SimTypeBottom(label="HANDLE")}, name="<anon>", label="None"), "dwCompletionKey": SimTypeInt(signed=False, label="UInt32")}, name="PHONEINITIALIZEEXPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphPhoneApp", "hInstance", "lpfnCallback", "lpszFriendlyAppName", "lpdwNumDevs", "lpdwAPIVersion", "lpPhoneInitializeExParams"]),
        #
        'phoneInitializeExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDevice", "dwMessage", "dwInstance", "dwParam1", "dwParam2", "dwParam3"]), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "Handles": SimUnion({"hEvent": SimTypeBottom(label="HANDLE"), "hCompletionPort": SimTypeBottom(label="HANDLE")}, name="<anon>", label="None"), "dwCompletionKey": SimTypeInt(signed=False, label="UInt32")}, name="PHONEINITIALIZEEXPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lphPhoneApp", "hInstance", "lpfnCallback", "lpszFriendlyAppName", "lpdwNumDevs", "lpdwAPIVersion", "lpPhoneInitializeExParams"]),
        #
        'phoneNegotiateAPIVersion': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwExtensionID0": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID1": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID2": SimTypeInt(signed=False, label="UInt32"), "dwExtensionID3": SimTypeInt(signed=False, label="UInt32")}, name="PHONEEXTENSIONID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "dwAPILowVersion", "dwAPIHighVersion", "lpdwAPIVersion", "lpExtensionID"]),
        #
        'phoneNegotiateExtVersion': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "dwAPIVersion", "dwExtLowVersion", "dwExtHighVersion", "lpdwExtVersion"]),
        #
        'phoneOpen': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp", "dwDeviceID", "lphPhone", "dwAPIVersion", "dwExtVersion", "dwCallbackInstance", "dwPrivilege"]),
        #
        'phoneSetButtonInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneSetButtonInfoA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneSetButtonInfoW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNeededSize": SimTypeInt(signed=False, label="UInt32"), "dwUsedSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonMode": SimTypeInt(signed=False, label="UInt32"), "dwButtonFunction": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextSize": SimTypeInt(signed=False, label="UInt32"), "dwButtonTextOffset": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificSize": SimTypeInt(signed=False, label="UInt32"), "dwDevSpecificOffset": SimTypeInt(signed=False, label="UInt32"), "dwButtonState": SimTypeInt(signed=False, label="UInt32")}, name="PHONEBUTTONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "lpButtonInfo"]),
        #
        'phoneSetData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwDataID", "lpData", "dwSize"]),
        #
        'phoneSetDisplay': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwRow", "dwColumn", "lpsDisplay", "dwSize"]),
        #
        'phoneSetGain': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwHookSwitchDev", "dwGain"]),
        #
        'phoneSetHookSwitch': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwHookSwitchDevs", "dwHookSwitchMode"]),
        #
        'phoneSetLamp': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwButtonLampID", "dwLampMode"]),
        #
        'phoneSetRing': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwRingMode", "dwVolume"]),
        #
        'phoneSetStatusMessages': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwPhoneStates", "dwButtonModes", "dwButtonStates"]),
        #
        'phoneSetVolume': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhone", "dwHookSwitchDev", "dwVolume"]),
        #
        'phoneShutdown': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPhoneApp"]),
        #
        'tapiGetLocationInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszCountryCode", "lpszCityCode"]),
        #
        'tapiGetLocationInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszCountryCode", "lpszCityCode"]),
        #
        'tapiGetLocationInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszCountryCodeW", "lpszCityCodeW"]),
        #
        'tapiRequestDrop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "wRequestID"]),
        #
        'tapiRequestMakeCall': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
        #
        'tapiRequestMakeCallA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
        #
        'tapiRequestMakeCallW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
        #
        'tapiRequestMediaCall': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "wRequestID", "lpszDeviceClass", "lpDeviceID", "dwSize", "dwSecure", "lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
        #
        'tapiRequestMediaCallA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "wRequestID", "lpszDeviceClass", "lpDeviceID", "dwSize", "dwSecure", "lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
        #
        'tapiRequestMediaCallW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "wRequestID", "lpszDeviceClass", "lpDeviceID", "dwSize", "dwSecure", "lpszDestAddress", "lpszAppName", "lpszCalledParty", "lpszComment"]),
    }

lib.set_prototypes(prototypes)
