/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.compression;

import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorProvider;
import io.opentelemetry.exporter.internal.compression.GzipCompressor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class CompressorUtil {
    private static final Map<String, Compressor> compressorRegistry = CompressorUtil.buildCompressorRegistry();

    private CompressorUtil() {
    }

    public static Set<String> supportedCompressors() {
        return Collections.unmodifiableSet(compressorRegistry.keySet());
    }

    public static Compressor resolveCompressor(String encoding) {
        Compressor compressor = compressorRegistry.get(encoding);
        if (compressor == null) {
            throw new IllegalArgumentException("Could not resolve compressor for encoding \"" + encoding + "\".");
        }
        return compressor;
    }

    private static Map<String, Compressor> buildCompressorRegistry() {
        HashMap<String, Compressor> compressors = new HashMap<String, Compressor>();
        for (CompressorProvider spi : ServiceLoader.load(CompressorProvider.class, CompressorUtil.class.getClassLoader())) {
            Compressor compressor = spi.getInstance();
            compressors.put(compressor.getEncoding(), compressor);
        }
        compressors.put(GzipCompressor.getInstance().getEncoding(), GzipCompressor.getInstance());
        return compressors;
    }
}

