/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);
    private static String ourPid;

    public static ProcessInfo @NotNull [] getProcessList() {
        ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
        if (processInfoArray == null) {
            OSProcessUtil.$$$reportNull$$$0(0);
        }
        return processInfoArray;
    }

    public static boolean killProcessTree(@NotNull Process process) {
        if (process == null) {
            OSProcessUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isWindows) {
            try {
                Integer pid = ProcessService.getInstance().winPtyChildProcessId(process);
                if (pid != null) {
                    if (pid == -1) {
                        return true;
                    }
                    boolean res = WinProcessManager.kill((int)pid, (boolean)true);
                    process.destroy();
                    return res;
                }
                if (Registry.is((String)"disable.winp", (boolean)false)) {
                    return WinProcessManager.kill((Process)process, (boolean)true);
                }
                if (!process.isAlive()) {
                    OSProcessUtil.logSkippedActionWithTerminatedProcess(process, "killProcessTree", null);
                    return true;
                }
                ProcessService.getInstance().killWinProcessRecursively(process);
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree((Process)process);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process) {
        if (process == null) {
            OSProcessUtil.$$$reportNull$$$0(2);
        }
        OSProcessUtil.killProcess((int)process.pid());
    }

    public static void killProcess(int pid) {
        if (SystemInfo.isWindows) {
            try {
                if (!Registry.is((String)"disable.winp", (boolean)false)) {
                    try {
                        ProcessService.getInstance().killWinProcess(pid);
                        return;
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to kill process with winp, fallback to default logic", e);
                    }
                }
                WinProcessManager.kill((int)pid, (boolean)false);
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)pid, (int)9);
        }
    }

    public static void terminateProcessGracefully(@NotNull Process process) throws RuntimeException {
        if (process == null) {
            OSProcessUtil.$$$reportNull$$$0(3);
        }
        OSProcessUtil.terminateProcessGracefully((int)process.pid(), process.getOutputStream());
    }

    public static void terminateProcessGracefully(int pid) throws RuntimeException {
        OSProcessUtil.terminateProcessGracefully(pid, null);
    }

    private static void terminateProcessGracefully(int pid, @Nullable OutputStream processOutputStream) throws RuntimeException {
        if (SystemInfo.isWindows) {
            if (Registry.is((String)"disable.winp")) {
                throw new UnsupportedOperationException("Cannot terminate process, disable.winp=true");
            }
            try {
                ProcessService.getInstance().sendWinProcessCtrlC(pid, processOutputStream);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Failed to terminate process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)pid, (int)2);
        } else {
            throw new UnsupportedOperationException("Graceful termination is not supported for " + SystemInfo.getOsNameAndVersion());
        }
    }

    static void logSkippedActionWithTerminatedProcess(@NotNull Process process, @NotNull String actionName, @Nullable String commandLine) {
        if (process == null) {
            OSProcessUtil.$$$reportNull$$$0(4);
        }
        if (actionName == null) {
            OSProcessUtil.$$$reportNull$$$0(5);
        }
        Long pid = null;
        try {
            pid = process.pid();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("Cannot " + actionName + " already terminated process (pid: " + pid + ", command: " + commandLine + ")");
    }

    @Deprecated
    public static int getProcessID(@NotNull Process process) {
        if (process == null) {
            OSProcessUtil.$$$reportNull$$$0(6);
        }
        return (int)process.pid();
    }

    public static int getCurrentProcessId() {
        return (int)ProcessHandle.current().pid();
    }

    public static String getApplicationPid() {
        if (ourPid == null) {
            ourPid = String.valueOf(OSProcessUtil.getCurrentProcessId());
        }
        return ourPid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "killProcess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "terminateProcessGracefully";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logSkippedActionWithTerminatedProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProcessID";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

