/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.preferences.TextRule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/textmate/bundles/TextRuleDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lorg/jetbrains/plugins/textmate/language/preferences/TextRule;", "()V", "vc", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.textmate.core"})
public final class TextRuleDeserializer
extends StdDeserializer<TextRule> {
    public TextRuleDeserializer(@Nullable Class<?> vc) {
        super(vc);
    }

    public TextRuleDeserializer() {
        this(null);
    }

    @NotNull
    public TextRule deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        TextRule textRule;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        TreeNode treeNode = p.getCodec().readTree(p);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
        JsonNode node = (JsonNode)treeNode;
        if (node instanceof TextNode) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            textRule = new TextRule(string);
        } else if (node instanceof ObjectNode) {
            String string = node.get("pattern").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            textRule = new TextRule(string);
        } else {
            throw new IllegalStateException("unexpected TextRule node".toString());
        }
        return textRule;
    }
}

