/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.ArrayList;
import java.util.Queue;
import java.util.stream.Stream;
import org.assertj.core.presentation.BoundedQueue;
import org.assertj.core.presentation.RotatingQueue;
import org.assertj.core.util.Preconditions;

final class HeadTailAccumulator<T> {
    private final Queue<T> head;
    private final Queue<T> tail;

    HeadTailAccumulator(int headCapacity, int tailCapacity) {
        Preconditions.checkArgument(headCapacity >= 0, "head capacity must be non-negative but was %d", headCapacity);
        Preconditions.checkArgument(tailCapacity >= 0, "tail capacity must be non-negative but was %d", tailCapacity);
        this.head = new BoundedQueue(headCapacity);
        this.tail = new RotatingQueue(tailCapacity);
    }

    void add(T element2) {
        if (!this.head.offer(element2)) {
            this.tail.offer(element2);
        }
    }

    Stream<T> stream() {
        ArrayList<T> result = new ArrayList<T>(this.head);
        result.addAll(this.tail);
        return result.stream();
    }
}

