/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ngram;

import com.intellij.completion.ml.ngram.NGram;
import com.intellij.completion.ml.ngram.NGramFileListenerKt;
import com.intellij.completion.ml.ngram.NGramModelRunnerManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/ngram/NGramFileListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeFileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.completionMlRanking"})
final class NGramFileListener
implements FileEditorManagerListener.Before {
    @NotNull
    private final Project project;

    public NGramFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (LightEdit.owns((Project)this.project)) {
            return;
        }
        FileType fileType = file.getFileType();
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null || (languageFileType = languageFileType.getLanguage()) == null) {
            return;
        }
        LanguageFileType language = languageFileType;
        if (!NGram.INSTANCE.isSupported$intellij_completionMlRanking((Language)language)) {
            return;
        }
        ReadAction.nonBlocking(() -> NGramFileListener.beforeFileOpened$lambda$0(file, this, (Language)language)).inSmartMode(this.project).submit((Executor)NGramFileListenerKt.access$getExecutor$p());
    }

    private static final void beforeFileOpened$lambda$0(VirtualFile $file, NGramFileListener this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$language, (String)"$language");
        if (!$file.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile($file);
        if (psiFile == null) {
            return;
        }
        NGramModelRunnerManager.Companion.getInstance(this$0.project).processFile(psiFile, $language);
    }
}

