/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeConsole;
import com.jetbrains.ide.model.uiautomation.BeConsolePrompt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ConsoleControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeConsole;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "findEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nConsoleControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n11#2:109\n800#3,11:110\n1#4:121\n*S KotlinDebug\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n*L\n40#1:109\n51#1:110,11\n*E\n"})
public final class ConsoleControl
implements ViewBinder<BeConsole> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> COMMAND_EDITOR_KEY;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JComponent bind(@NotNull BeConsole viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent editorPanel = ViewRegistryKt.getView(viewModel.getEditor(), lifetime);
        JComponent commandEditorPanel = ViewRegistryKt.getView(viewModel.getCommandEditor(), lifetime);
        EditorEx editor = this.findEditor(editorPanel);
        EditorEx commandEditor = this.findEditor(commandEditorPanel);
        if (editor == null || commandEditor == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ConsoleControl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Can't find editors for " + viewModel + " - " + editorPanel + " / " + commandEditorPanel);
            Splitter panel2 = new Splitter(true);
            panel2.setFirstComponent(editorPanel);
            panel2.setSecondComponent(commandEditorPanel);
            return (JComponent)panel2;
        }
        BeConsolePrompt prompt = viewModel.getPrompt();
        if (prompt != null) {
            void $this$filterIsInstanceTo$iv$iv;
            List list2 = commandEditor.getGutter().getTextAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTextAnnotations(...)");
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ConsolePromptDecorator)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List oldConsolePrompts = (List)destination$iv$iv;
            commandEditor.getGutter().closeTextAnnotations((Collection)oldConsolePrompts);
            ConsolePromptDecorator promptDecorator = new ConsolePromptDecorator(commandEditor);
            promptDecorator.setMainPrompt(prompt.getMainPrompt());
            promptDecorator.setIndentPrompt(prompt.getIndentPrompt());
            if (prompt.getTextAttributeKey() != null) {
                Iterator iterator;
                block6: {
                    Collection collection = ConsoleViewContentType.getRegisteredTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredTypes(...)");
                    Iterable iterable2 = collection;
                    for (Iterator iterator2 : iterable2) {
                        ConsoleViewContentType it = (ConsoleViewContentType)iterator2;
                        boolean bl = false;
                        TextAttributesKey textAttributesKey = it.getAttributesKey();
                        if (!Intrinsics.areEqual((Object)(textAttributesKey != null ? textAttributesKey.getExternalName() : null), (Object)prompt.getTextAttributeKey())) continue;
                        iterator = iterator2;
                        break block6;
                    }
                    iterator = null;
                }
                ConsoleViewContentType contentType = (ConsoleViewContentType)iterator;
                if (contentType != null) {
                    promptDecorator.setPromptAttributes(contentType);
                }
            }
            commandEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)promptDecorator);
            commandEditor.putUserData(COMMAND_EDITOR_KEY, (Object)true);
        }
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)editor);
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)commandEditor);
        return new ThinClientConsoleEditorPanel(editor, commandEditor, editorPanel, commandEditorPanel, lifetime);
    }

    private final EditorEx findEditor(JComponent $this$findEditor) {
        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)$this$findEditor, EditorComponentImpl.class);
        if (editorComponentImpl == null) {
            return null;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        return (EditorEx)editorComponent.getEditor();
    }

    static {
        Key key = Key.create((String)"ConsoleControl.CommandEditor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMMAND_EDITOR_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ConsoleControl$Companion;", "", "()V", "COMMAND_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCOMMAND_EDITOR_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getCOMMAND_EDITOR_KEY() {
            return COMMAND_EDITOR_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

