/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconInternWrapper;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolImageDataLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/icons/CachedImageIcon;", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class ImageIconConverter
implements ProtocolIconConverter<CachedImageIcon, ImageIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull ImageIconModel model2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String path = model2.getWrapper().getPath();
        Icon icon2 = IconLoader.findIcon((String)path, AllIcons.class, (boolean)false, (boolean)false);
        if (icon2 != null && !(icon2 instanceof CachedImageIcon)) {
            return icon2;
        }
        Icon unscaledIcon2 = registry.cacheIcon(model2.getWrapper().getIdentity(), (Function1<? super Long, ? extends Icon>)((Function1)new Function1<Long, Icon>(model2, icon2){
            final /* synthetic */ ImageIconModel $model;
            final /* synthetic */ Icon $icon;
            {
                this.$model = $model;
                this.$icon = $icon;
                super(1);
            }

            @NotNull
            public final Icon invoke(long it) {
                Icon icon2 = this.$icon;
                CachedImageIcon cachedImageIcon = icon2 instanceof CachedImageIcon ? (CachedImageIcon)icon2 : null;
                return (Icon)new CachedImageIcon((ImageDataLoader)new ProtocolImageDataLoader(this.$model, (ImageDataLoader)(cachedImageIcon != null ? cachedImageIcon.getOriginalLoader() : null)));
            }
        }));
        Float scale = model2.getInitialScale();
        if (scale == null) {
            return unscaledIcon2;
        }
        CachedImageIcon cachedImageIcon = unscaledIcon2 instanceof CachedImageIcon ? (CachedImageIcon)unscaledIcon2 : null;
        return cachedImageIcon != null && (cachedImageIcon = cachedImageIcon.scale(scale.floatValue())) != null ? (Icon)cachedImageIcon : unscaledIcon2;
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull CachedImageIcon icon2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel it = registry.cacheModel((Icon)icon2, (Function1<? super Long, ? extends IconModel>)((Function1)new Function1<Long, IconModel>(icon2){
            final /* synthetic */ CachedImageIcon $icon;
            {
                this.$icon = $icon;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IconModel invoke(long identity) {
                Object object;
                List sources;
                String effectiveName;
                String effectivePath;
                String string;
                String string2;
                String name;
                String path;
                Object object2;
                URL url;
                String originalPath;
                block32: {
                    block31: {
                        String it;
                        block30: {
                            String string3;
                            block29: {
                                String string4;
                                String string5;
                                originalPath = this.$icon.getOriginalPath();
                                url = this.$icon.getUrl();
                                Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                                boolean $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    object2 = $this$trace$iv;
                                    boolean bl = false;
                                    URL uRL = url;
                                    object2.trace("originalPath=" + originalPath + ", icon.url.path=" + (uRL != null ? uRL.getPath() : null));
                                }
                                if ((string5 = originalPath) == null) {
                                    URL uRL = url;
                                    string5 = uRL != null ? uRL.getPath() : null;
                                }
                                if (string5 != null) {
                                    String string6;
                                    String it2 = string5;
                                    boolean bl = false;
                                    Pair pair = URLUtil.splitJarUrl((String)it2);
                                    String string7 = string6 = pair != null ? (String)pair.second : null;
                                    if (string7 == null) {
                                        string4 = it2;
                                    } else {
                                        Intrinsics.checkNotNull((Object)string7);
                                        string4 = string6;
                                    }
                                } else {
                                    string4 = null;
                                }
                                if ((string3 = (path = string4)) == null) break block29;
                                it = string3;
                                boolean bl = false;
                                String string8 = FileUtilRt.getNameWithoutExtension((String)it);
                                string3 = string8;
                                if (string8 != null) break block30;
                            }
                            string3 = name = "protocol_icon_no_path";
                        }
                        if ((string2 = path) == null) break block31;
                        it = string2;
                        boolean bl = false;
                        String string9 = FileUtilRt.getExtension((String)it);
                        string2 = string9;
                        if (string9 != null) break block32;
                    }
                    string2 = "png";
                }
                String it = string2;
                boolean bl = false;
                switch (it.hashCode()) {
                    case 0: {
                        if (it.equals("")) {
                            string = "svg";
                            break;
                        }
                    }
                    default: {
                        string = it;
                    }
                }
                String ext2 = string;
                Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    object2 = $this$trace$iv;
                    boolean bl2 = false;
                    object2.trace("path=" + path + ", name=" + name + ", ext=" + ext2);
                }
                if (originalPath == null) {
                    ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + name + "." + ext2 + " as a fallback");
                }
                URL uRL = url;
                String string10 = effectivePath = uRL != null ? uRL.getPath() : null;
                String effectiveExtension = string10 != null ? StringsKt.substringAfterLast$default((String)string10, (String)".", null, (int)2, null) : null;
                String string11 = effectivePath;
                String string12 = effectiveName = string11 != null ? StringsKt.substringBeforeLast$default((String)string11, (String)".", null, (int)2, null) : null;
                if (path != null && effectiveName != null && effectiveExtension != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Object object3;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ImageDescriptorKt.createImageDescriptorList((String)path, (boolean)true, (boolean)true, (float)1.0f);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        object3 = (ImageDescriptor)item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl3 = false;
                        String transformedPath = (String)it3.pathTransform.invoke((Object)effectiveName, (Object)effectiveExtension);
                        String sourceId = (String)it3.pathTransform.invoke((Object)name, (Object)ext2);
                        object2.add(TuplesKt.to((Object)transformedPath, (Object)sourceId));
                    }
                    Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    object3 = $this$forEach$iv$iv$iv.iterator();
                    while (object3.hasNext()) {
                        IconSource iconSource;
                        block28: {
                            byte[] byArray;
                            E element$iv$iv$iv;
                            E element$iv$iv = element$iv$iv$iv = object3.next();
                            boolean bl4 = false;
                            kotlin.Pair it4 = (kotlin.Pair)element$iv$iv;
                            boolean bl5 = false;
                            URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), (String)it4.getFirst());
                            try {
                                byArray = TextStreamsKt.readBytes((URL)newUrl);
                            }
                            catch (IOException ex) {
                                iconSource = null;
                                break block28;
                            }
                            byte[] bytes = byArray;
                            iconSource = new IconSource((String)it4.getSecond(), bytes);
                        }
                        if (iconSource == null) continue;
                        IconSource it$iv$iv = iconSource;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v16 = (List)destination$iv$iv;
                } else {
                    v16 = sources = CollectionsKt.emptyList();
                }
                if (sources.isEmpty()) {
                    ImageIconConverterKt.access$getLogger$p().error("Failed to read icon:'" + path + "'");
                }
                if ((object = path) == null) {
                    object = name + "." + ext2;
                }
                String string13 = object;
                int n = this.$icon.getImageFlags();
                return new ImageIconModel(new ImageIconInternWrapper(identity, string13, n, sources), null);
            }
        }));
        boolean bl = false;
        ImageIconModel imageIconModel = it instanceof ImageIconModel ? (ImageIconModel)it : null;
        if (imageIconModel == null) {
            return it;
        }
        ImageIconModel model2 = imageIconModel;
        Double scale = icon2.getObjScale();
        if (scale == null) {
            return model2;
        }
        return new ImageIconModel(model2.getWrapper(), Float.valueOf((float)scale.doubleValue()));
    }
}

