/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\bJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010 \u001a\u00020\b*\u00020!H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "bucket", "", "getBucket", "()I", "build", "", "getBuild", "()Ljava/lang/String;", "build$delegate", "Lkotlin/Lazy;", "configurations", "", "Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "defaultConfiguration", "anonymize", "data", "getEventLogDataPath", "Ljava/nio/file/Path;", "getEventLogSettingsPath", "getHeadlessDeviceIdProperty", "recorderId", "getHeadlessDeviceIdProperty$intellij_platform_statistics", "getHeadlessMaxFilesToSendProperty", "getHeadlessMaxFilesToSendProperty$intellij_platform_statistics", "getHeadlessSaltProperty", "getHeadlessSaltProperty$intellij_platform_statistics", "getOrCreate", "getRecorderBasedProperty", "property", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,274:1\n372#2,7:275\n11#3:282\n*S KotlinDebug\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogConfiguration\n*L\n124#1:275,7\n41#1:282\n*E\n"})
public final class EventLogConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventLogRecorderConfiguration defaultConfiguration = new EventLogRecorderConfiguration("FUS", this, Companion.getDefaultSessionId());
    @NotNull
    private final Map<String, EventLogRecorderConfiguration> configurations = new HashMap();
    @NotNull
    private final Lazy build$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ EventLogConfiguration this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final String invoke() {
            BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            return EventLogConfiguration.access$asBuildNumber(this.this$0, buildNumber);
        }
    }));
    private final int bucket = this.defaultConfiguration.getBucket();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String UNDEFINED_DEVICE_ID = "000000000000000-0000-0000-0000-000000000000";
    @NotNull
    private static final String FUS_RECORDER = "FUS";
    @NotNull
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    @NotNull
    private static final String IDEA_HEADLESS_STATISTICS_DEVICE_ID = "idea.headless.statistics.device.id";
    @NotNull
    private static final String IDEA_HEADLESS_STATISTICS_SALT = "idea.headless.statistics.salt";
    @NotNull
    private static final String IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND = "idea.headless.statistics.max.files.to.send";
    @NotNull
    private static final Lazy<String> defaultSessionId$delegate;

    @NotNull
    public final String getBuild() {
        Lazy lazy = this.build$delegate;
        return (String)lazy.getValue();
    }

    public final int getBucket() {
        return this.bucket;
    }

    @Deprecated(message="Call method on configuration created with getOrCreate method")
    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.defaultConfiguration.anonymize(data);
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCodeAndSnapshot(...)");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EventLogRecorderConfiguration getOrCreate(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (EventLogConfiguration.Companion.isDefaultRecorderId(recorderId)) {
            return this.defaultConfiguration;
        }
        EventLogConfiguration eventLogConfiguration = this;
        synchronized (eventLogConfiguration) {
            EventLogRecorderConfiguration eventLogRecorderConfiguration;
            boolean bl = false;
            Map<String, EventLogRecorderConfiguration> $this$getOrPut$iv = this.configurations;
            boolean $i$f$getOrPut = false;
            EventLogRecorderConfiguration value$iv = $this$getOrPut$iv.get(recorderId);
            if (value$iv == null) {
                boolean bl2 = false;
                EventLogRecorderConfiguration answer$iv = new EventLogRecorderConfiguration(recorderId, this, null, 4, null);
                $this$getOrPut$iv.put(recorderId, answer$iv);
                eventLogRecorderConfiguration = answer$iv;
            } else {
                eventLogRecorderConfiguration = value$iv;
            }
            EventLogRecorderConfiguration eventLogRecorderConfiguration2 = eventLogRecorderConfiguration;
            return eventLogRecorderConfiguration2;
        }
    }

    @NotNull
    public final Path getEventLogDataPath() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log-data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getEventLogSettingsPath() {
        Path path = this.getEventLogDataPath().resolve("settings");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final String getHeadlessDeviceIdProperty$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_DEVICE_ID);
    }

    @NotNull
    public final String getHeadlessSaltProperty$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_SALT);
    }

    @NotNull
    public final String getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND);
    }

    private final String getRecorderBasedProperty(String recorderId, String property) {
        return EventLogConfiguration.Companion.isDefaultRecorderId(recorderId) ? property : property + "." + StringUtil.toLowerCase((String)recorderId);
    }

    @JvmStatic
    @NotNull
    public static final EventLogConfiguration getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ String access$asBuildNumber(EventLogConfiguration $this, BuildNumber $receiver) {
        return $this.asBuildNumber($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EventLogConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        defaultSessionId$delegate = LazyKt.lazy((Function0)Companion.defaultSessionId.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0013\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\f\u0010 \u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration$Companion;", "", "()V", "FUS_RECORDER", "", "IDEA_HEADLESS_STATISTICS_DEVICE_ID", "IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND", "IDEA_HEADLESS_STATISTICS_SALT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_statistics", "()Lcom/intellij/openapi/diagnostic/Logger;", "SALT_PREFERENCE_KEY", "UNDEFINED_DEVICE_ID", "defaultSessionId", "getDefaultSessionId", "()Ljava/lang/String;", "defaultSessionId$delegate", "Lkotlin/Lazy;", "generateSessionId", "generateSessionId$intellij_platform_statistics", "getInstance", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "getOrGenerateSaltFromPrefs", "", "recorderId", "getSaltPropertyKey", "hashSha256", "salt", "data", "isDefaultRecorderId", "", "shortedUUID", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_platform_statistics() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final EventLogConfiguration getInstance() {
            Object object = ApplicationManager.getApplication().getService(EventLogConfiguration.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (EventLogConfiguration)object;
        }

        @NotNull
        public final String hashSha256(@NotNull byte[] salt, @NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            MessageDigest md = DigestUtil.sha256();
            md.update(salt);
            String string = data;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            md.update(byArray);
            byte[] byArray2 = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
            return DigestUtilKt.bytesToHex((byte[])byArray2);
        }

        @NotNull
        public final byte[] getOrGenerateSaltFromPrefs(@NotNull String recorderId) {
            String string;
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            String companyName = ApplicationInfoImpl.getShadowInstance().getShortCompanyName();
            CharSequence charSequence = companyName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                string = "jetbrains";
            } else {
                Intrinsics.checkNotNull((Object)companyName);
                charSequence = companyName;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string2 = ((String)charSequence).toLowerCase(locale);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            }
            String name = string;
            Preferences prefs = Preferences.userRoot().node(name);
            String saltKey = this.getSaltPropertyKey(recorderId);
            byte[] salt = prefs.getByteArray(saltKey, null);
            if (salt == null) {
                salt = new byte[32];
                new SecureRandom().nextBytes(salt);
                prefs.putByteArray(saltKey, salt);
                this.getLOG$intellij_platform_statistics().info("Generating new salt for " + recorderId);
            }
            return salt;
        }

        @NotNull
        public final String getDefaultSessionId() {
            Lazy lazy = defaultSessionId$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String generateSessionId$intellij_platform_statistics() {
            String presentableHour = StatisticsUtil.getCurrentHourInUTC$default(StatisticsUtil.INSTANCE, null, 1, null);
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return presentableHour + "-" + this.shortedUUID(string);
        }

        private final String shortedUUID(String $this$shortedUUID) {
            int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (start > 0 && start + 1 < $this$shortedUUID.length()) {
                String string = $this$shortedUUID.substring(start + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return $this$shortedUUID;
        }

        private final boolean isDefaultRecorderId(String recorderId) {
            return Intrinsics.areEqual((Object)EventLogConfiguration.FUS_RECORDER, (Object)recorderId);
        }

        private final String getSaltPropertyKey(String recorderId) {
            return this.isDefaultRecorderId(recorderId) ? EventLogConfiguration.SALT_PREFERENCE_KEY : StringUtil.toLowerCase((String)recorderId) + "_feature_usage_event_log_salt";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

