/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.ExternalEventLogListenerProviderExtension;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProvidersHolder;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProviderUtil;", "", "()V", "forceLoggingAlwaysEnabled", "", "getEventLogProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "recorderId", "", "getEventLogProviders", "", "getExternalEventLogSettings", "Lcom/intellij/internal/statistic/eventLog/ExternalEventLogSettings;", "intellij.platform.statistics"})
public final class StatisticsEventLogProviderUtil {
    @NotNull
    public static final StatisticsEventLogProviderUtil INSTANCE = new StatisticsEventLogProviderUtil();

    private StatisticsEventLogProviderUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<StatisticsEventLoggerProvider> getEventLogProviders() {
        return CollectionsKt.toList((Iterable)((StatisticsEventLogProvidersHolder)ApplicationManager.getApplication().getService(StatisticsEventLogProvidersHolder.class)).getEventLogProviders());
    }

    @JvmStatic
    @NotNull
    public static final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return ((StatisticsEventLogProvidersHolder)ApplicationManager.getApplication().getService(StatisticsEventLogProvidersHolder.class)).getEventLogProvider(recorderId);
    }

    @JvmStatic
    @Nullable
    public static final ExternalEventLogSettings getExternalEventLogSettings() {
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogSettings> extensionPointName = ExternalEventLogSettings.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        if (extensionsArea.hasExtensionPoint(extensionPointName)) {
            ExternalEventLogSettings externalEventLogSettings2 = (ExternalEventLogSettings)ExternalEventLogSettings.EP_NAME.findFirstSafe(arg_0 -> StatisticsEventLogProviderUtil.getExternalEventLogSettings$lambda$0(getExternalEventLogSettings.externalEventLogSettings.1.INSTANCE, arg_0));
            return externalEventLogSettings2;
        }
        return null;
    }

    @JvmStatic
    public static final boolean forceLoggingAlwaysEnabled() {
        ExternalEventLogSettings externalEventLogSettings2;
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogSettings> extensionPointName = ExternalEventLogSettings.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        if (extensionsArea.hasExtensionPoint(extensionPointName) && (externalEventLogSettings2 = (ExternalEventLogSettings)ExternalEventLogSettings.EP_NAME.findFirstSafe(arg_0 -> StatisticsEventLogProviderUtil.forceLoggingAlwaysEnabled$lambda$1(forceLoggingAlwaysEnabled.externalEventLogSettings.1.INSTANCE, arg_0))) != null && externalEventLogSettings2.forceLoggingAlwaysEnabled()) {
            return true;
        }
        ExtensionsArea extensionsArea2 = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogListenerProviderExtension> extensionPointName2 = ExternalEventLogListenerProviderExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"EP_NAME");
        if (extensionsArea2.hasExtensionPoint(extensionPointName2)) {
            for (ExternalEventLogListenerProviderExtension logListenerProvider : ExternalEventLogListenerProviderExtension.EP_NAME.getExtensionList()) {
                if (!PluginInfoDetectorKt.getPluginInfo(logListenerProvider.getClass()).isAllowedToInjectIntoFUS() || !logListenerProvider.forceLoggingAlwaysEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean getExternalEventLogSettings$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean forceLoggingAlwaysEnabled$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

