/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.EventSchemeValidator;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsScheme;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilderAppStarterKt;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.IllegalMetadataSchemeStateException;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogTestMetadataPersistence;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "createValidationRules", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "group", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "getPluginsToSkipSchemeGeneration", "", "logEnabledPlugins", "", "pluginsFile", "main", "args", "", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventsSchemeBuilderAppStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsSchemeBuilderAppStarter.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n766#2:152\n857#2,2:153\n1855#2:155\n1855#2,2:156\n1856#2:158\n*S KotlinDebug\n*F\n+ 1 EventsSchemeBuilderAppStarter.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter\n*L\n80#1:152\n80#1:153,2\n107#1:155\n109#1:156,2\n107#1:158\n*E\n"})
public final class EventsSchemeBuilderAppStarter
implements ApplicationStarter {
    @NotNull
    public String getCommandName() {
        return "buildEventsScheme";
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String outputFile = null;
        String pluginsFile = null;
        String pluginId = null;
        String errorsFile = null;
        String recorderId = null;
        boolean testEventsScheme = false;
        for (String arg : args) {
            if (StringsKt.startsWith$default((String)arg, (String)"--outputFile=", (boolean)false, (int)2, null)) {
                outputFile = StringsKt.substringAfter$default((String)arg, (String)"--outputFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--pluginsFile=", (boolean)false, (int)2, null)) {
                pluginsFile = StringsKt.substringAfter$default((String)arg, (String)"--pluginsFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--pluginId=", (boolean)false, (int)2, null)) {
                pluginId = StringsKt.substringAfter$default((String)arg, (String)"--pluginId=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--errorsFile=", (boolean)false, (int)2, null)) {
                errorsFile = StringsKt.substringAfter$default((String)arg, (String)"--errorsFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--recorderId=", (boolean)false, (int)2, null)) {
                recorderId = StringsKt.substringAfter$default((String)arg, (String)"--recorderId=", null, (int)2, null);
                continue;
            }
            if (!StringsKt.startsWith$default((String)arg, (String)"--testEventScheme=", (boolean)false, (int)2, null)) continue;
            testEventsScheme = Boolean.parseBoolean(StringsKt.substringAfter$default((String)arg, (String)"--testEventScheme=", null, (int)2, null));
        }
        List<GroupDescriptor> groups = null;
        try {
            groups = EventsSchemeBuilder.buildEventsScheme(recorderId, pluginId, this.getPluginsToSkipSchemeGeneration());
        }
        catch (IllegalMetadataSchemeStateException e) {
            EventsSchemeBuilderAppStarterKt.access$getLOG().error((Throwable)e);
            if (errorsFile != null) {
                FileUtil.writeToFile((File)new File(errorsFile), (String)e.toString());
            }
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Map<GroupDescriptor, List<String>> errors = EventSchemeValidator.validateEventScheme(groups);
        List errorsList = CollectionsKt.flatten((Iterable)errors.values());
        if (!((Collection)errorsList).isEmpty()) {
            String errorsListString = CollectionsKt.joinToString$default((Iterable)errorsList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            EventsSchemeBuilderAppStarterKt.access$getLOG().error((Throwable)new IllegalStateException(errorsListString));
            if (errorsFile != null) {
                FileUtil.writeToFile((File)new File(errorsFile), (String)errorsListString);
            }
        }
        String text = null;
        if (!testEventsScheme) {
            List list;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = groups;
            String string = System.getenv("IDEA_BUILD_NUMBER");
            String string2 = System.getenv("INSTALLER_LAST_COMMIT_HASH");
            boolean $i$f$filter = false;
            void var15_19 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GroupDescriptor it = (GroupDescriptor)element$iv$iv;
                boolean bl = false;
                List<String> list2 = errors.get(it);
                if (!(list2 != null ? list2.isEmpty() : true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = list = (List)destination$iv$iv;
            String string3 = string;
            String string4 = string2;
            EventsScheme eventsScheme = new EventsScheme(string4, string3, list3);
            text = SerializationHelper.INSTANCE.serialize(eventsScheme);
            this.logEnabledPlugins(pluginsFile);
        } else {
            EventGroupRemoteDescriptors groupsDescriptor = new EventGroupRemoteDescriptors();
            for (GroupDescriptor group : groups) {
                groupsDescriptor.groups.add(EventLogTestMetadataPersistence.createGroupWithCustomRules(group.getId(), SerializationHelper.INSTANCE.serialize(this.createValidationRules(group))));
            }
            text = SerializationHelper.INSTANCE.serialize(groupsDescriptor);
        }
        if (outputFile != null) {
            FileUtil.writeToFile((File)new File(outputFile), (String)text);
        } else {
            System.out.println((Object)text);
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final EventGroupRemoteDescriptors.GroupRemoteRule createValidationRules(GroupDescriptor group) {
        HashSet<String> eventIds = new HashSet<String>();
        HashMap eventData = new HashMap();
        Set<EventDescriptor> events = group.getSchema();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventDescriptor event = (EventDescriptor)element$iv;
            boolean bl = false;
            eventIds.add(event.getEvent());
            Iterable $this$forEach$iv2 = event.getFields();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FieldDescriptor dataField = (FieldDescriptor)element$iv2;
                boolean bl2 = false;
                Set<String> validationRule = dataField.getValue();
                Set validationRules = (Set)eventData.get(dataField.getPath());
                if (validationRules == null) {
                    ((Map)eventData).put(dataField.getPath(), CollectionsKt.toHashSet((Iterable)validationRule));
                    continue;
                }
                validationRules.addAll((Collection)validationRule);
            }
        }
        if (eventIds.isEmpty() && eventData.isEmpty()) {
            return null;
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rules = new EventGroupRemoteDescriptors.GroupRemoteRule();
        rules.event_id = eventIds;
        rules.event_data = eventData;
        return rules;
    }

    private final void logEnabledPlugins(String pluginsFile) {
        StringBuilder stringBuilder;
        StringBuilder $this$logEnabledPlugins_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getLoadedPlugins()) {
            if (!descriptor.isEnabled()) continue;
            StringBuilder stringBuilder2 = $this$logEnabledPlugins_u24lambda_u243.append(descriptor.getPluginId().getIdString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        if (pluginsFile != null) {
            FileUtil.writeToFile((File)new File(pluginsFile), (String)text);
        } else {
            System.out.println((Object)"Enabled plugins:");
            System.out.println((Object)text);
        }
    }

    private final Set<String> getPluginsToSkipSchemeGeneration() {
        String skipGenerationOfBrokenPlugins = System.getenv("SKIP_GENERATION_OF_BROKEN_PLUGINS");
        if (skipGenerationOfBrokenPlugins == null) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{","};
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)skipGenerationOfBrokenPlugins, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }
}

