/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.python.community.impl.huggingFace.HuggingFaceUtil;
import com.intellij.python.community.impl.huggingFace.annotation.HuggingFaceIdentifierPsiElement;
import com.intellij.python.community.impl.huggingFace.service.HuggingFacePluginManager;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/community/impl/huggingFace/annotation/HuggingFaceEntityNameAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isValidHfString", "", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "text", "", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceEntityNameAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PyStringLiteralExpression)) {
            return;
        }
        Project project2 = ((PyStringLiteralExpression)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        HuggingFacePluginManager pluginManager = (HuggingFacePluginManager)project3.getService(HuggingFacePluginManager.class);
        if (!pluginManager.isActive()) {
            return;
        }
        String string = ((PyStringLiteralExpression)element).getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        String text = string;
        if (!this.isValidHfString((PyStringLiteralExpression)element, text)) {
            return;
        }
        TextRange textRangeInElement = element.getTextRange();
        int startOffset = textRangeInElement.getStartOffset() + 1;
        int endOffset = textRangeInElement.getEndOffset() - 1;
        TextRange modelRange = new TextRange(startOffset, endOffset);
        holder.newSilentAnnotation(HighlightSeverity.TEXT_ATTRIBUTES).range(modelRange).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
    }

    private final boolean isValidHfString(PyStringLiteralExpression element, String text) {
        return Intrinsics.areEqual((Object)element.getUserData(HuggingFaceIdentifierPsiElement.Companion.getHUGGING_FACE_ENTITY_NAME_KEY()), (Object)true) || HuggingFaceUtil.INSTANCE.isHuggingFaceEntity(text);
    }
}

