/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.documentation;

import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceURLProvider;
import com.intellij.python.community.impl.huggingFace.documentation.HuggingFaceDocumentationPlaceholdersUtil;
import com.intellij.python.community.impl.huggingFace.documentation.HuggingFaceReadmeCleaner;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u000e\u001a\u00020\u0000J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceReadmeCleaner;", "", "markdown", "", "entityId", "entityKind", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;)V", "cardUrl", "Ljava/net/URL;", "cleanupImages", "", "cleanupNotSupportedElements", "convertRelativeFileLinksToAbsolute", "doCleanUp", "fixCodeFences", "fixContentTables", "getMarkdown", "increaseHeaderLevels", "removeMarkdownSeparators", "removeMetaData", "Companion", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceReadmeCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceReadmeCleaner.kt\ncom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceReadmeCleaner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1855#2:146\n1855#2,2:147\n1856#2:149\n*S KotlinDebug\n*F\n+ 1 HuggingFaceReadmeCleaner.kt\ncom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceReadmeCleaner\n*L\n53#1:146\n61#1:147,2\n53#1:149\n*E\n"})
public final class HuggingFaceReadmeCleaner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String markdown;
    @NotNull
    private final String entityId;
    @NotNull
    private final HuggingFaceEntityKind entityKind;
    @NotNull
    private final URL cardUrl;
    @NotNull
    private static final String HF_MD_HEADER_SEPARATOR = "---\n";
    @NotNull
    private static final String ERR_PY_CODE_FENCE_HEADER = "```py\n";
    @NotNull
    private static final String PY_CODE_FENCE_HEADER = "```python\n";
    @NotNull
    private static final Regex MD_IMG_REGEX = new Regex("!\\[(.*?)]\\((.*?)\\)");
    @NotNull
    private static final Regex HTML_IMG_REGEX = new Regex("<img([^>]+)?>", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex MARKDOWN_HEADER_REGEX = new Regex("(?m)^#{1,6}\\s(.*?)$");
    @NotNull
    private static final Regex INTERNAL_LINK_REGEX = new Regex("\\[(.*?)\\]\\(#(.*?)\\)");
    @NotNull
    private static final Regex RELATIVE_LINK_REGEX = new Regex("\\[(.*?)\\]\\((?!http|#)(.*?)(?<!\\.(jpg|jpeg|png|gif))\\)");
    @NotNull
    private static final Regex SUMMARY_TAGS_REGEX = new Regex("<summary>(.*?)</summary>");
    @NotNull
    private static final Regex MD_SEPARATORS_REGEX = new Regex("\\n(-{3,}|_{3,}|\\*{3,})\\n");

    public HuggingFaceReadmeCleaner(@NotNull String markdown, @NotNull String entityId, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        this.markdown = markdown;
        this.entityId = entityId;
        this.entityKind = entityKind;
        this.cardUrl = HuggingFaceURLProvider.INSTANCE.getEntityCardLink(this.entityId, this.entityKind);
    }

    @NotNull
    public final HuggingFaceReadmeCleaner doCleanUp() {
        this.removeMetaData();
        this.increaseHeaderLevels();
        this.fixCodeFences();
        this.cleanupNotSupportedElements();
        this.cleanupImages();
        this.convertRelativeFileLinksToAbsolute();
        this.fixContentTables();
        this.removeMarkdownSeparators();
        return this;
    }

    private final void removeMetaData() {
        String[] stringArray = new String[]{HF_MD_HEADER_SEPARATOR};
        List parts = StringsKt.split$default((CharSequence)this.markdown, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        this.markdown = parts.size() > 2 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)parts, (int)2), (CharSequence)HF_MD_HEADER_SEPARATOR, null, null, (int)0, null, null, (int)62, null) : this.markdown;
    }

    private final void increaseHeaderLevels() {
        Regex pattern = new Regex("(?m)^#{1,5}\\s");
        this.markdown = pattern.replace((CharSequence)this.markdown, (Function1)increaseHeaderLevels.1.INSTANCE);
    }

    private final void fixContentTables() {
        List internalLinks2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)INTERNAL_LINK_REGEX, (CharSequence)this.markdown, (int)0, (int)2, null), (Function1)fixContentTables.internalLinks.1.INSTANCE));
        List headers2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)MARKDOWN_HEADER_REGEX, (CharSequence)this.markdown, (int)0, (int)2, null), (Function1)fixContentTables.headers.1.INSTANCE));
        Iterable $this$forEach$iv = internalLinks2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String link = (String)element$iv;
            boolean bl = false;
            String anchor = "<a name=\"" + link + "\"></a>";
            if (StringsKt.contains$default((CharSequence)this.markdown, (CharSequence)anchor, (boolean)false, (int)2, null)) continue;
            String string = StringsKt.replace$default((String)link, (String)"-", (String)"", (boolean)false, (int)4, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
            Iterable $this$forEach$iv2 = headers2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int headerIndex;
                String normalizedHeader;
                String normalizedLink;
                String header = (String)element$iv2;
                boolean bl2 = false;
                CharSequence charSequence = header;
                Regex regex = new Regex("^#{1,6}\\s");
                String string2 = "";
                charSequence = StringsKt.replace$default((String)regex.replace(charSequence, string2), (String)" ", (String)"", (boolean)false, (int)4, null);
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                Intrinsics.checkNotNullExpressionValue((Object)((String)charSequence).toLowerCase(locale2), (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)normalizedLink, (Object)normalizedHeader) || (headerIndex = StringsKt.indexOf$default((CharSequence)this.markdown, (String)header, (int)0, (boolean)false, (int)6, null)) == -1) continue;
                String string3 = this.markdown.substring(0, headerIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String string4 = this.markdown.substring(headerIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                this.markdown = string3 + anchor + "\n" + string4;
            }
        }
    }

    private final void fixCodeFences() {
        this.markdown = StringsKt.replace$default((String)this.markdown, (String)ERR_PY_CODE_FENCE_HEADER, (String)PY_CODE_FENCE_HEADER, (boolean)false, (int)4, null);
    }

    private final void cleanupNotSupportedElements() {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)this.markdown, (String)"<details>", (String)"", (boolean)false, (int)4, null), (String)"</details>", (String)"", (boolean)false, (int)4, null);
        Regex regex = SUMMARY_TAGS_REGEX;
        Function1 function1 = cleanupNotSupportedElements.1.INSTANCE;
        this.markdown = regex.replace(charSequence, function1);
    }

    private final void cleanupImages() {
        Regex markdownImgPattern = MD_IMG_REGEX;
        this.markdown = markdownImgPattern.replace((CharSequence)this.markdown, (Function1)new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ HuggingFaceReadmeCleaner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                CharSequence charSequence2 = (CharSequence)matchResult.getGroupValues().get(1);
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    String[] stringArray = new String[]{"/"};
                    charSequence = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)matchResult.getGroupValues().get(2)), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                } else {
                    charSequence = charSequence2;
                }
                String altText = (String)charSequence;
                return "\n[Image: " + altText + "](" + HuggingFaceReadmeCleaner.access$getCardUrl$p(this.this$0) + ")\n";
            }
        });
        Regex htmlImgPattern = HTML_IMG_REGEX;
        this.markdown = htmlImgPattern.replace((CharSequence)this.markdown, (Function1)new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ HuggingFaceReadmeCleaner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                String[] stringArray;
                String filename;
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                String imgTag = matchResult.getValue();
                Regex altPattern = new Regex("\\balt=(['\"]?)(.*?)\\1", RegexOption.IGNORE_CASE);
                Object object = Regex.find$default((Regex)altPattern, (CharSequence)imgTag, (int)0, (int)2, null);
                String altText = object != null && (object = object.getGroupValues()) != null ? (String)object.get(2) : null;
                Regex srcPattern = new Regex("\\bsrc=(['\"]?)(.*?)\\1", RegexOption.IGNORE_CASE);
                Object object2 = Regex.find$default((Regex)srcPattern, (CharSequence)imgTag, (int)0, (int)2, null);
                String srcValue = object2 != null && (object2 = object2.getGroupValues()) != null ? (String)object2.get(2) : null;
                Object object3 = srcValue;
                String string = filename = object3 != null && (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.lastOrNull((List)object3) : null;
                String string2 = altText;
                if (string2 == null) {
                    string2 = filename;
                }
                return "\n[Image: " + string2 + "](" + HuggingFaceReadmeCleaner.access$getCardUrl$p(this.this$0) + ")\n";
            }
        });
    }

    private final void convertRelativeFileLinksToAbsolute() {
        Regex regex = RELATIVE_LINK_REGEX;
        this.markdown = regex.replace((CharSequence)this.markdown, (Function1)new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ HuggingFaceReadmeCleaner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String linkText = (String)destructured.getMatch().getGroupValues().get(1);
                String relativePath = (String)destructured.getMatch().getGroupValues().get(2);
                String string = HuggingFaceURLProvider.INSTANCE.makeAbsoluteFileLink(HuggingFaceReadmeCleaner.access$getEntityId$p(this.this$0), relativePath).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String absoluteUrl = string;
                return "[" + linkText + "](" + absoluteUrl + ")";
            }
        });
    }

    private final void removeMarkdownSeparators() {
        CharSequence charSequence = this.markdown;
        Regex regex = MD_SEPARATORS_REGEX;
        String string = "\n";
        this.markdown = regex.replace(charSequence, string);
    }

    @Nls
    @NotNull
    public final String getMarkdown() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.markdown;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = HuggingFaceDocumentationPlaceholdersUtil.INSTANCE.noReadmePlaceholder(this.entityId, this.entityKind);
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public static final /* synthetic */ URL access$getCardUrl$p(HuggingFaceReadmeCleaner $this) {
        return $this.cardUrl;
    }

    public static final /* synthetic */ String access$getEntityId$p(HuggingFaceReadmeCleaner $this) {
        return $this.entityId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceReadmeCleaner$Companion;", "", "()V", "ERR_PY_CODE_FENCE_HEADER", "", "HF_MD_HEADER_SEPARATOR", "HTML_IMG_REGEX", "Lkotlin/text/Regex;", "INTERNAL_LINK_REGEX", "MARKDOWN_HEADER_REGEX", "MD_IMG_REGEX", "MD_SEPARATORS_REGEX", "PY_CODE_FENCE_HEADER", "RELATIVE_LINK_REGEX", "SUMMARY_TAGS_REGEX", "intellij.python.community.impl.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

