/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstLiteralExpression;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PyAstStringLiteralExpression
extends PyAstLiteralExpression,
StringLiteralExpression,
PsiLanguageInjectionHost {
    default public boolean isValidHost() {
        return true;
    }

    default public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(0);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    @NotNull
    default public List<ASTNode> getStringNodes() {
        TokenSet stringNodeTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{PyTokenTypes.STRING_NODES, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_NODE})});
        List<ASTNode> list = Arrays.asList(this.getNode().getChildren(stringNodeTypes));
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    default public List<? extends PyAstStringElement> getStringElements() {
        List list = StreamEx.of(this.getStringNodes()).map(ASTNode::getPsi).select(PyAstStringElement.class).toList();
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    default public List<TextRange> getStringValueTextRanges() {
        int elementStart = this.getTextRange().getStartOffset();
        List list = ContainerUtil.map(this.getStringElements(), node -> {
            int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
            return node.getContentRange().shiftRight(nodeRelativeOffset);
        });
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstStringLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstStringLiteralExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

