/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEditorHighlighter
extends LexerEditorHighlighter {
    private Boolean hadUnicodeImport;
    public static final Key<Boolean> KEY = new Key("python.future.import");

    public PythonEditorHighlighter(@NotNull EditorColorsScheme scheme, @Nullable Project project2, @Nullable VirtualFile file) {
        if (scheme == null) {
            PythonEditorHighlighter.$$$reportNull$$$0(0);
        }
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)(file != null ? file.getFileType() : PythonFileType.INSTANCE), (Project)project2, (VirtualFile)file), scheme);
        this.hadUnicodeImport = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            PythonEditorHighlighter.$$$reportNull$$$0(1);
        }
        PythonEditorHighlighter pythonEditorHighlighter = this;
        synchronized (pythonEditorHighlighter) {
            Document document = e.getDocument();
            Lexer l = this.getLexer();
            if (l instanceof LayeredLexer) {
                Lexer delegate = ((LayeredLexer)l).getDelegate();
                int offset = e.getOffset();
                int lineNumber = document.getLineNumber(offset);
                TextRange tr = new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber));
                document.putUserData(KEY, (Object)(!document.getText(tr).contains("unicode_literals") ? 1 : 0));
                Boolean hasUnicodeImport = (Boolean)document.getUserData(KEY);
                if (delegate instanceof PythonHighlightingLexer && (((PythonHighlightingLexer)delegate).getImportOffset() > e.getOffset() || hasUnicodeImport != this.hadUnicodeImport)) {
                    ((PythonHighlightingLexer)delegate).clearState(e.getDocument().getTextLength());
                    this.setText(document.getCharsSequence());
                } else {
                    super.documentChanged(e);
                }
            } else {
                super.documentChanged(e);
            }
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            PythonEditorHighlighter.$$$reportNull$$$0(2);
        }
        Document document = e.getDocument();
        this.hadUnicodeImport = (Boolean)document.getUserData(KEY);
    }

    public void setEditor(@NotNull HighlighterClient editor2) {
        Lexer l;
        if (editor2 == null) {
            PythonEditorHighlighter.$$$reportNull$$$0(3);
        }
        if ((l = this.getLexer()) instanceof LayeredLexer) {
            editor2.getDocument().putUserData(KEY, (Object)(!editor2.getDocument().getText().contains("unicode_literals") ? 1 : 0));
        }
        super.setEditor(editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/highlighting/PythonEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeDocumentChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

