/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyTypeDeclarationStatementNavigator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRedeclarationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyRedeclarationInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!PyKnownDecoratorUtil.hasUnknownDecorator(node, this.myTypeEvalContext) && !PyKnownDecoratorUtil.hasRedeclarationDecorator(node, this.myTypeEvalContext)) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (node.isQualified() || "_".equals(node.getText()) || PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(node)) {
                return;
            }
            ScopeOwner owner = ScopeUtil.getScopeOwner(node);
            if (owner instanceof PyFile || owner instanceof PyClass) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (!Visitor.isDecorated(node)) {
                this.processElement(node);
            }
        }

        private static boolean isDecorated(@NotNull PyDecoratable node) {
            PyDecorator[] decorators;
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            boolean isDecorated = false;
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (decoratorList != null && (decorators = decoratorList.getDecorators()).length > 0) {
                isDecorated = true;
            }
            return isDecorated;
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            String name2 = element.getName();
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            if (owner != null && name2 != null) {
                int startInstruction;
                PyImportStatement importStatement;
                Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
                Object elementInControlFlow = element;
                if (element instanceof PyTargetExpression && (importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class)) != null) {
                    elementInControlFlow = importStatement;
                }
                if ((startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)elementInControlFlow)) < 0) {
                    return;
                }
                Ref readElementRef = Ref.create(null);
                Ref writeElementRef = Ref.create(null);
                Ref underPossiblyFalseCondition = Ref.create((Object)false);
                ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, instruction -> {
                    if (instruction instanceof ReadWriteInstruction) {
                        ReadWriteInstruction rwInstruction = (ReadWriteInstruction)((Object)instruction);
                        if (instruction.num() != startInstruction && name2.equals(rwInstruction.getName())) {
                            PsiElement originalElement = rwInstruction.getElement();
                            if (originalElement != null) {
                                if (rwInstruction.getAccess().isReadAccess()) {
                                    readElementRef.set((Object)originalElement);
                                }
                                if (rwInstruction.getAccess().isWriteAccess() && originalElement != element) {
                                    if (PyiUtil.isOverload(originalElement, this.myTypeEvalContext) || PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(originalElement)) {
                                        return ControlFlowUtil.Operation.NEXT;
                                    }
                                    if (!((Boolean)underPossiblyFalseCondition.get()).booleanValue()) {
                                        writeElementRef.set((Object)originalElement);
                                    }
                                }
                            }
                            return ControlFlowUtil.Operation.CONTINUE;
                        }
                    }
                    if (Visitor.possiblyFalseCondition(instruction)) {
                        underPossiblyFalseCondition.set((Object)true);
                    }
                    return ControlFlowUtil.Operation.NEXT;
                });
                PsiElement writeElement = (PsiElement)writeElementRef.get();
                if (writeElement != null && readElementRef.get() == null) {
                    PsiElement identifier;
                    LocalQuickFix quickFix;
                    if (PsiTreeUtil.findCommonParent((PsiElement)writeElement, (PsiElement)element) instanceof PyPattern) {
                        return;
                    }
                    ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                    if (Visitor.suggestRename(element, writeElement) && (quickFix = PythonUiService.getInstance().createPyRenameElementQuickFix((PsiElement)element)) != null) {
                        quickFixes.add(quickFix);
                    }
                    this.registerProblem((PsiElement)((identifier = element.getNameIdentifier()) != null ? identifier : element), PyPsiBundle.message("INSP.redeclared.name", name2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private static boolean possiblyFalseCondition(@NotNull Instruction instruction) {
            ConditionalInstruction conditionalInstruction;
            PsiElement condition2;
            PsiElement element;
            if (instruction == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((element = instruction.getElement()) == null) {
                return false;
            }
            if (element instanceof PyTryPart || element instanceof PyExceptPart || element instanceof PyConditionalExpression) {
                return true;
            }
            if (element instanceof PyForStatement) {
                PyForPart forPart = ((PyForStatement)element).getForPart();
                return !PyEvaluator.evaluateAsBoolean(forPart.getSource(), false);
            }
            if (instruction instanceof ConditionalInstruction && (condition2 = (conditionalInstruction = (ConditionalInstruction)instruction).getCondition()) instanceof PyExpression) {
                return conditionalInstruction.getResult() ? !PyEvaluator.evaluateAsBoolean((PyExpression)condition2, false) : PyEvaluator.evaluateAsBoolean((PyExpression)condition2, true);
            }
            return false;
        }

        private static boolean suggestRename(@NotNull PsiNameIdentifierOwner element, @NotNull PsiElement originalElement) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (originalElement == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (element instanceof PyTargetExpression && originalElement instanceof PyTargetExpression) {
                return false;
            }
            return !PyUtil.isInitMethod((PsiElement)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalElement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDecorated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "possiblyFalseCondition";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suggestRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

