/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyStatementEffectQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.StatementEffectFunctionCallQuickFix;
import com.jetbrains.python.inspections.quickfix.StatementEffectIntroduceVariableQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStatementEffectInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @Override
    protected boolean isSuppressForCodeFragment() {
        return true;
    }

    @NotNull
    private static List<LocalQuickFix> getQuickFixesFromExtensions(@NotNull PyExpressionStatement expressionStatement) {
        if (expressionStatement == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.mapNotNull((Collection)PyStatementEffectQuickFixProvider.EP_NAME.getExtensionList(), extension -> extension.getQuickFix(expressionStatement));
        if (list == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyStatementEffectInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyStatementEffectInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesFromExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesFromExtensions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
            PyReferenceExpression reference;
            PyAstStatementList statementList;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (ContainerUtil.exists((Iterable)PyInspectionExtension.EP_NAME.getExtensionList(), extension -> extension.ignoreNoEffectStatement(node))) {
                return;
            }
            PyExpression expression = node.getExpression();
            if (PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
                return;
            }
            if (this.hasEffect(expression)) {
                return;
            }
            if (expression instanceof PyStringLiteralExpression) {
                return;
            }
            PyTryPart tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class);
            if (tryPart != null && (statementList = tryPart.getStatementList()).getStatements().length == 1 && statementList.getStatements()[0] == node) {
                return;
            }
            SmartList quickFixes = new SmartList(PyStatementEffectInspection.getQuickFixesFromExtensions(node));
            if (!(expression instanceof PyReferenceExpression) || (reference = (PyReferenceExpression)expression).isQualified()) {
                quickFixes.add(new StatementEffectIntroduceVariableQuickFix());
            }
            this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.statement.effect.statement.seems.to.have.no.effect", new Object[0]), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        private boolean hasEffect(@Nullable PyExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyCallExpression || expression instanceof PyYieldExpression) {
                return true;
            }
            if (expression instanceof PyListCompExpression) {
                if (this.hasEffect((PyExpression)((PyListCompExpression)expression).getResultExpression())) {
                    return true;
                }
            } else if (expression instanceof PyBinaryExpression) {
                String method;
                PyBinaryExpression binary = (PyBinaryExpression)expression;
                PyElementType operator = binary.getOperator();
                if (PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator)) {
                    return false;
                }
                PyExpression leftExpression = binary.getLeftExpression();
                PyExpression rightExpression = binary.getRightExpression();
                if (this.hasEffect(leftExpression) || this.hasEffect(rightExpression)) {
                    return true;
                }
                String string = method = operator == null ? null : operator.getSpecialMethodName();
                if (method != null) {
                    PyType type2 = this.myTypeEvalContext.getType(leftExpression);
                    if (type2 != null && !type2.isBuiltin() && type2.resolveMember(method, null, AccessDirection.READ, this.getResolveContext()) != null) {
                        return true;
                    }
                    if (rightExpression != null && (type2 = this.myTypeEvalContext.getType(rightExpression)) != null) {
                        String rmethod = "__r" + method.substring(2);
                        if (!type2.isBuiltin() && type2.resolveMember(rmethod, null, AccessDirection.READ, this.getResolveContext()) != null) {
                            return true;
                        }
                    }
                }
            } else {
                if (expression instanceof PyConditionalExpression) {
                    PyConditionalExpression conditionalExpression = (PyConditionalExpression)expression;
                    return this.hasEffect(conditionalExpression.getTruePart()) || this.hasEffect(conditionalExpression.getFalsePart());
                }
                if (expression instanceof PyParenthesizedExpression) {
                    PyParenthesizedExpression parenthesizedExpression = (PyParenthesizedExpression)expression;
                    return this.hasEffect(parenthesizedExpression.getContainedExpression());
                }
                if (expression instanceof PyReferenceExpression) {
                    ResolveResult[] results;
                    PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                    for (ResolveResult res : results = referenceExpression.getReference(this.getResolveContext()).multiResolve(true)) {
                        if (!(res.getElement() instanceof PyFunction)) continue;
                        this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.statement.effect.statement.having.no.effect.can.be.replaced.with.function.call", new Object[0]), new LocalQuickFix[]{new StatementEffectFunctionCallQuickFix()});
                        return true;
                    }
                } else if (expression instanceof PyTupleExpression) {
                    PyExpression[] elements;
                    for (PyExpression element : elements = ((PyTupleExpression)expression).getElements()) {
                        if (!this.hasEffect(element)) continue;
                        return true;
                    }
                } else {
                    if (expression instanceof PyPrefixExpression) {
                        PyPrefixExpression prefixExpr = (PyPrefixExpression)expression;
                        return prefixExpr.getOperator() == PyTokenTypes.AWAIT_KEYWORD;
                    }
                    if (expression instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)expression).isEllipsis()) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyStatementEffectInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyExpressionStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

