/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.ConvertIndentsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonCodeStyleService;
import org.jetbrains.annotations.NotNull;

public class ConvertIndentsFix
implements LocalQuickFix {
    private final boolean myToSpaces;

    public ConvertIndentsFix(boolean toSpaces) {
        this.myToSpaces = toSpaces;
    }

    @NotNull
    public String getName() {
        String string = this.myToSpaces ? PyPsiBundle.message("QFIX.convert.indents.to.spaces", new Object[0]) : PyPsiBundle.message("QFIX.convert.indents.to.tabs", new Object[0]);
        if (string == null) {
            ConvertIndentsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.convert.indents", new Object[0]);
        if (string == null) {
            ConvertIndentsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            ConvertIndentsFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ConvertIndentsFix.$$$reportNull$$$0(3);
        }
        PsiFile file = descriptor2.getPsiElement().getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document != null) {
            int tabSize = PythonCodeStyleService.getInstance().getIndentSize(file);
            TextRange allDoc = new TextRange(0, document.getTextLength());
            if (this.myToSpaces) {
                ConvertIndentsUtil.convertIndentsToSpaces((Document)document, (int)tabSize, (TextRange)allDoc);
            } else {
                ConvertIndentsUtil.convertIndentsToTabs((Document)document, (int)tabSize, (TextRange)allDoc);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

