/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyChangeSignatureQuickFix
extends LocalQuickFixOnPsiElement {
    public static final Key<Boolean> CHANGE_SIGNATURE_ORIGINAL_CALL = Key.create((String)"CHANGE_SIGNATURE_ORIGINAL_CALL");
    private final List<Pair<Integer, PyParameterInfo>> myExtraParameters;
    @Nullable
    private final SmartPsiElementPointer<PyCallSiteExpression> myOriginalCallSiteExpression;

    @NotNull
    public static PyChangeSignatureQuickFix forMismatchedCall(@NotNull PyCallExpression.PyArgumentsMapping mapping) {
        PyParameter[] parameters;
        if (mapping == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(0);
        }
        assert (mapping.getCallableType() != null);
        PyFunction function = PyUtil.as(mapping.getCallableType().getCallable(), PyFunction.class);
        assert (function != null);
        PyCallSiteExpression callSiteExpression = mapping.getCallSiteExpression();
        int positionalParamAnchor = -1;
        for (PyParameter parameter : parameters = function.getParameterList().getParameters()) {
            boolean isVararg;
            PyNamedParameter namedParam = parameter.getAsNamed();
            boolean bl = isVararg = namedParam != null && (namedParam.isPositionalContainer() || namedParam.isKeywordContainer());
            if (parameter instanceof PySingleStarParameter || parameter.hasDefaultValue() || isVararg) break;
            ++positionalParamAnchor;
        }
        ArrayList<Pair<Integer, PyParameterInfo>> newParameters = new ArrayList<Pair<Integer, PyParameterInfo>>();
        TypeEvalContext context = TypeEvalContext.userInitiated(function.getProject(), callSiteExpression.getContainingFile());
        HashSet<String> usedParamNames = new HashSet<String>();
        for (PyExpression arg : mapping.getUnmappedArguments()) {
            if (arg instanceof PyKeywordArgument) {
                PyExpression value = ((PyKeywordArgument)arg).getValueExpression();
                String valueText = value != null ? value.getText() : "";
                newParameters.add((Pair<Integer, PyParameterInfo>)Pair.create((Object)(parameters.length - 1), (Object)new PyParameterInfo(-1, ((PyKeywordArgument)arg).getKeyword(), valueText, true)));
                continue;
            }
            String paramName = PyChangeSignatureQuickFix.generateParameterName(arg, function, usedParamNames, context);
            newParameters.add((Pair<Integer, PyParameterInfo>)Pair.create((Object)positionalParamAnchor, (Object)new PyParameterInfo(-1, paramName, arg.getText(), false)));
            usedParamNames.add(paramName);
        }
        return new PyChangeSignatureQuickFix(function, newParameters, mapping.getCallSiteExpression());
    }

    @NotNull
    public static PyChangeSignatureQuickFix forMismatchingMethods(@NotNull PyFunction function, @NotNull PyFunction complementary) {
        if (function == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(1);
        }
        if (complementary == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(2);
        }
        int paramLength = function.getParameterList().getParameters().length;
        int complementaryParamLength = complementary.getParameterList().getParameters().length;
        List<Object> extraParams = complementaryParamLength > paramLength ? Collections.singletonList(Pair.create((Object)(paramLength - 1), (Object)new PyParameterInfo(-1, "**kwargs", "", false))) : Collections.emptyList();
        return new PyChangeSignatureQuickFix(function, extraParams, null);
    }

    private PyChangeSignatureQuickFix(@NotNull PyFunction function, @NotNull List<Pair<Integer, PyParameterInfo>> extraParameters, @Nullable PyCallSiteExpression expression) {
        if (function == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(3);
        }
        if (extraParameters == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(4);
        }
        super((PsiElement)function);
        this.myExtraParameters = ContainerUtil.sorted(extraParameters, Comparator.comparingInt(p -> (Integer)p.getFirst()));
        this.myOriginalCallSiteExpression = expression != null ? SmartPointerManager.getInstance((Project)function.getProject()).createSmartPsiElementPointer((PsiElement)expression) : null;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.change.signature", new Object[0]);
        if (string == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        PyFunction function = this.getFunction();
        if (function == null) {
            String string = this.getFamilyName();
            if (string == null) {
                PyChangeSignatureQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        String params = StringUtil.join(this.createMethodDescriptor(function).getParameters(), info -> info.isNew() ? PyBundle.message("QFIX.bold.html.text", info.getName()) : info.getName(), (String)", ");
        String message = PyBundle.message("QFIX.change.signature.of", StringUtil.notNullize((String)function.getName()) + "(" + params + ")");
        String string = XmlStringUtil.wrapInHtml((CharSequence)message);
        if (string == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private PyFunction getFunction() {
        return (PyFunction)this.getStartElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(11);
        }
        PyFunction function = this.getFunction();
        PyMethodDescriptor descriptor2 = this.createMethodDescriptor(function);
        PyChangeSignatureDialog dialog2 = new PyChangeSignatureDialog(project2, descriptor2){

            protected int getSelectedIdx() {
                return (int)StreamEx.of((Collection)this.getParameters()).indexOf(info -> info.getOldIndex() < 0).orElse(super.getSelectedIdx());
            }
        };
        PyCallSiteExpression originalCallSite = this.myOriginalCallSiteExpression != null ? (PyCallSiteExpression)this.myOriginalCallSiteExpression.getElement() : null;
        try {
            if (originalCallSite != null) {
                originalCallSite.putUserData(CHANGE_SIGNATURE_ORIGINAL_CALL, true);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                BaseRefactoringProcessor processor2 = dialog2.createRefactoringProcessor();
                dialog2.close(0);
                processor2.run();
            } else {
                dialog2.show();
            }
        }
        finally {
            if (originalCallSite != null) {
                originalCallSite.putUserData(CHANGE_SIGNATURE_ORIGINAL_CALL, null);
            }
        }
    }

    @NotNull
    private static String generateParameterName(@NotNull PyExpression argumentValue, @NotNull PyFunction function, @NotNull Set<String> usedParameterNames, @NotNull TypeEvalContext context) {
        if (argumentValue == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(12);
        }
        if (function == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(13);
        }
        if (usedParameterNames == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(15);
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        PyCallExpression callExpr = PyUtil.as(argumentValue, PyCallExpression.class);
        PyElement referenceElem = PyUtil.as(callExpr != null ? callExpr.getCallee() : argumentValue, PyReferenceExpression.class);
        if (referenceElem != null) {
            suggestions.addAll(NameSuggesterUtil.generateNames(referenceElem.getText()));
        }
        if (suggestions.isEmpty()) {
            PyType type2 = context.getType(argumentValue);
            if (type2 instanceof PyUnionType) {
                type2 = (PyType)ContainerUtil.find(((PyUnionType)type2).getMembers(), (Condition)Conditions.instanceOf(PyClassType.class));
            }
            String typeName = type2 != null && type2.getName() != null ? type2.getName() : "object";
            suggestions.addAll(NameSuggesterUtil.generateNamesByType(typeName));
        }
        String shortestName = Collections.min(suggestions, Comparator.comparingInt(String::length));
        Object result2 = shortestName;
        int counter = 1;
        while (!PyRefactoringUtil.isValidNewName((String)result2, (PsiElement)function.getStatementList()) || usedParameterNames.contains(result2)) {
            result2 = shortestName + counter;
            ++counter;
        }
        Object object = result2;
        if (object == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    private PyMethodDescriptor createMethodDescriptor(PyFunction function) {
        return new PyMethodDescriptor(function){

            @Override
            @NotNull
            public List<PyParameterInfo> getParameters() {
                ArrayList<PyParameterInfo> result2 = new ArrayList<PyParameterInfo>();
                List<PyParameterInfo> originalParams = super.getParameters();
                PeekingIterator extra = Iterators.peekingIterator(PyChangeSignatureQuickFix.this.myExtraParameters.iterator());
                while (extra.hasNext() && (Integer)((Pair)extra.peek()).getFirst() < 0) {
                    result2.add((PyParameterInfo)((Pair)extra.next()).getSecond());
                }
                for (int i = 0; i < originalParams.size(); ++i) {
                    result2.add(originalParams.get(i));
                    while (extra.hasNext() && (Integer)((Pair)extra.peek()).getFirst() == i) {
                        result2.add((PyParameterInfo)((Pair)extra.next()).getSecond());
                    }
                }
                ArrayList<PyParameterInfo> arrayList = result2;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix$2", "getParameters"));
            }
        };
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            PyChangeSignatureQuickFix.$$$reportNull$$$0(17);
        }
        return this.getFunction();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "complementary";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraParameters";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedParameterNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forMismatchedCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forMismatchingMethods";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 16 -> new IllegalStateException(string);
        };
    }
}

