/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.util.BooleanFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.newProject.MainPartUiCustomizer;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.newProject.collector.PythonNewProjectWizardCollector;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PySyncCheckCreateIfPossible;
import com.jetbrains.python.remote.PySyncCheckOnly;
import com.jetbrains.python.remote.PySyncDirection;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.v2.PythonInterpreterSelectionMode;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonProjectGenerator<T extends PyNewProjectSettings>
extends DirectoryProjectGeneratorBase<T> {
    public static final PyNewProjectSettings NO_SETTINGS = new PyNewProjectSettings();
    private static final Logger LOGGER = Logger.getInstance(PythonProjectGenerator.class);
    private final List<SettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final boolean myAllowRemoteProjectCreation;
    @Nullable
    private MouseListener myErrorLabelMouseListener;
    protected Consumer<String> myErrorCallback;
    @Nullable
    private final PythonInterpreterSelectionMode preferredEnvironmentType;

    protected PythonProjectGenerator(boolean allowRemoteProjectCreation) {
        this(allowRemoteProjectCreation, null);
    }

    protected PythonProjectGenerator() {
        this(false, null);
    }

    protected PythonProjectGenerator(boolean allowRemoteProjectCreation, @Nullable PythonInterpreterSelectionMode preferredInterpreter) {
        this.myAllowRemoteProjectCreation = allowRemoteProjectCreation;
        this.preferredEnvironmentType = preferredInterpreter;
    }

    public final void setErrorCallback(@NotNull Consumer<String> errorCallback) {
        if (errorCallback == null) {
            PythonProjectGenerator.$$$reportNull$$$0(0);
        }
        this.myErrorCallback = errorCallback;
    }

    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public MainPartUiCustomizer getMainPartUiCustomizer() {
        return null;
    }

    @Nullable
    public JPanel extendBasePanel() throws ProcessCanceledException {
        return null;
    }

    public void checkProjectCanBeCreatedOnSdk(@NotNull Sdk sdk2, @NotNull File projectDirectory) throws PyNoProjectAllowedOnSdkException {
        if (sdk2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(1);
        }
        if (projectDirectory == null) {
            PythonProjectGenerator.$$$reportNull$$$0(2);
        }
        if (!this.myAllowRemoteProjectCreation && PythonSdkUtil.isRemote(sdk2)) {
            throw new PyNoProjectAllowedOnSdkException(PyBundle.message("python.remote.interpreter.can.t.create.project.this.type", new Object[0]));
        }
        PyProjectSynchronizer synchronizer = PyProjectSynchronizerProvider.getSynchronizer(sdk2);
        if (synchronizer == null) {
            return;
        }
        String syncError = synchronizer.checkSynchronizationAvailable(new PySyncCheckOnly(projectDirectory));
        if (syncError != null) {
            throw new PyNoProjectAllowedOnSdkException(syncError);
        }
    }

    public final void generateProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module) {
        PyProjectSynchronizer synchronizer;
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PythonProjectGenerator.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == NO_SETTINGS) {
            this.configureProjectNoSettings(project2, baseDir, module);
            return;
        }
        Sdk sdk2 = ((PyNewProjectSettings)settings).getSdk();
        if (sdk2 instanceof PyLazySdk) {
            Sdk createdSdk = ((PyLazySdk)sdk2).create();
            ((PyNewProjectSettings)settings).setSdk(createdSdk);
            if (createdSdk != null && !PythonProjectGenerator.useNewInterpreterCreationUi()) {
                SdkConfigurationUtil.addSdk((Sdk)createdSdk);
            }
        }
        PyProjectSynchronizer pyProjectSynchronizer = synchronizer = sdk2 != null ? PyProjectSynchronizerProvider.getSynchronizer(sdk2) : null;
        if (synchronizer != null) {
            String syncError;
            String userProvidedPath = ((PyNewProjectSettings)settings).getRemotePath();
            while ((syncError = synchronizer.checkSynchronizationAvailable(new PySyncCheckCreateIfPossible(module, userProvidedPath))) != null) {
                userProvidedPath = null;
                String message = PyBundle.message("python.new.project.synchronization.not.configured.dialog.message", syncError);
                if (Messages.showYesNoDialog((Project)project2, (String)message, (String)PyBundle.message("python.new.project.synchronization.not.configured.dialog.title", new Object[0]), (Icon)AllIcons.General.WarningDialog) != 0) continue;
                break;
            }
        }
        this.configureProject(project2, baseDir, settings, module, synchronizer);
        this.reportStatistics(settings);
    }

    protected void reportStatistics(@NotNull T settings) {
        Object statisticsInfo;
        if (settings == null) {
            PythonProjectGenerator.$$$reportNull$$$0(7);
        }
        if ((statisticsInfo = ((PyNewProjectSettings)settings).getInterpreterInfoForStatistics()) instanceof InterpreterStatisticsInfo) {
            InterpreterStatisticsInfo interpreterStatisticsInfo = (InterpreterStatisticsInfo)statisticsInfo;
            if (((PyNewProjectSettings)settings).getSdk() != null) {
                PythonNewProjectWizardCollector.logPythonNewProjectGenerated(interpreterStatisticsInfo, PyStatisticToolsKt.getVersion(((PyNewProjectSettings)settings).getSdk()), ((Object)((Object)this)).getClass(), Collections.emptyList());
            }
        }
    }

    protected void configureProjectNoSettings(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull Module module) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(9);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(10);
        }
        throw new IllegalStateException(String.format("%s does not support project creation with out of settings. See %s doc for detail", ((Object)((Object)this)).getClass(), PythonProjectGenerator.class));
    }

    protected void configureProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(11);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            PythonProjectGenerator.$$$reportNull$$$0(13);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(14);
        }
        if (synchronizer != null) {
            synchronizer.syncProject(module, PySyncDirection.LOCAL_TO_REMOTE, null, new String[0]);
        }
    }

    public Object getProjectSettings() {
        return new PyNewProjectSettings();
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk2) {
        return ValidationResult.OK;
    }

    public void addSettingsStateListener(@NotNull SettingsListener listener2) {
        if (listener2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(15);
        }
        this.myListeners.add(listener2);
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            PythonProjectGenerator.$$$reportNull$$$0(16);
        }
    }

    @Nullable
    public final PythonInterpreterSelectionMode getPreferredEnvironmentType() {
        return this.preferredEnvironmentType;
    }

    public void fireStateChanged() {
        for (SettingsListener listener2 : this.myListeners) {
            listener2.stateChanged();
        }
    }

    @Nullable
    public BooleanFunction<PythonProjectGenerator> beforeProjectGenerated(@Nullable Sdk sdk2) {
        return null;
    }

    public void afterProjectGenerated(@NotNull Project project2) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(17);
        }
    }

    public void addErrorLabelMouseListener(@NotNull MouseListener mouseListener) {
        if (mouseListener == null) {
            PythonProjectGenerator.$$$reportNull$$$0(18);
        }
        this.myErrorLabelMouseListener = mouseListener;
    }

    @Nullable
    public MouseListener getErrorLabelMouseListener() {
        return this.myErrorLabelMouseListener;
    }

    public void createAndAddVirtualEnv(Project project2, PyNewProjectSettings settings) {
    }

    protected static void reportPackageInstallationFailure(@NotNull String frameworkName, @Nullable Pair<Sdk, ExecutionException> sdkAndException) {
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(19);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = PythonProjectGenerator.getErrorDescription(sdkAndException, frameworkName);
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> PyPackagesNotificationPanel.showPackageInstallationError(PyBundle.message("python.new.project.install.failed.title", frameworkName), errorDescription));
    }

    @NotNull
    private static PyPackageManagementService.PyPackageInstallationErrorDescription getErrorDescription(@Nullable Pair<Sdk, ExecutionException> sdkAndException, @NotNull String packageName2) {
        ExecutionException exception;
        if (packageName2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(20);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = null;
        if (sdkAndException != null && (errorDescription = PyPackageManagementService.toErrorDescription(Collections.singletonList(exception = (ExecutionException)((Object)sdkAndException.second)), (Sdk)sdkAndException.first, packageName2)) == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(exception.getMessage());
        }
        if (errorDescription == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(PyBundle.message("python.new.project.error.solution.another.sdk", new Object[0]));
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription pyPackageInstallationErrorDescription = errorDescription;
        if (pyPackageInstallationErrorDescription == null) {
            PythonProjectGenerator.$$$reportNull$$$0(21);
        }
        return pyPackageInstallationErrorDescription;
    }

    @NotNull
    public static Future<Void> installFrameworkIfNeeded(@NotNull Project project2, @NotNull String frameworkName, @NotNull String requirement, @Nullable Sdk sdk2, boolean forceInstallFramework, @Nullable Runnable callback) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(22);
        }
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(23);
        }
        if (requirement == null) {
            PythonProjectGenerator.$$$reportNull$$$0(24);
        }
        return PythonProjectGenerator.installFrameworkIfNeeded(project2, frameworkName, requirement, sdk2, forceInstallFramework, false, callback);
    }

    @NotNull
    public static Future<Void> installFrameworkInBackground(@NotNull Project project2, @NotNull String frameworkName, @NotNull String requirement, @Nullable Sdk sdk2, boolean forceInstallFramework, @Nullable Runnable callback) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(25);
        }
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(26);
        }
        if (requirement == null) {
            PythonProjectGenerator.$$$reportNull$$$0(27);
        }
        return PythonProjectGenerator.installFrameworkIfNeeded(project2, frameworkName, requirement, sdk2, forceInstallFramework, true, callback);
    }

    @NotNull
    private static Future<Void> installFrameworkIfNeeded(@NotNull Project project2, final @NotNull String frameworkName, final @NotNull String requirement, final @Nullable Sdk sdk2, final boolean forceInstallFramework, boolean asBackgroundTask, final @Nullable Runnable callback) {
        if (project2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(28);
        }
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(29);
        }
        if (requirement == null) {
            PythonProjectGenerator.$$$reportNull$$$0(30);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (sdk2 == null) {
            PythonProjectGenerator.reportPackageInstallationFailure(frameworkName, null);
            future.completeExceptionally(new RuntimeException("No SDK provided"));
            CompletableFuture<Void> completableFuture = future;
            if (completableFuture == null) {
                PythonProjectGenerator.$$$reportNull$$$0(31);
            }
            return completableFuture;
        }
        if (forceInstallFramework || PythonSdkUtil.isRemote(sdk2)) {
            if (asBackgroundTask) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, PyBundle.message("python.install.framework.ensure.installed", frameworkName), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PythonProjectGenerator.installPackages(frameworkName, forceInstallFramework, indicator, requirement, sdk2);
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        future.completeExceptionally(error);
                    }

                    public void onSuccess() {
                        future.complete(null);
                        if (callback != null) {
                            callback.run();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/newProject/PythonProjectGenerator$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, PyBundle.message("python.install.framework.ensure.installed", frameworkName), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        PythonProjectGenerator.installPackages(frameworkName, forceInstallFramework, indicator, requirement, sdk2);
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        future.completeExceptionally(error);
                    }

                    public void onSuccess() {
                        future.complete(null);
                        if (callback != null) {
                            callback.run();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/newProject/PythonProjectGenerator$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        } else {
            future.complete(null);
            if (callback != null) {
                assert (SwingUtilities.isEventDispatchThread());
                callback.run();
            }
        }
        CompletableFuture<Void> completableFuture = future;
        if (completableFuture == null) {
            PythonProjectGenerator.$$$reportNull$$$0(32);
        }
        return completableFuture;
    }

    @Nullable
    public String getNewProjectPrefix() {
        return null;
    }

    public boolean supportsWelcomeScript() {
        return false;
    }

    private static void installPackages(@NotNull String frameworkName, boolean forceInstallFramework, @NotNull ProgressIndicator indicator, @NotNull String requirement, @NotNull Sdk sdk2) {
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(33);
        }
        if (indicator == null) {
            PythonProjectGenerator.$$$reportNull$$$0(34);
        }
        if (requirement == null) {
            PythonProjectGenerator.$$$reportNull$$$0(35);
        }
        if (sdk2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(36);
        }
        PyPackageManager packageManager = PyPackageManager.getInstance(sdk2);
        boolean installed = false;
        if (!forceInstallFramework) {
            indicator.setText(PyBundle.message("python.install.framework.checking.is.installed", frameworkName));
            List<PyPackage> packages2 = PyPackageUtil.refreshAndGetPackagesModally(sdk2);
            boolean bl = installed = PyPsiPackageUtil.findPackage(packages2, requirement) != null;
        }
        if (!installed) {
            indicator.setText(PyBundle.message("python.install.framework.installing", frameworkName));
            try {
                packageManager.install(requirement);
                packageManager.refresh();
            }
            catch (ExecutionException e) {
                PythonProjectGenerator.reportPackageInstallationFailure(requirement, (Pair<Sdk, ExecutionException>)Pair.create((Object)sdk2, (Object)((Object)e)));
            }
        }
    }

    public static boolean useNewInterpreterCreationUi() {
        return Registry.is((String)"python.new.interpreter.creation.ui") && !PlatformUtils.isDataSpell();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCallback";
                break;
            }
            case 1: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDirectory";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 17: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseListener";
                break;
            }
            case 19: 
            case 23: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 21: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "installFrameworkIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setErrorCallback";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectCanBeCreatedOnSdk";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportStatistics";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectNoSettings";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "afterProjectGenerated";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addErrorLabelMouseListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportPackageInstallationFailure";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 21: 
            case 31: 
            case 32: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "installFrameworkIfNeeded";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "installFrameworkInBackground";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "installPackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 31, 32 -> new IllegalStateException(string);
        };
    }

    public static class PyNoProjectAllowedOnSdkException
    extends Exception {
        PyNoProjectAllowedOnSdkException(@NotNull @NlsContexts.DialogMessage String reason) {
            if (reason == null) {
                PyNoProjectAllowedOnSdkException.$$$reportNull$$$0(0);
            }
            super(reason);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/jetbrains/python/newProject/PythonProjectGenerator$PyNoProjectAllowedOnSdkException", "<init>"));
        }
    }

    public static interface SettingsListener {
        public void stateChanged();
    }
}

