/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class PyPackageManagementService
extends PackageManagementServiceEx {
    @NotNull
    private static final Pattern PATTERN_ERROR_LINE = Pattern.compile(".*error:.*", 2);
    @NonNls
    protected static final String TEXT_PREFIX = PyPackageManagementService.buildHtmlStylePrefix();
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    @NotNull
    private final Project myProject;
    @NotNull
    protected final Sdk mySdk;
    protected final ExecutorService myExecutorService;
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";

    @NotNull
    private static String buildHtmlStylePrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PyPackageManagementService(@NotNull Project project2, @NotNull Sdk sdk2) {
        if (project2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(1);
        }
        if (sdk2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.mySdk = sdk2;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PyPackageManagementService Pool", (int)4);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk2 = this.mySdk;
        if (sdk2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(3);
        }
        return sdk2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(4);
        }
        return project2;
    }

    @Nullable
    public List<String> getAllRepositories() {
        ArrayList<String> result2 = new ArrayList<String>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result2.add("https://pypi.python.org/simple");
        }
        result2.addAll(PyPackageManagementService.getAdditionalRepositories());
        return result2;
    }

    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.loadPackages();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), false);
        List<RepoPackage> list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.updatePyPICache();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), true);
        List<RepoPackage> list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        ArrayList<RepoPackage> result2 = new ArrayList<RepoPackage>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result2.addAll(PyPackageManagementService.getCachedPyPIPackages());
        }
        result2.addAll(PyPIPackageUtil.INSTANCE.getAdditionalPackages(PyPackageManagementService.getAdditionalRepositories()));
        ArrayList<RepoPackage> arrayList = result2;
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public Map<String, List<RepoPackage>> getAllPackagesByRepository() {
        HashMap<String, List<RepoPackage>> result2 = new HashMap<String, List<RepoPackage>>();
        result2.put("https://pypi.python.org/simple", PyPackageManagementService.getCachedPyPIPackages());
        List<String> repositories = PyPackageManagementService.getAdditionalRepositories();
        for (String repo : repositories) {
            result2.put(repo, PyPIPackageUtil.INSTANCE.getAdditionalPackages(List.of(repo)));
        }
        return result2;
    }

    @NotNull
    private static List<String> getAdditionalRepositories() {
        List<String> list = PyPackageService.getInstance().additionalRepositories;
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<RepoPackage> getCachedPyPIPackages() {
        boolean customRepoConfigured = !PyPackageManagementService.getAdditionalRepositories().isEmpty();
        String url = customRepoConfigured ? "https://pypi.python.org/simple" : "";
        List list = ContainerUtil.map(PyPIPackageCache.getInstance().getPackageNames(), name2 -> new RepoPackage(name2, url, null));
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean canInstallToUser() {
        return !PythonSdkUtil.isVirtualEnv(this.mySdk);
    }

    @NotNull
    public String getInstallToUserText() {
        Object userSiteText = PyBundle.message("button.install.to.user.site.packages.directory", new Object[0]);
        if (!PythonSdkUtil.isRemote(this.mySdk)) {
            userSiteText = (String)userSiteText + " (" + PythonSdkUtil.getUserSite() + ")";
        }
        String string = userSiteText;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @NotNull
    public List<? extends InstalledPackage> getInstalledPackagesList() throws ExecutionException {
        ArrayList<PyPackage> packages2 = new ArrayList<PyPackage>(PyPackageManager.getInstance(this.mySdk).refreshAndGetPackages(true));
        packages2.sort(Comparator.comparing(InstalledPackage::getName));
        ArrayList<PyPackage> arrayList = packages2;
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void installPackage(final @NotNull RepoPackage repoPackage, @Nullable String version2, boolean forceUpgrade, @Nullable String extraOptions, final @NotNull PackageManagementService.Listener listener2, boolean installToUser) {
        if (repoPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(12);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(13);
        }
        final String packageName2 = repoPackage.getName();
        String repository = PyPIPackageUtil.isPyPIRepository(repoPackage.getRepoUrl()) ? null : repoPackage.getRepoUrl();
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (installToUser) {
            extraArgs.add("--user");
        }
        if (extraOptions != null) {
            Collections.addAll(extraArgs, extraOptions.split(" +"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)repository)) {
            extraArgs.add("--index-url");
            extraArgs.add(repository);
        }
        if (forceUpgrade) {
            extraArgs.add("-U");
        }
        PyRequirement req = version2 == null ? PyRequirementsKt.pyRequirement(packageName2) : PyRequirementsKt.pyRequirement(packageName2, PyRequirementRelation.EQ, version2);
        PyPackageManagerUI ui2 = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName2);
            }

            @Override
            public void finished(@Nullable List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName2, (PackageManagementService.ErrorDescription)PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk, repoPackage.getName()));
            }
        });
        ui2.install(Collections.singletonList(req), extraArgs);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk2) {
        return PyPackageManagementService.toErrorDescription(exceptions, sdk2, null);
    }

    @Nullable
    public static PyPackageInstallationErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk2, @Nullable String packageName2) {
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.isCancelled(exceptions)) {
            return PyPackageManagementService.createDescription(exceptions.get(0), sdk2, packageName2);
        }
        return null;
    }

    public void uninstallPackages(List<? extends InstalledPackage> installedPackages2, final @NotNull PackageManagementService.Listener listener2) {
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(14);
        }
        final String packageName2 = installedPackages2.size() == 1 ? installedPackages2.get(0).getName() : null;
        PyPackageManagerUI ui2 = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName2);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName2, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> pyPackages = new ArrayList<PyPackage>();
        for (InstalledPackage installedPackage : installedPackages2) {
            if (!(installedPackage instanceof PyPackage)) continue;
            pyPackages.add((PyPackage)installedPackage);
        }
        ui2.uninstall(pyPackages);
    }

    public void fetchPackageVersions(String packageName2, CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName2, consumer);
    }

    public void fetchPackageDetails(@NotNull String packageName2, final CatchingConsumer<? super @Nls String, ? super Exception> consumer) {
        if (packageName2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(15);
        }
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName2, new CatchingConsumer<PyPIPackageUtil.PackageDetails.Info, Exception>(){

            public void consume(PyPIPackageUtil.PackageDetails.Info details) {
                consumer.consume((Object)PyPackageManagementService.formatPackageInfo(details));
            }

            public void consume(Exception e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    private static String formatPackageInfo(@NotNull PyPIPackageUtil.PackageDetails.Info info) {
        String homePage;
        String authorEmail;
        String author;
        String version2;
        if (info == null) {
            PyPackageManagementService.$$$reportNull$$$0(16);
        }
        StringBuilder stringBuilder = new StringBuilder(TEXT_PREFIX);
        String description = info.getSummary();
        if (StringUtil.isNotEmpty((String)description)) {
            stringBuilder.append(description).append("<br/>");
        }
        if (StringUtil.isNotEmpty((String)(version2 = info.getVersion()))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(version2);
        }
        if (StringUtil.isNotEmpty((String)(author = info.getAuthor()))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(author).append("<br/><br/>");
        }
        if (StringUtil.isNotEmpty((String)(authorEmail = info.getAuthorEmail()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref("mailto:" + authorEmail));
        }
        if (StringUtil.isNotEmpty((String)(homePage = info.getHomePage()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref(homePage));
        }
        stringBuilder.append(TEXT_SUFFIX);
        return stringBuilder.toString();
    }

    @NotNull
    private static String composeHref(String vendorUrl) {
        String string = HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isCancelled(@NotNull List<ExecutionException> exceptions) {
        if (exceptions == null) {
            PyPackageManagementService.$$$reportNull$$$0(18);
        }
        for (ExecutionException e : exceptions) {
            if (!(e instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PyPackageInstallationErrorDescription createDescription(@NotNull ExecutionException e, @Nullable Sdk sdk2, @Nullable String packageName2) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(19);
        }
        if (e instanceof PyExecutionException) {
            PyExecutionException ee = (PyExecutionException)((Object)e);
            String stdout = ee.getStdout();
            String stdoutCause = PyPackageManagementService.findErrorCause(stdout);
            String stderrCause = PyPackageManagementService.findErrorCause(ee.getStderr());
            String cause = stdoutCause != null ? stdoutCause : stderrCause;
            String message = cause != null ? cause : ee.getMessage();
            String command = ee.getCommand() + " " + StringUtil.join(ee.getArgs(), (String)" ");
            return new PyPackageInstallationErrorDescription(message, command, (String)(stdout.isEmpty() ? ee.getStderr() : stdout + "\n" + ee.getStderr()), PyPackageManagementService.findErrorSolution(ee, cause, sdk2), packageName2, sdk2);
        }
        return new PyPackageInstallationErrorDescription(e.getMessage(), null, null, null, packageName2, sdk2);
    }

    @Nullable
    @NlsContexts.DetailedDescription
    private static String findErrorSolution(@NotNull PyExecutionException e, @Nullable String cause, @Nullable Sdk sdk2) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(20);
        }
        if (cause != null && StringUtil.containsIgnoreCase((String)cause, (String)"SyntaxError")) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk2);
            return PySdkBundle.message("python.sdk.use.python.version.supported.by.this.package", new Object[]{languageLevel});
        }
        if (SystemInfo.isLinux && (PyPackageManagementService.containsInOutput(e, "pyconfig.h") || PyPackageManagementService.containsInOutput(e, "Python.h"))) {
            return PySdkBundle.message("python.sdk.check.python.development.packages.installed", new Object[0]);
        }
        if ("pip".equals(e.getCommand()) && sdk2 != null) {
            return PySdkBundle.message("python.sdk.try.to.run.command.from.system.terminal", sdk2.getHomePath());
        }
        return null;
    }

    private static boolean containsInOutput(@NotNull PyExecutionException e, @NotNull String text) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(21);
        }
        if (text == null) {
            PyPackageManagementService.$$$reportNull$$$0(22);
        }
        return StringUtil.containsIgnoreCase((String)e.getStdout(), (String)text) || StringUtil.containsIgnoreCase((String)e.getStderr(), (String)text);
    }

    @Nullable
    private static String findErrorCause(@NotNull String output2) {
        Matcher m;
        if (output2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(23);
        }
        if ((m = PATTERN_ERROR_LINE.matcher(output2)).find()) {
            String result2 = m.group();
            return result2 != null ? result2.trim() : null;
        }
        return null;
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version2, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(24);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(25);
        }
        this.installPackage(new RepoPackage(installedPackage.getName(), null), version2, true, null, listener2, false);
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<? super String, ? super Exception> consumer) {
        if (pkg == null) {
            PyPackageManagementService.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            PyPackageManagementService.$$$reportNull$$$0(27);
        }
        this.myExecutorService.execute(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                PyPIPackageUtil.INSTANCE.loadPackages();
                String version2 = PyPIPackageUtil.INSTANCE.fetchLatestPackageVersion(this.myProject, pkg.getName());
                consumer.consume((Object)StringUtil.notNullize((String)version2));
            }
            catch (IOException e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PyPackageManagementService.$$$reportNull$$$0(28);
        }
        if (version2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(29);
        }
        return PyPackageVersionComparator.getSTR_COMPARATOR().compare(version1, version2);
    }

    @Nullable
    public String getID() {
        return "Python";
    }

    public boolean canManageRepositories() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 13: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlStylePrefix";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPyPIPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallToUserText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackagesList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "composeHref";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installPackage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPackages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDetails";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatPackageInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findErrorSolution";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsInOutput";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findErrorCause";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    public static class PyPackageInstallationErrorDescription
    extends PackageManagementService.ErrorDescription {
        @Nullable
        private final String myPackageName;
        @Nullable
        private final String myPythonVersion;
        @Nullable
        private final String myInterpreterPath;
        @Nullable
        private final Sdk mySdk;

        public PyPackageInstallationErrorDescription(@NotNull @NlsContexts.DetailedDescription String message, @Nullable String command, @Nullable String output2, @Nullable @NlsContexts.DetailedDescription String solution, @Nullable String packageName2, @Nullable Sdk sdk2) {
            if (message == null) {
                PyPackageInstallationErrorDescription.$$$reportNull$$$0(0);
            }
            super(message, command, output2, solution);
            this.myPackageName = packageName2;
            this.mySdk = sdk2;
            this.myPythonVersion = sdk2 != null ? sdk2.getVersionString() : null;
            this.myInterpreterPath = sdk2 != null ? sdk2.getHomePath() : null;
        }

        @Nullable
        public static PyPackageInstallationErrorDescription createFromMessage(@Nullable @NlsContexts.DetailedDescription String message) {
            return message != null ? new PyPackageInstallationErrorDescription(message, null, null, null, null, null) : null;
        }

        @Nullable
        @NlsSafe
        public String getPackageName() {
            return this.myPackageName;
        }

        @Nullable
        @NlsSafe
        public String getPythonVersion() {
            return this.myPythonVersion;
        }

        @Nullable
        @NlsSafe
        public String getInterpreterPath() {
            return this.myInterpreterPath;
        }

        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/ui/PyPackageManagementService$PyPackageInstallationErrorDescription", "<init>"));
        }
    }
}

