/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.ArrayFactory;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.impl.PyDeprecationUtilKt;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyCompoundStatement;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDeprecatable;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypeParameterListOwner;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PyFunction
extends PyAstFunction,
StubBasedPsiElement<PyFunctionStub>,
PsiNameIdentifierOwner,
PyCompoundStatement,
PyDecoratable,
PyCallable,
PyStatementListContainer,
PyPossibleClassMember,
ScopeOwner,
PyDocStringOwner,
PyTypeCommentOwner,
PyAnnotationOwner,
PyTypeParameterListOwner,
PyDeprecatable {
    public static final PyFunction[] EMPTY_ARRAY = new PyFunction[0];
    public static final ArrayFactory<PyFunction> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PyFunction[count];

    @Nullable
    public PyType getReturnStatementType(@NotNull TypeEvalContext var1);

    public boolean isGenerator();

    @Nullable
    public Property getProperty();

    @NotNull
    public List<PyAssignmentStatement> findAttributes();

    @Override
    @NotNull
    default public PyStatementList getStatementList() {
        PyStatementList pyStatementList = (PyStatementList)PyAstFunction.super.getStatementList();
        if (pyStatementList == null) {
            PyFunction.$$$reportNull$$$0(0);
        }
        return pyStatementList;
    }

    @Override
    @Nullable
    default public PyFunction asMethod() {
        return (PyFunction)PyAstFunction.super.asMethod();
    }

    @Override
    @Nullable
    default public PyStringLiteralExpression getDocStringExpression() {
        return (PyStringLiteralExpression)PyAstFunction.super.getDocStringExpression();
    }

    @Override
    @Nullable
    default public String getDeprecationMessage() {
        return this.extractDeprecationMessage();
    }

    @Nullable
    default public String extractDeprecationMessage() {
        String deprecationMessageFromDecorator = PyDeprecationUtilKt.extractDeprecationMessageFromDecorator(this);
        if (deprecationMessageFromDecorator != null) {
            return deprecationMessageFromDecorator;
        }
        PyStatementList statementList = this.getStatementList();
        return PyFunction.extractDeprecationMessage(Arrays.asList(statementList.getStatements()));
    }

    @Nullable
    public static String extractDeprecationMessage(List<? extends PyAstStatement> statements) {
        for (PyAstStatement pyAstStatement : statements) {
            PyAstReferenceExpression warningClass;
            PyAstCallExpression callExpression;
            PyAstExpressionStatement expressionStatement;
            PyAstExpression pyAstExpression;
            if (!(pyAstStatement instanceof PyAstExpressionStatement) || !((pyAstExpression = (expressionStatement = (PyAstExpressionStatement)pyAstStatement).getExpression()) instanceof PyAstCallExpression) || !(callExpression = (PyAstCallExpression)pyAstExpression).isCalleeText("warn") || (warningClass = callExpression.getArgument(1, PyAstReferenceExpression.class)) == null || !"DeprecationWarning".equals(warningClass.getReferencedName()) && !"PendingDeprecationWarning".equals(warningClass.getReferencedName())) continue;
            return PyPsiUtilsCore.strValue(callExpression.getArguments()[0]);
        }
        return null;
    }

    @Override
    @Nullable
    default public PyClass getContainingClass() {
        return (PyClass)PyAstFunction.super.getContainingClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyFunction", "getStatementList"));
    }
}

