/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedNameFinder {
    @Nullable
    public static String findShortestImportableName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        QualifiedName qName;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(0);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(1);
        }
        return (qName = QualifiedNameFinder.findShortestImportableQName(foothold, vfile)) == null ? null : qName.toString();
    }

    @Nullable
    public static QualifiedName findCachedShortestImportableName(@NotNull PsiElement foothold, @NotNull VirtualFile virtualFile) {
        List<QualifiedName> names2;
        PythonPathCache cache;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(3);
        }
        if ((cache = ResolveImportUtil.getPathCache(foothold)) != null && (names2 = cache.getNames(virtualFile)) != null) {
            return QualifiedNameFinder.shortestQName(names2);
        }
        return null;
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@Nullable PsiFileSystemItem fsItem) {
        VirtualFile vFile = fsItem != null ? fsItem.getVirtualFile() : null;
        return vFile != null ? QualifiedNameFinder.findShortestImportableQName((PsiElement)fsItem, vFile) : null;
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(4);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(5);
        }
        return QualifiedNameFinder.shortestQName(QualifiedNameFinder.findImportableQNames(foothold, vfile));
    }

    @NotNull
    public static List<QualifiedName> findImportableQNames(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List<QualifiedName> names2;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(6);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(7);
        }
        List<QualifiedName> list = names2 = (cache = ResolveImportUtil.getPathCache(foothold)) != null ? cache.getNames(vfile) : null;
        if (names2 != null) {
            List<QualifiedName> list2 = names2;
            if (list2 == null) {
                QualifiedNameFinder.$$$reportNull$$$0(8);
            }
            return list2;
        }
        PathChoosingVisitor visitor2 = new PathChoosingVisitor(vfile);
        RootVisitorHost.visitRoots(foothold, visitor2);
        List<QualifiedName> results = visitor2.getResults();
        if (cache != null) {
            cache.putNames(vfile, results);
        }
        List<QualifiedName> list3 = results;
        if (list3 == null) {
            QualifiedNameFinder.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @Nullable
    private static QualifiedName shortestQName(@NotNull List<QualifiedName> qNames2) {
        if (qNames2 == null) {
            QualifiedNameFinder.$$$reportNull$$$0(10);
        }
        return qNames2.stream().min(Comparator.comparingInt(QualifiedName::getComponentCount)).orElse(null);
    }

    @Nullable
    public static String findShortestImportableName(Module module, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List<QualifiedName> names2;
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(11);
        }
        if ((names2 = (cache = PythonModulePathCache.getInstance(module)).getNames(vfile)) == null) {
            PathChoosingVisitor visitor2 = new PathChoosingVisitor(vfile);
            RootVisitorHost.visitRoots(module, false, visitor2);
            names2 = visitor2.getResults();
            cache.putNames(vfile, names2);
        }
        return Objects.toString(QualifiedNameFinder.shortestQName(names2), null);
    }

    @Nullable
    public static QualifiedName findCanonicalImportPath(@NotNull PsiElement symbol, @Nullable PsiElement foothold) {
        if (symbol == null) {
            QualifiedNameFinder.$$$reportNull$$$0(12);
        }
        return (QualifiedName)PyUtil.getNullableParameterizedCachedValue(symbol, Couple.of((Object)symbol, (Object)foothold), QualifiedNameFinder::doFindCanonicalImportPath);
    }

    @Nullable
    private static QualifiedName doFindCanonicalImportPath(@NotNull Couple<PsiElement> param) {
        QualifiedName restored;
        QualifiedName qname;
        if (param == null) {
            QualifiedNameFinder.$$$reportNull$$$0(13);
        }
        PsiElement symbol = (PsiElement)param.getFirst();
        PsiElement foothold = (PsiElement)param.getSecond();
        PsiFileSystemItem srcfile = PyPsiUtils.getFileSystemItem(symbol);
        if (srcfile == null) {
            return null;
        }
        VirtualFile virtualFile = srcfile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (srcfile instanceof PsiFile && symbol instanceof PsiNamedElement && !(symbol instanceof PsiFileSystemItem)) {
            PyFile initPy;
            PyClass containingClass;
            PsiElement toplevel = symbol;
            if (symbol instanceof PyFunction && (containingClass = ((PyFunction)symbol).getContainingClass()) != null) {
                toplevel = containingClass;
            }
            for (PsiDirectory dir = ((PsiFile)srcfile).getContainingDirectory(); dir != null && (initPy = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)dir), PyFile.class)) != null; dir = dir.getParentDirectory()) {
                if (initPy.getImportTargets().isEmpty() && initPy.getFromImports().isEmpty()) {
                    initPy = QualifiedNameFinder.jumpFromBinarySkeletonsToRealInitPy(initPy);
                }
                List<RatedResolveResult> resolved = initPy.multiResolveName(((PsiNamedElement)toplevel).getName());
                PsiElement finalTopLevel = toplevel;
                if (!resolved.stream().anyMatch(r -> r.getElement() == finalTopLevel)) continue;
                virtualFile = dir.getVirtualFile();
            }
        }
        if ((qname = QualifiedNameFinder.findShortestImportableQName(foothold != null ? foothold : symbol, virtualFile)) != null && (restored = QualifiedNameFinder.canonizeQualifiedName(symbol, qname, foothold)) != null) {
            return restored;
        }
        return qname;
    }

    @NotNull
    private static PyFile jumpFromBinarySkeletonsToRealInitPy(@NotNull PyFile initPy) {
        PyFile libInitPy;
        List<PsiElement> namesakeResults;
        PsiElement nonSkeletonResult;
        PsiDirectory libPackage;
        QualifiedName packageName2;
        if (initPy == null) {
            QualifiedNameFinder.$$$reportNull$$$0(14);
        }
        if (PythonSdkUtil.isElementInSkeletons((PsiElement)initPy) && (packageName2 = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)initPy)) != null && (libPackage = PyUtil.as(nonSkeletonResult = (PsiElement)ContainerUtil.find(namesakeResults = PyResolveImportUtil.resolveQualifiedName(packageName2, PyResolveImportUtil.fromFoothold((PsiElement)initPy)), e -> !PythonSdkUtil.isElementInSkeletons(e)), PsiDirectory.class)) != null && (libInitPy = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)libPackage), PyFile.class)) != null && libInitPy != initPy) {
            PyFile pyFile = libInitPy;
            if (pyFile == null) {
                QualifiedNameFinder.$$$reportNull$$$0(15);
            }
            return pyFile;
        }
        PyFile pyFile = initPy;
        if (pyFile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(16);
        }
        return pyFile;
    }

    @Nullable
    public static QualifiedName canonizeQualifiedName(PsiElement symbol, QualifiedName qname, PsiElement foothold) {
        for (PyCanonicalPathProvider provider : PyCanonicalPathProvider.EP_NAME.getExtensionList()) {
            QualifiedName restored = provider.getCanonicalPath(symbol, qname, foothold);
            if (restored == null) continue;
            return restored;
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PyElement element) {
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(17);
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)element, () -> new CachedValueProvider.Result((Object)QualifiedNameFinder.getQualifiedNameInner(element), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static String getQualifiedNameInner(@NotNull PyElement element) {
        String name2;
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(18);
        }
        if ((name2 = element.getName()) != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)element);
            if (owner instanceof PyClass) {
                String classQName = ((PyClass)owner).getQualifiedName();
                if (classQName != null) {
                    return classQName + "." + name2;
                }
            } else if (owner instanceof PyFile) {
                String fileQName;
                if (builtinCache.isBuiltin((PsiElement)element)) {
                    return name2;
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findShortestImportableName((PsiElement)element, virtualFile)) != null) {
                    return fileQName + "." + name2;
                }
            }
        }
        return null;
    }

    @Nullable
    private static QualifiedName computeQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull VirtualFile file) {
        String relativePath;
        if (root == null) {
            QualifiedNameFinder.$$$reportNull$$$0(19);
        }
        if (file == null) {
            QualifiedNameFinder.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmpty((String)(relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')))) {
            return null;
        }
        ArrayList<String> components = new ArrayList<String>(StringUtil.split((String)relativePath, (String)"/"));
        if (components.isEmpty()) {
            return null;
        }
        int lastIndex = components.size() - 1;
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)((String)components.get(lastIndex)));
        if (!file.isDirectory() && nameWithoutExtension.equals("__init__")) {
            components.remove(lastIndex);
        } else {
            components.set(lastIndex, nameWithoutExtension);
        }
        if (components.isEmpty() || ContainerUtil.exists(components, part -> part.contains("."))) {
            return null;
        }
        return PyStubPackages.convertStubToRuntimePackageName(QualifiedName.fromComponents(components));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initPy";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportableQNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpFromBinarySkeletonsToRealInitPy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCachedShortestImportableName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableQName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findImportableQNames";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shortestQName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCanonicalImportPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doFindCanonicalImportPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "jumpFromBinarySkeletonsToRealInitPy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameInner";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeQualifiedNameInRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static final class PathChoosingVisitor
    implements RootVisitor {
        @NotNull
        private final VirtualFile myVFile;
        @NotNull
        private final Set<QualifiedName> myResults;

        private PathChoosingVisitor(@NotNull VirtualFile file) {
            if (file == null) {
                PathChoosingVisitor.$$$reportNull$$$0(0);
            }
            this.myResults = new LinkedHashSet<QualifiedName>();
            this.myVFile = file;
        }

        @Override
        public boolean visitRoot(@NotNull VirtualFile root, @Nullable Module module, @Nullable Sdk sdk2, boolean isModuleSource) {
            QualifiedName qName;
            if (root == null) {
                PathChoosingVisitor.$$$reportNull$$$0(1);
            }
            if ((qName = QualifiedNameFinder.computeQualifiedNameInRoot(root, this.myVFile)) != null && ContainerUtil.all((Collection)qName.getComponents(), PyNames::isIdentifier)) {
                this.myResults.add(qName);
            }
            return true;
        }

        @NotNull
        public List<QualifiedName> getResults() {
            return new ArrayList<QualifiedName>(this.myResults);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder$PathChoosingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static abstract class QualifiedNameBasedScope
    extends GlobalSearchScope {
        private final ProjectFileIndex myProjectFileIndex;

        public QualifiedNameBasedScope(@NotNull Project project2) {
            if (project2 == null) {
                QualifiedNameBasedScope.$$$reportNull$$$0(0);
            }
            super(project2);
            this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                QualifiedNameBasedScope.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        public final boolean contains(@NotNull VirtualFile file) {
            VirtualFile closestRoot;
            if (file == null) {
                QualifiedNameBasedScope.$$$reportNull$$$0(2);
            }
            if ((closestRoot = this.findClosestRoot(file)) == null) {
                return true;
            }
            QualifiedName qName = QualifiedNameFinder.computeQualifiedNameInRoot(closestRoot, file);
            if (qName == null) {
                return true;
            }
            return this.containsQualifiedNameInRoot(closestRoot, qName);
        }

        protected abstract boolean containsQualifiedNameInRoot(@NotNull VirtualFile var1, @NotNull QualifiedName var2);

        @Nullable
        private VirtualFile findClosestRoot(@NotNull VirtualFile vFile) {
            VirtualFile sourceRoot;
            if (vFile == null) {
                QualifiedNameBasedScope.$$$reportNull$$$0(3);
            }
            if ((sourceRoot = this.myProjectFileIndex.getSourceRootForFile(vFile)) != null) {
                return sourceRoot;
            }
            VirtualFile contentRoot = this.myProjectFileIndex.getContentRootForFile(vFile);
            if (contentRoot != null) {
                return contentRoot;
            }
            VirtualFile libraryRoot = this.myProjectFileIndex.getClassRootForFile(vFile);
            if (libraryRoot != null) {
                return libraryRoot;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder$QualifiedNameBasedScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClosestRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

