/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRefactoringUtil {
    private PyRefactoringUtil() {
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            PyRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyRefactoringUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        PyElementVisitor visitor2 = new PyElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                Pair selection;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PyParameter) {
                    return;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    occurrences.add(element);
                    return;
                }
                if (element instanceof PyStringLiteralExpression && (selection = (Pair)pattern.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
                    int start;
                    String substring = ((TextRange)selection.getSecond()).substring(pattern.getText());
                    PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
                    String text = element.getText();
                    if (text != null && expr.getStringNodes().size() == 1 && (start = text.indexOf(substring)) >= 0) {
                        element.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)element, (Object)TextRange.from((int)start, (int)substring.length())));
                        occurrences.add(element);
                        return;
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/PyRefactoringUtil$1", "visitElement"));
            }
        };
        context.acceptChildren((PsiElementVisitor)visitor2);
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            PyRefactoringUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression getSelectedExpression(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent;
        if (project2 == null) {
            PyRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PyRefactoringUtil.$$$reportNull$$$0(4);
        }
        if (element1 == null) {
            PyRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            PyRefactoringUtil.$$$reportNull$$$0(6);
        }
        if ((parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) != null && !(parent instanceof PyElement)) {
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PyElement.class);
        }
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof PyExpression)) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyImportStatement.class, PyFromImportStatement.class}) != null) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)parent) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)parent)) {
            return (PyExpression)parent;
        }
        if (parent instanceof PyBinaryExpression) {
            LanguageLevel langLevel;
            String selection = file.getText().substring(element1.getTextOffset(), element2.getTextOffset() + element2.getTextLength());
            PyElementGenerator generator = PyElementGenerator.getInstance(project2);
            PyExpression expression = generator.createFromText(langLevel = LanguageLevel.forElement(element1), PyAssignmentStatement.class, "z=" + selection).getAssignedValue();
            if (!(expression instanceof PyBinaryExpression) || PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return null;
            }
            String parentText = parent.getText();
            int startOffset = element1.getTextOffset() - parent.getTextOffset() - 1;
            if (startOffset < 0) {
                return null;
            }
            int endOffset = element2.getTextOffset() + element2.getTextLength() - parent.getTextOffset();
            String prefix = parentText.substring(0, startOffset);
            String suffix = parentText.substring(endOffset);
            TextRange textRange = TextRange.from((int)startOffset, (int)(endOffset - startOffset));
            PyExpression fakeExpression = generator.createExpressionFromText(langLevel, prefix + "python" + suffix);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)fakeExpression)) {
                return null;
            }
            expression.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, Pair.create((Object)parent, (Object)textRange));
            return expression;
        }
        return null;
    }

    @Nullable
    public static PsiElement findExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PyRefactoringUtil.$$$reportNull$$$0(7);
        }
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        return PyRefactoringUtil.getSelectedExpression(file.getProject(), file, element1, element2);
    }

    public static PsiElement @NotNull [] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PyRefactoringUtil.$$$reportNull$$$0(8);
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        PsiElement endComment = null;
        boolean startsWithWhitespace = false;
        boolean endsWithWhitespace = false;
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
            startsWithWhitespace = true;
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element2);
            endsWithWhitespace = true;
        }
        while (element2 instanceof PsiComment) {
            endComment = element2;
            element2 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element2);
            endsWithWhitespace = true;
        }
        while (element1 instanceof PsiComment) {
            array.add(element1);
            element1 = PsiTreeUtil.skipWhitespacesForward((PsiElement)element1);
            startsWithWhitespace = true;
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(9);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PyStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PyStatementList) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    PyRefactoringUtil.$$$reportNull$$$0(11);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset() && !startsWithWhitespace) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(12);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && !endsWithWhitespace) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(13);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element1 instanceof PyFunction || element1 instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(14);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element2 instanceof PyFunction || element2 instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(15);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] children2 = parent.getChildren();
        boolean flag = false;
        for (PsiElement child : children2) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        while (endComment instanceof PsiComment) {
            array.add(endComment);
            endComment = PsiTreeUtil.skipWhitespacesForward((PsiElement)endComment);
        }
        for (PsiElement element : array) {
            if (element instanceof PyStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.$$$reportNull$$$0(16);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PyRefactoringUtil.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    public static boolean areConflictingMethods(PyFunction pyFunction, PyFunction pyFunction1) {
        String secondName;
        PyParameter[] firstParams = pyFunction.getParameterList().getParameters();
        PyParameter[] secondParams = pyFunction1.getParameterList().getParameters();
        String firstName = pyFunction.getName();
        return Comparing.strEqual((String)firstName, (String)(secondName = pyFunction1.getName())) && firstParams.length == secondParams.length;
    }

    @NotNull
    public static String selectUniqueNameFromType(@NotNull String typeName, @NotNull PsiElement scopeAnchor) {
        if (typeName == null) {
            PyRefactoringUtil.$$$reportNull$$$0(18);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(19);
        }
        return PyRefactoringUtil.selectUniqueName(typeName, true, scopeAnchor, PyRefactoringUtil::isValidNewName);
    }

    @NotNull
    public static String selectUniqueName(@NotNull String templateName, @NotNull PsiElement scopeAnchor) {
        if (templateName == null) {
            PyRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(21);
        }
        return PyRefactoringUtil.selectUniqueName(templateName, false, scopeAnchor, PyRefactoringUtil::isValidNewName);
    }

    @NotNull
    public static String selectUniqueName(@NotNull String templateName, @NotNull PsiElement scopeAnchor, @NotNull BiPredicate<String, PsiElement> isValid) {
        if (templateName == null) {
            PyRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (isValid == null) {
            PyRefactoringUtil.$$$reportNull$$$0(24);
        }
        return PyRefactoringUtil.selectUniqueName(templateName, false, scopeAnchor, isValid);
    }

    @NotNull
    private static String selectUniqueName(@NotNull String templateName, boolean templateIsType, @NotNull PsiElement scopeAnchor, @NotNull BiPredicate<String, PsiElement> isValid) {
        if (templateName == null) {
            PyRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (isValid == null) {
            PyRefactoringUtil.$$$reportNull$$$0(27);
        }
        Collection<String> suggestions = templateIsType ? NameSuggesterUtil.generateNamesByType(templateName) : NameSuggesterUtil.generateNames(templateName);
        for (String name2 : suggestions) {
            if (!isValid.test(name2, scopeAnchor)) continue;
            String string = name2;
            if (string == null) {
                PyRefactoringUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String shortestName = (String)ContainerUtil.getFirstItem(suggestions);
        return PyRefactoringUtil.appendNumberUntilValid(shortestName, scopeAnchor, isValid);
    }

    @NotNull
    public static String appendNumberUntilValid(@NotNull String name2, @NotNull PsiElement scopeAnchor, @NotNull BiPredicate<String, PsiElement> predicate) {
        if (name2 == null) {
            PyRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (predicate == null) {
            PyRefactoringUtil.$$$reportNull$$$0(31);
        }
        int counter = 1;
        Object candidate = name2;
        while (!predicate.test((String)candidate, scopeAnchor)) {
            candidate = name2 + counter;
            ++counter;
        }
        String string = candidate;
        if (string == null) {
            PyRefactoringUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    public static boolean isValidNewName(@NotNull String name2, @NotNull PsiElement scopeAnchor) {
        if (name2 == null) {
            PyRefactoringUtil.$$$reportNull$$$0(33);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.$$$reportNull$$$0(34);
        }
        return !IntroduceValidator.isDefinedInScope(name2, scopeAnchor) && !PyNames.isReserved(name2);
    }

    @Nullable
    public static <T extends PsiElement> T findSameElementForPreview(@Nullable SmartPsiElementPointer<T> pointer, @NotNull PsiFile previewFile) {
        if (previewFile == null) {
            PyRefactoringUtil.$$$reportNull$$$0(35);
        }
        if (pointer == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        if (element == null) {
            return null;
        }
        return (T)PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)previewFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 10, 11, 12, 13, 14, 15, 16, 17, 28, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeAnchor";
                break;
            }
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isValid";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyRefactoringUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "selectUniqueName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "appendNumberUntilValid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 32: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionInRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsInRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "selectUniqueNameFromType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "selectUniqueName";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendNumberUntilValid";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isValidNewName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findSameElementForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 10, 11, 12, 13, 14, 15, 16, 17, 28, 32 -> new IllegalStateException(string);
        };
    }
}

