/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.NotNullPredicate;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.FieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InstanceFieldsManager
extends FieldsManager {
    private static final FieldsOnly FIELDS_ONLY = new FieldsOnly();

    InstanceFieldsManager() {
        super(false);
    }

    @Override
    public boolean hasConflict(@NotNull PyTargetExpression member, @NotNull PyClass aClass) {
        if (member == null) {
            InstanceFieldsManager.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            InstanceFieldsManager.$$$reportNull$$$0(1);
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, aClass.getInstanceAttributes());
    }

    @Override
    protected Collection<PyElement> moveAssignments(@NotNull PyClass from, @NotNull Collection<PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            InstanceFieldsManager.$$$reportNull$$$0(2);
        }
        if (statements == null) {
            InstanceFieldsManager.$$$reportNull$$$0(3);
        }
        if (to == null) {
            InstanceFieldsManager.$$$reportNull$$$0(4);
        }
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            result2.addAll(InstanceFieldsManager.copyInstanceFields(statements, destClass));
        }
        PyFunction fromInitMethod = PyUtil.getInitMethod(from);
        if (fromInitMethod != null) {
            InstanceFieldsManager.deleteElements(Collections2.filter(statements, (Predicate)new InitsOnly(fromInitMethod)));
        }
        return result2;
    }

    @NotNull
    private static List<PyAssignmentStatement> copyInstanceFields(@NotNull Collection<PyAssignmentStatement> members2, @NotNull PyClass to) {
        PyFunction toInitMethod;
        if (members2 == null) {
            InstanceFieldsManager.$$$reportNull$$$0(5);
        }
        if (to == null) {
            InstanceFieldsManager.$$$reportNull$$$0(6);
        }
        if ((toInitMethod = PyUtil.getInitMethod(to)) == null) {
            toInitMethod = InstanceFieldsManager.createInitMethod(to);
        }
        PyStatementList statementList = toInitMethod.getStatementList();
        List<PyAssignmentStatement> list = PyClassRefactoringUtil.copyFieldDeclarationToStatement(members2, statementList, null);
        if (list == null) {
            InstanceFieldsManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static PyFunction createInitMethod(@NotNull PyClass to) {
        if (to == null) {
            InstanceFieldsManager.$$$reportNull$$$0(8);
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder("__init__", to);
        functionBuilder.parameter("self");
        PyFunction function = functionBuilder.buildFunction();
        PyFunction pyFunction = PyClassRefactoringUtil.addMethods(to, true, function).get(0);
        if (pyFunction == null) {
            InstanceFieldsManager.$$$reportNull$$$0(9);
        }
        return pyFunction;
    }

    @Override
    protected boolean classHasField(@NotNull PyClass pyClass, @NotNull String fieldName) {
        if (pyClass == null) {
            InstanceFieldsManager.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            InstanceFieldsManager.$$$reportNull$$$0(11);
        }
        return pyClass.findInstanceAttribute(fieldName, true) != null;
    }

    @Override
    @NotNull
    protected Collection<PyTargetExpression> getFieldsByClass(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            InstanceFieldsManager.$$$reportNull$$$0(12);
        }
        Collection collection = Collections2.filter(pyClass.getInstanceAttributes(), (Predicate)FIELDS_ONLY);
        if (collection == null) {
            InstanceFieldsManager.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyInstanceFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitMethod";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveAssignments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyInstanceFields";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInitMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "classHasField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 13 -> new IllegalStateException(string);
        };
    }

    private static final class InitsOnly
    extends NotNullPredicate<PyAssignmentStatement> {
        @NotNull
        private final PyFunction myInitMethod;

        private InitsOnly(@NotNull PyFunction initMethod) {
            if (initMethod == null) {
                InitsOnly.$$$reportNull$$$0(0);
            }
            this.myInitMethod = initMethod;
        }

        @Override
        protected boolean applyNotNull(@NotNull PyAssignmentStatement input) {
            PyExpression expression;
            if (input == null) {
                InitsOnly.$$$reportNull$$$0(1);
            }
            if ((expression = input.getLeftHandSideExpression()) == null) {
                return false;
            }
            PyFunction functionWhereDeclared = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)PyUtil.resolveToTheTop((PsiElement)expression), PyFunction.class);
            return this.myInitMethod.equals(functionWhereDeclared);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initMethod";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager$InitsOnly";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FieldsOnly
    extends NotNullPredicate<PyTargetExpression> {
        private FieldsOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyTargetExpression input) {
            if (input == null) {
                FieldsOnly.$$$reportNull$$$0(0);
            }
            return input.getReference().resolve() instanceof PyTargetExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager$FieldsOnly", "applyNotNull"));
        }
    }
}

