/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.ProcessStreamsSynchronizer;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.RunConfigurationTargetEnvironmentAdjuster;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.EnvFilesUtilKt;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PyTargetPathMapper;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCustomProcessHandlerProvider;
import com.jetbrains.python.run.PyDebugProcessHandler;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteTracebackFilter;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonImportErrorFilter;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonProcessHandler;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.run.TargetedPythonPaths;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.run.target.PythonCommandLineTargetEnvironmentProvider;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.CondaPythonExecKt;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonCommandLineState
extends CommandLineState {
    public static final String GROUP_EXE_OPTIONS = "Exe Options";
    public static final String GROUP_DEBUGGER = "Debugger";
    public static final String GROUP_PROFILER = "Profiler";
    public static final String GROUP_COVERAGE = "Coverage";
    public static final String GROUP_MODULE = "Module";
    public static final String GROUP_SCRIPT = "Script";
    public static final String MODULE_PARAMETER = "-m";
    private static final int SERVER_SOCKET_PORT = 0;
    private static final int SERVER_SOCKET_BACKLOG = 0;
    private final AbstractPythonRunConfiguration<?> myConfig;
    private Boolean myMultiprocessDebug = null;
    private boolean myRunWithPty = PtyCommandLine.isEnabled();

    public boolean isDebug() {
        return "PyDebugRunner".equals(this.getEnvironment().getRunner().getRunnerId());
    }

    public static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            throw new ExecutionException(PyBundle.message("runcfg.error.message.failed.to.find.free.socket.port", new Object[0]), (Throwable)e);
        }
        return serverSocket;
    }

    public PythonCommandLineState(AbstractPythonRunConfiguration<?> runConfiguration, ExecutionEnvironment env) {
        super(env);
        this.myConfig = runConfiguration;
    }

    @Nullable
    public PythonSdkFlavor getSdkFlavor() {
        return PythonSdkFlavor.getFlavor(this.myConfig.getInterpreterPath());
    }

    @Nullable
    public Sdk getSdk() {
        return this.myConfig.getSdk();
    }

    public AbstractPythonRunConfiguration<?> getConfig() {
        return this.myConfig;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            PythonCommandLineState.$$$reportNull$$$0(1);
        }
        ExecutionResult executionResult = this.execute(executor, new CommandLinePatcher[0]);
        if (executionResult == null) {
            PythonCommandLineState.$$$reportNull$$$0(2);
        }
        return executionResult;
    }

    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers2) throws ExecutionException {
        return this.execute(executor, this.getDefaultPythonProcessStarter(), patchers2);
    }

    @Nullable
    public ExecutionResult execute(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.$$$reportNull$$$0(3);
        }
        return this.execute(executor, (HelpersAwareTargetEnvironmentRequest targetEnvironmentRequest, PythonExecution pythonScript) -> pythonScript);
    }

    @NotNull
    public final List<String> getConfiguredInterpreterParameters() {
        String interpreterOptions = this.myConfig.getInterpreterOptions();
        if (!StringUtil.isEmptyOrSpaces((String)interpreterOptions)) {
            List list = ParametersListUtil.parse((String)interpreterOptions);
            if (list == null) {
                PythonCommandLineState.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonCommandLineState.$$$reportNull$$$0(5);
        }
        return list;
    }

    public ExecutionResult execute(Executor executor, PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(processStarter, patchers2);
        ConsoleView console = this.createAndAttachConsoleInEDT(this.myConfig.getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler));
    }

    @NotNull
    private ConsoleView createAndAttachConsoleInEDT(@NotNull Project project2, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(6);
        }
        Ref consoleRef = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                consoleRef.set((Object)this.createAndAttachConsole(project2, processHandler, executor));
            }
            catch (ExecutionException | RuntimeException e) {
                consoleRef.set((Object)e);
            }
        });
        if (consoleRef.get() instanceof ExecutionException) {
            throw (ExecutionException)((Object)consoleRef.get());
        }
        if (consoleRef.get() instanceof RuntimeException) {
            throw (RuntimeException)consoleRef.get();
        }
        ConsoleView consoleView = (ConsoleView)consoleRef.get();
        if (consoleView == null) {
            PythonCommandLineState.$$$reportNull$$$0(7);
        }
        return consoleView;
    }

    @Nullable
    public ExecutionResult execute(@NotNull Executor executor, @NotNull PythonScriptTargetedCommandLineBuilder converter) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.$$$reportNull$$$0(8);
        }
        if (converter == null) {
            PythonCommandLineState.$$$reportNull$$$0(9);
        }
        ProcessHandler processHandler = this.startProcess(converter);
        ConsoleView console = this.createAndAttachConsoleInEDT(this.myConfig.getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler));
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project2, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = this.createConsoleBuilder(project2).getConsole();
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
        consoleView.addMessageFilter((Filter)new PythonImportErrorFilter(project2));
        this.addTracebackFilter(project2, consoleView, processHandler);
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(10);
        }
        return consoleView2;
    }

    protected void addTracebackFilter(@NotNull Project project2, @NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(11);
        }
        if (consoleView == null) {
            PythonCommandLineState.$$$reportNull$$$0(12);
        }
        if (processHandler == null) {
            PythonCommandLineState.$$$reportNull$$$0(13);
        }
        if (PythonSdkUtil.isRemote(this.myConfig.getSdk()) && processHandler instanceof ProcessControlWithMappings) {
            consoleView.addMessageFilter((Filter)new PyRemoteTracebackFilter(project2, PythonScriptCommandLineState.getExpandedWorkingDir(this.myConfig), (ProcessControlWithMappings)processHandler));
        } else {
            consoleView.addMessageFilter((Filter)new PythonTracebackFilter(project2, this.myConfig.getWorkingDirectorySafe()));
        }
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
    }

    private TextConsoleBuilder createConsoleBuilder(Project project2) {
        if (this.isDebug()) {
            return new PyDebugConsoleBuilder(project2, PythonSdkUtil.findSdkByPath(this.myConfig.getInterpreterPath()));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project2);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(this.getDefaultPythonProcessStarter(), new CommandLinePatcher[0]);
        if (processHandler == null) {
            PythonCommandLineState.$$$reportNull$$$0(14);
        }
        return processHandler;
    }

    @NotNull
    protected ProcessHandler startProcess(PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        GeneralCommandLine commandLine = this.generateCommandLine(patchers2);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().patchCommandLine((RunConfigurationBase)this.myConfig, this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId());
        ProcessHandler processHandler = processStarter.start(this.myConfig, commandLine);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(15);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler startProcess(@NotNull PythonScriptTargetedCommandLineBuilder builder) throws ExecutionException {
        RunConfigurationTargetEnvironmentAdjuster adjuster;
        if (builder == null) {
            PythonCommandLineState.$$$reportNull$$$0(16);
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        Sdk sdk2 = this.getSdk();
        if (sdk2 != null && (adjuster = RunConfigurationTargetEnvironmentAdjuster.Factory.findTargetEnvironmentRequestAdjuster((Sdk)sdk2)) != null) {
            adjuster.adjust(helpersAwareTargetRequest.getTargetEnvironmentRequest(), this.myConfig);
        }
        PythonExecution pythonScript = this.buildPythonExecutionFinal(helpersAwareTargetRequest, this.getSdk());
        PythonExecution realPythonExecution = builder.build(helpersAwareTargetRequest, pythonScript);
        AbstractPythonRunConfiguration<?> abstractPythonRunConfiguration = this.myConfig;
        if (abstractPythonRunConfiguration instanceof PythonRunConfiguration) {
            PythonRunConfiguration pythonConfig = (PythonRunConfiguration)abstractPythonRunConfiguration;
            String inputFilePath = pythonConfig.getInputFile();
            if (pythonConfig.isRedirectInput() && !StringUtil.isEmptyOrSpaces((String)inputFilePath)) {
                realPythonExecution.withInputFile(new File(inputFilePath));
            }
        }
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        TargetEnvironment targetEnvironment = helpersAwareTargetRequest.getTargetEnvironmentRequest().prepareEnvironment(TargetProgressIndicator.EMPTY);
        List<String> allInterpreterParameters = Streams.concat((Stream[])new Stream[]{this.getConfiguredInterpreterParameters().stream(), realPythonExecution.getAdditionalInterpreterParameters().stream()}).toList();
        TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(realPythonExecution, targetEnvironment, sdk2, allInterpreterParameters, this.myRunWithPty);
        ProcessHandler processHandler = this.doStartProcess(targetEnvironment, targetedCommandLine, (ProgressIndicator)progressIndicator);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(17);
        }
        return processHandler2;
    }

    @NotNull
    private PythonExecution buildPythonExecutionFinal(HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @Nullable Sdk sdk2) {
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonExecution pythonExecution = this.buildPythonExecution(helpersAwareTargetRequest);
        pythonExecution.setWorkingDir(this.getPythonExecutionWorkingDir(targetEnvironmentRequest));
        PythonCommandLineState.initEnvironment(this.myConfig.getProject(), pythonExecution, this.myConfig, this.createRemotePathMapper(), this.isDebug(), helpersAwareTargetRequest, sdk2);
        this.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, pythonExecution.getEnvs(), this.myConfig.isPassParentEnvs());
        PythonScripts.ensureProjectSdkAndModuleDirsAreOnTarget(targetEnvironmentRequest, this.myConfig.getProject(), this.myConfig.getModule());
        PythonExecution pythonExecution2 = pythonExecution;
        if (pythonExecution2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(18);
        }
        return pythonExecution2;
    }

    @Nullable
    protected Function<TargetEnvironment, String> getPythonExecutionWorkingDir(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        String workingDir;
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(19);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(workingDir = this.myConfig.getWorkingDirectorySafe()))) {
            return this.getTargetPath(targetEnvironmentRequest, Path.of(workingDir, new String[0]));
        }
        return null;
    }

    @NotNull
    protected final PythonProcessStarter getDefaultPythonProcessStarter() {
        PythonProcessStarter pythonProcessStarter = (config, commandLine) -> {
            ProcessHandler processHandler;
            Sdk sdk2 = PythonSdkUtil.findSdkByPath(this.myConfig.getInterpreterPath());
            assert (sdk2 != null) : "No SDK For " + this.myConfig.getInterpreterPath();
            SdkAdditionalData additionalData = sdk2.getSdkAdditionalData();
            if (additionalData instanceof PyRemoteSdkAdditionalDataMarker) {
                assert (additionalData instanceof PyRemoteSdkAdditionalData) : "additionalData is remote, but not legacy. Is it a target-based? " + additionalData;
                PyRemotePathMapper pathMapper = this.createRemotePathMapper();
                processHandler = PyRemoteProcessStarter.startLegacyRemoteProcess((PyRemoteSdkAdditionalData)additionalData, commandLine, this.myConfig.getProject(), pathMapper);
            } else {
                processHandler = this.doCreateProcess(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            }
            return processHandler;
        };
        if (pythonProcessStarter == null) {
            PythonCommandLineState.$$$reportNull$$$0(20);
        }
        return pythonProcessStarter;
    }

    @NotNull
    private ProcessHandler doStartProcess(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(21);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(22);
        }
        if (progressIndicator == null) {
            PythonCommandLineState.$$$reportNull$$$0(23);
        }
        Process process2 = targetEnvironment.createProcess(commandLine, progressIndicator);
        String commandLineString = StringUtil.join((String[])new String[]{commandLine.getCommandPresentation(targetEnvironment), " "});
        ProcessHandler processHandler = this.createPtyAwaredProcessHandler(process2, commandLineString, targetEnvironment, commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(24);
        }
        return processHandler2;
    }

    @Nullable
    protected final PyRemotePathMapper createRemotePathMapper() {
        if (this.myConfig.getMappingSettings() == null) {
            return null;
        }
        return PyRemotePathMapper.fromSettings(this.myConfig.getMappingSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    @NotNull
    public final GeneralCommandLine generateCommandLine(CommandLinePatcher @Nullable [] patchers2) {
        return PythonCommandLineState.applyPatchers(this.generateCommandLine(), patchers2);
    }

    @NotNull
    private static GeneralCommandLine applyPatchers(@NotNull GeneralCommandLine commandLine, CommandLinePatcher @Nullable [] patchers2) {
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(25);
        }
        if (patchers2 != null) {
            for (CommandLinePatcher patcher : patchers2) {
                if (patcher == null) continue;
                patcher.patchCommandLine(commandLine);
            }
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(26);
        }
        return generalCommandLine;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine);
    }

    @NotNull
    private ProcessHandler createPtyAwaredProcessHandler(@NotNull Process process2, @NotNull String commandLineString, @NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine) {
        ProcessHandler processHandler;
        if (process2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(27);
        }
        if (commandLineString == null) {
            PythonCommandLineState.$$$reportNull$$$0(28);
        }
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(29);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(30);
        }
        if ((processHandler = this.createProcessHandler(process2, commandLineString, targetEnvironment, commandLine)) instanceof OSProcessHandler) {
            OSProcessHandler osProcessHandler = (OSProcessHandler)processHandler;
            osProcessHandler.setHasPty(this.myRunWithPty);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(31);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull Process process2, @NotNull String commandLineString, @NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine) {
        PathMappingSettings sdkPathMappings;
        if (process2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(32);
        }
        if (commandLineString == null) {
            PythonCommandLineState.$$$reportNull$$$0(33);
        }
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(34);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(35);
        }
        if (targetEnvironment instanceof LocalTargetEnvironment) {
            if (this.isDebug()) {
                return new PyDebugProcessHandler(process2, commandLineString, commandLine.getCharset());
            }
            return new PythonProcessHandler(process2, commandLineString, commandLine.getCharset());
        }
        PathMappingSettings pathMappingSettings = new PathMappingSettings();
        PathMappingSettings runConfigurationPathMappings = this.myConfig.myMappingSettings;
        if (runConfigurationPathMappings != null) {
            pathMappingSettings.addAll(runConfigurationPathMappings);
        }
        if ((sdkPathMappings = this.getSdkPathMappings()) != null) {
            pathMappingSettings.addAll(sdkPathMappings);
        }
        boolean isMostlySilentProcess = false;
        PyTargetPathMapper consolidatedPathMappings = new PyTargetPathMapper(targetEnvironment, pathMappingSettings);
        ProcessHandler processHandler = PyCustomProcessHandlerProvider.createProcessHandler(process2, targetEnvironment, commandLineString, commandLine.getCharset(), consolidatedPathMappings, false, this.myRunWithPty);
        if (processHandler == null) {
            PythonCommandLineState.$$$reportNull$$$0(36);
        }
        return processHandler;
    }

    @Nullable
    private PathMappingSettings getSdkPathMappings() {
        SdkAdditionalData sdkAdditionalData;
        Sdk sdk2 = this.myConfig.getSdk();
        if (sdk2 != null && (sdkAdditionalData = sdk2.getSdkAdditionalData()) instanceof RemoteSdkProperties) {
            return ((RemoteSdkProperties)sdkAdditionalData).getPathMappings();
        }
        return null;
    }

    @NotNull
    public GeneralCommandLine generateCommandLine() {
        SdkAdditionalData data = null;
        if (this.myConfig.getSdk() != null) {
            data = this.myConfig.getSdk().getSdkAdditionalData();
        }
        GeneralCommandLine commandLine = PythonCommandLineState.createPythonCommandLine(this.myConfig.getProject(), data, this.myConfig, this.isDebug(), this.myRunWithPty);
        this.buildCommandLineParameters(commandLine);
        this.customizeEnvironmentVars(commandLine.getEnvironment(), this.myConfig.isPassParentEnvs());
        ProcessStreamsSynchronizer.redirectErrorStreamIfNeeded((GeneralCommandLine)commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(37);
        }
        return generalCommandLine;
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        if (helpersAwareRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(38);
        }
        throw new UnsupportedOperationException("The implementation of Run Configuration based on Targets API is absent");
    }

    @NotNull
    public static GeneralCommandLine createPythonCommandLine(Project project2, @Nullable SdkAdditionalData data, PythonRunParams config, boolean isDebug, boolean runWithPty) {
        GeneralCommandLine commandLine = PythonCommandLineState.generalCommandLine(runWithPty);
        commandLine.withCharset(EncodingProjectManager.getInstance((Project)project2).getDefaultCharset());
        PythonCommandLineState.createStandardGroups(commandLine);
        PythonCommandLineState.initEnvironment(project2, data, commandLine, config, isDebug);
        PythonCommandLineState.setRunnerPath(project2, commandLine, config);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(39);
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine generalCommandLine(boolean runWithPty) {
        return runWithPty ? new PtyCommandLine().withConsoleMode(false) : new GeneralCommandLine();
    }

    public static void createStandardGroups(GeneralCommandLine commandLine) {
        ParametersList params = commandLine.getParametersList();
        params.addParamsGroup(GROUP_EXE_OPTIONS);
        params.addParamsGroup(GROUP_DEBUGGER);
        params.addParamsGroup(GROUP_PROFILER);
        params.addParamsGroup(GROUP_COVERAGE);
        params.addParamsGroup(GROUP_MODULE);
        params.addParamsGroup(GROUP_SCRIPT);
    }

    protected static void initEnvironment(Project project2, SdkAdditionalData data, GeneralCommandLine commandLine, PythonRunParams runParams, boolean isDebug) {
        HashMap env = Maps.newHashMap();
        PythonCommandLineState.setupEncodingEnvs(env, commandLine.getCharset());
        if (runParams.getEnvs() != null) {
            env.putAll(runParams.getEnvs());
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project2, runParams), env, true);
        PythonCommandLineState.setupVirtualEnvVariables(runParams, env, runParams.getSdkHome());
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(env);
        commandLine.withParentEnvironmentType(runParams.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        PythonCommandLineState.buildPythonPath(project2, commandLine, runParams, isDebug);
        for (PythonCommandLineEnvironmentProvider envProvider : PythonCommandLineEnvironmentProvider.EP_NAME.getExtensionList()) {
            envProvider.extendEnvironment(project2, data, commandLine, runParams);
        }
    }

    public static void initEnvironment(@NotNull Project project2, @NotNull PythonExecution commandLine, @NotNull PythonRunParams runParams, @NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @Nullable PyRemotePathMapper pathMapper, @Nullable Sdk sdk2) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(40);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(41);
        }
        if (runParams == null) {
            PythonCommandLineState.$$$reportNull$$$0(42);
        }
        if (helpersAwareTargetRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(43);
        }
        PythonCommandLineState.initEnvironment(project2, commandLine, runParams, pathMapper, false, helpersAwareTargetRequest, sdk2);
    }

    private static void initEnvironment(@NotNull Project project2, @NotNull PythonExecution commandLine, @NotNull PythonRunParams runParams, @Nullable PyRemotePathMapper pathMapper, boolean isDebug, @NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @Nullable Sdk sdk2) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(44);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(45);
        }
        if (runParams == null) {
            PythonCommandLineState.$$$reportNull$$$0(46);
        }
        if (helpersAwareTargetRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(47);
        }
        HashMap env = Maps.newHashMap();
        Map envParameters = EnvFilesUtilKt.configureEnvsFromFiles((EnvFilesOptions)runParams, (boolean)true);
        env.putAll(envParameters);
        if (runParams.getEnvs() != null) {
            env.putAll(runParams.getEnvs());
        }
        boolean addPyCharmHosted = true;
        if (sdk2 != null && !CondaPythonExecKt.getUsePythonForLocalConda()) {
            addPyCharmHosted = PySdkExtKt.getOrCreateAdditionalData(sdk2).getFlavor().providePyCharmHosted();
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project2, runParams), env, addPyCharmHosted);
        PythonCommandLineState.setupVirtualEnvVariables(runParams, env, runParams.getSdkHome());
        Map map = ContainerUtil.map2Map(env.entrySet(), e -> Pair.create((Object)((String)e.getKey()), (Object)TargetEnvironmentFunctions.constant((Object)((String)e.getValue()))));
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonScripts.extendEnvs(commandLine, map, targetEnvironmentRequest.getTargetPlatform());
        PythonCommandLineState.setupEncodingEnvs(commandLine, commandLine.getCharset());
        PythonCommandLineState.buildPythonPath(project2, commandLine, runParams, pathMapper, isDebug, targetEnvironmentRequest);
        for (PythonCommandLineTargetEnvironmentProvider envProvider : PythonCommandLineTargetEnvironmentProvider.EP_NAME.getExtensionList()) {
            envProvider.extendTargetEnvironment(project2, helpersAwareTargetRequest, commandLine, runParams);
        }
    }

    private static void setupVirtualEnvVariables(PythonRunParams myConfig, Map<String, String> env, String sdkHome) {
        Sdk sdk2 = PythonSdkUtil.findSdkByPath(sdkHome);
        if (sdk2 != null && (Registry.is((String)"python.activate.virtualenv.on.run") && PythonSdkUtil.isVirtualEnv(sdkHome) || PythonSdkUtil.isConda(sdk2))) {
            Map<String, String> environment = PySdkUtil.activateVirtualEnv(sdk2);
            env.putAll(environment);
            for (Map.Entry<String, String> e : myConfig.getEnvs().entrySet()) {
                if (!environment.containsKey(e.getKey())) continue;
                if ("PATH".equals(e.getKey())) {
                    env.put(e.getKey(), PythonEnvUtil.addToPathEnvVar(env.get("PATH"), e.getValue(), true));
                    continue;
                }
                env.put(e.getKey(), e.getValue());
            }
        }
    }

    protected static void addCommonEnvironmentVariables(@Nullable String homePath2, Map<String, String> env, boolean addPyCharmHosted) {
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath2 != null) {
            PythonEnvUtil.resetHomePathChanges(homePath2, env);
        }
        if (addPyCharmHosted) {
            env.put("PYCHARM_HOSTED", "1");
        }
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
    }

    protected void customizePythonExecutionEnvironmentVars(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (helpersAwareTargetRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(48);
        }
        if (envs == null) {
            PythonCommandLineState.$$$reportNull$$$0(49);
        }
    }

    private static void setupEncodingEnvs(Map<String, String> envs, Charset charset) {
        PythonEnvUtil.setupEncodingEnvs(envs, charset);
    }

    private static void setupEncodingEnvs(@NotNull PythonExecution pythonExecution, @NotNull Charset charset) {
        if (pythonExecution == null) {
            PythonCommandLineState.$$$reportNull$$$0(50);
        }
        if (charset == null) {
            PythonCommandLineState.$$$reportNull$$$0(51);
        }
        pythonExecution.addEnvironmentVariable("PYTHONIOENCODING", charset.name());
    }

    public static void buildPythonPath(@NotNull Project project2, @NotNull GeneralCommandLine commandLine, @NotNull PythonRunParams config, boolean isDebug) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(52);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(53);
        }
        if (config == null) {
            PythonCommandLineState.$$$reportNull$$$0(54);
        }
        Module module = PythonCommandLineState.getModule(project2, config);
        PythonCommandLineState.buildPythonPath(module, commandLine, config.getSdkHome(), config.isPassParentEnvs(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    public static void buildPythonPath(@NotNull Project project2, @NotNull PythonExecution pythonScript, @NotNull PythonRunParams config, @Nullable PyRemotePathMapper pathMapper, boolean isDebug, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        Sdk sdk2;
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(55);
        }
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(56);
        }
        if (config == null) {
            PythonCommandLineState.$$$reportNull$$$0(57);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(58);
        }
        if ((sdk2 = config.getSdk()) != null) {
            Module module = PythonCommandLineState.getModule(project2, config);
            PythonCommandLineState.buildPythonPath(project2, module, pythonScript, sdk2, pathMapper, config.isPassParentEnvs(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug, targetEnvironmentRequest);
        }
    }

    public static void buildPythonPath(@Nullable Module module, @NotNull GeneralCommandLine commandLine, @Nullable String sdkHome, boolean passParentEnvs, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Sdk pythonSdk;
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(59);
        }
        if ((pythonSdk = PythonSdkUtil.findSdkByPath(sdkHome)) != null) {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.addAll(PythonCommandLineState.getAddedPaths(pythonSdk));
            pathList.addAll(PythonCommandLineState.collectPythonPath(module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug));
            PythonCommandLineState.initPythonPath(commandLine, passParentEnvs, pathList, sdkHome);
        }
    }

    public static void buildPythonPath(@NotNull Project project2, @Nullable Module module, @NotNull PythonExecution pythonScript, @NotNull Sdk pythonSdk, @Nullable PyRemotePathMapper pathMapper, boolean passParentEnvs, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(60);
        }
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(61);
        }
        if (pythonSdk == null) {
            PythonCommandLineState.$$$reportNull$$$0(62);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(63);
        }
        ArrayList<Function<TargetEnvironment, String>> pathList = new ArrayList<Function<TargetEnvironment, String>>();
        SdkAdditionalData data = pythonSdk.getSdkAdditionalData();
        if (data != null) {
            pathList.addAll(TargetedPythonPaths.getAddedPaths(data));
        }
        pathList.addAll(TargetedPythonPaths.collectPythonPath(project2, module, pythonSdk, pathMapper, shouldAddContentRoots, shouldAddSourceRoots, isDebug));
        PythonCommandLineState.initPythonPath(pythonScript, passParentEnvs, pathList, targetEnvironmentRequest);
    }

    @Deprecated
    public static void initPythonPath(@NotNull GeneralCommandLine commandLine, boolean passParentEnvs, @NotNull List<String> pathList, String interpreterPath) {
        PythonSdkFlavor<?> flavor;
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(64);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(65);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(interpreterPath)) != null) {
            flavor.initPythonPath(commandLine, passParentEnvs, pathList);
        } else {
            PythonEnvUtil.initPythonPath(commandLine.getEnvironment(), passParentEnvs, pathList);
        }
    }

    public static void initPythonPath(@NotNull PythonExecution pythonScript, boolean passParentEnvs, @NotNull List<Function<TargetEnvironment, String>> pathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(66);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(67);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(68);
        }
        TargetedPythonPaths.initPythonPath(pythonScript.getEnvs(), passParentEnvs, pathList, targetEnvironmentRequest, true);
    }

    @NotNull
    public static List<String> getAddedPaths(@NotNull Sdk pythonSdk) {
        if (pythonSdk == null) {
            PythonCommandLineState.$$$reportNull$$$0(69);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        SdkAdditionalData sdkAdditionalData = pythonSdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file : addedPaths) {
                PythonCommandLineState.addToPythonPath(file, pathList);
            }
        }
        ArrayList<String> arrayList = pathList;
        if (arrayList == null) {
            PythonCommandLineState.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    private static void addToPythonPath(VirtualFile file, Collection<String> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                PythonCommandLineState.addIfNeeded(realFile, pathList);
            }
        } else if (file.isDirectory()) {
            PythonCommandLineState.addIfNeeded(file, pathList);
        }
    }

    private static void addIfNeeded(@NotNull VirtualFile file, @NotNull Collection<String> pathList) {
        if (file == null) {
            PythonCommandLineState.$$$reportNull$$$0(71);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(72);
        }
        PythonCommandLineState.addIfNeeded(pathList, file.getPath());
    }

    protected static void addIfNeeded(Collection<String> pathList, String path2) {
        String filePath;
        HashSet vals = Sets.newHashSet(pathList);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)path2))) {
            pathList.add(filePath);
        }
    }

    @VisibleForTesting
    public static Collection<String> collectPythonPath(Project project2, PythonRunParams config, boolean isDebug) {
        Module module = PythonCommandLineState.getModule(project2, config);
        return PythonCommandLineState.collectPythonPath(module, config.getSdkHome(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        LinkedHashSet pythonPath = Sets.newLinkedHashSet(PythonCommandLineState.collectPythonPath(module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            pythonPath.add(PythonHelpersLocator.getHelperPath("pycharm"));
            pythonPath.add(PythonHelpersLocator.getHelperPath("pydev"));
        }
        LinkedHashSet linkedHashSet = pythonPath;
        if (linkedHashSet == null) {
            PythonCommandLineState.$$$reportNull$$$0(73);
        }
        return linkedHashSet;
    }

    @Nullable
    private static Module getModule(Project project2, PythonRunParams config) {
        String name2 = config.getModuleName();
        return StringUtil.isEmpty((String)name2) ? null : ModuleManager.getInstance((Project)project2).findModuleByName(name2);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module) {
        return PythonCommandLineState.collectPythonPath(module, true, true);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module, boolean addContentRoots2, boolean addSourceRoots2) {
        LinkedHashSet<String> pythonPathList = new LinkedHashSet<String>();
        if (module != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            if (addContentRoots2) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getContentRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots2) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getSourceRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            PythonCommandLineState.addLibrariesFromModule(module, pythonPathList);
            PythonCommandLineState.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                PythonCommandLineState.addLibrariesFromModule(dependency, pythonPathList);
                PythonCommandLineState.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet<String> linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            PythonCommandLineState.$$$reportNull$$$0(74);
        }
        return linkedHashSet;
    }

    private static void addLibrariesFromModule(Module module, Collection<String> list) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String name2;
            if (!(entry instanceof LibraryOrderEntry) || (name2 = ((LibraryOrderEntry)entry).getLibraryName()) != null && name2.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    PythonCommandLineState.addToPythonPath(root, list);
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                PythonCommandLineState.addToPythonPath(root, list);
            }
        }
    }

    private static void addRootsFromModule(Module module, Collection<String> pythonPathList) {
        Facet[] facets;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path2 = extension.getCompilerOutputPath();
            if (path2 != null) {
                pythonPathList.add(path2.getPath());
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(pathForTests.getPath());
            }
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
            List<String> more_paths;
            if (!(facet instanceof PythonPathContributingFacet) || (more_paths = ((PythonPathContributingFacet)facet).getAdditionalPythonPath()) == null) continue;
            pythonPathList.addAll(more_paths);
        }
    }

    private static void addRoots(Collection<String> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            PythonCommandLineState.addToPythonPath(root, pythonPathList);
        }
    }

    protected static void setRunnerPath(Project project2, GeneralCommandLine commandLine, PythonRunParams config) {
        String interpreterPath = PythonCommandLineState.getInterpreterPath(project2, config);
        if (StringUtil.isNotEmpty((String)interpreterPath)) {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)interpreterPath));
        }
    }

    @Nullable
    public static String getInterpreterPath(Project project2, PythonRunParams config) {
        Module module;
        Sdk sdk2;
        String sdkHome = config.getSdkHome();
        if ((config.isUseModuleSdk() || StringUtil.isEmpty((String)sdkHome)) && (sdk2 = PythonSdkUtil.findPythonSdk(module = PythonCommandLineState.getModule(project2, config))) != null) {
            sdkHome = sdk2.getHomePath();
        }
        return sdkHome;
    }

    protected String getInterpreterPath() throws ExecutionException {
        String interpreterPath = this.myConfig.getInterpreterPath();
        if (interpreterPath == null) {
            throw new ExecutionException(PyBundle.message("runcfg.error.message.cannot.find.python.interpreter", new Object[0]));
        }
        return interpreterPath;
    }

    @NotNull
    private HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter() {
        return PythonCommandLineState.getPythonTargetInterpreter(this.myConfig.getProject(), this.getSdk());
    }

    @NotNull
    public static HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter(@NotNull Project project2, @Nullable Sdk sdk2) {
        if (project2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(75);
        }
        if (sdk2 == null) {
            throw new IllegalStateException("SDK is not defined for Run Configuration");
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = PythonInterpreterTargetEnvironmentFactory.findPythonTargetInterpreter(sdk2, project2);
        if (helpersAwareTargetRequest == null) {
            throw new IllegalStateException("Cannot find execution environment for SDK " + sdk2);
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = helpersAwareTargetRequest;
        if (helpersAwareTargetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(76);
        }
        return helpersAwareTargetEnvironmentRequest;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
    }

    public boolean isMultiprocessDebug() {
        if (this.myMultiprocessDebug != null) {
            return this.myMultiprocessDebug;
        }
        return PyDebuggerOptionsProvider.getInstance(this.myConfig.getProject()).isAttachToSubprocess();
    }

    public void setMultiprocessDebug(boolean multiprocessDebug) {
        this.myMultiprocessDebug = multiprocessDebug;
    }

    public void setRunWithPty(boolean runWithPty) {
        this.myRunWithPty = runWithPty;
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler handler2) {
        return new UrlFilter();
    }

    @NotNull
    protected Function<TargetEnvironment, String> getTargetPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Path scriptPath) {
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(77);
        }
        if (scriptPath == null) {
            PythonCommandLineState.$$$reportNull$$$0(78);
        }
        Function<TargetEnvironment, String> function = PySdkTargetPaths.getTargetPathForPythonScriptExecution(this.myConfig.getProject(), this.myConfig.getSdk(), this.createRemotePathMapper(), scriptPath);
        if (function == null) {
            PythonCommandLineState.$$$reportNull$$$0(79);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 10, 14, 15, 17, 18, 20, 24, 26, 31, 36, 37, 39, 70, 73, 74, 76, 79 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 31: 
            case 36: 
            case 37: 
            case 39: 
            case 70: 
            case 73: 
            case 74: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 6: 
            case 11: 
            case 40: 
            case 44: 
            case 52: 
            case 55: 
            case 60: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 19: 
            case 58: 
            case 63: 
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 21: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 22: 
            case 25: 
            case 30: 
            case 35: 
            case 41: 
            case 45: 
            case 53: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineString";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareRequest";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
            case 43: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 56: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonScript";
                break;
            }
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 65: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredInterpreterParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsoleInEDT";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecutionFinal";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPythonProcessStarter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartProcess";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPatchers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createPtyAwaredProcessHandler";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommandLine";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonCommandLine";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedPaths";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonTargetInterpreter";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 31: 
            case 36: 
            case 37: 
            case 39: 
            case 70: 
            case 73: 
            case 74: 
            case 76: 
            case 79: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsoleInEDT";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTracebackFilter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutionWorkingDir";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doStartProcess";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyPatchers";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createPtyAwaredProcessHandler";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "initEnvironment";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setupEncodingEnvs";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonPath";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getAddedPaths";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getPythonTargetInterpreter";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 10, 14, 15, 17, 18, 20, 24, 26, 31, 36, 37, 39, 70, 73, 74, 76, 79 -> new IllegalStateException(string);
        };
    }

    public static interface PythonProcessStarter {
        @NotNull
        public ProcessHandler start(@NotNull AbstractPythonRunConfiguration<?> var1, @NotNull GeneralCommandLine var2) throws ExecutionException;
    }
}

