/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.traceBackParsers.LinkInTrace;
import com.jetbrains.python.traceBackParsers.TraceBackParser;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonTracebackFilter
implements Filter {
    private final Project myProject;
    private final String myWorkingDirectory;

    public PythonTracebackFilter(Project project2) {
        this.myProject = project2;
        this.myWorkingDirectory = project2.getBasePath();
    }

    public PythonTracebackFilter(Project project2, @Nullable String workingDirectory) {
        this.myProject = project2;
        this.myWorkingDirectory = workingDirectory;
    }

    @Nullable
    public final Filter.Result applyFilter(@NotNull String line2, int entireLength) {
        if (line2 == null) {
            PythonTracebackFilter.$$$reportNull$$$0(0);
        }
        for (TraceBackParser parser : TraceBackParser.PARSERS) {
            String extension;
            LinkInTrace linkInTrace = parser.findLinkInTrace(line2);
            if (linkInTrace == null) continue;
            int lineNumber = linkInTrace.getLineNumber();
            VirtualFile vFile = this.findFileByName(linkInTrace.getFileName());
            if (vFile == null) continue;
            if (!vFile.isDirectory() && (extension = vFile.getExtension()) != null && !extension.equals("py")) {
                return null;
            }
            OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.myProject, vFile, lineNumber - 1);
            int textStartOffset = entireLength - line2.length();
            int startPos = linkInTrace.getStartPos();
            int endPos = linkInTrace.getEndPos();
            return new Filter.Result(startPos + textStartOffset, endPos + textStartOffset, (HyperlinkInfo)hyperlink);
        }
        return null;
    }

    @Nullable
    protected VirtualFile findFileByName(@NotNull String fileName) {
        VirtualFile vFile;
        if (fileName == null) {
            PythonTracebackFilter.$$$reportNull$$$0(1);
        }
        if ((vFile = LocalFileSystem.getInstance().findFileByPath(fileName)) == null && !StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
            vFile = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myWorkingDirectory, fileName));
        }
        return vFile;
    }

    protected Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/run/PythonTracebackFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

