/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.Nullable;

public class IdeaLogRecordFormatter
extends Formatter {
    private static final String FORMAT_WITH_DATE_TIME = "%1$tF %1$tT,%1$tL [%2$7s] %3$6s - %4$s - %5$s%6$s";
    private static final String FORMAT_WITHOUT_DATE_TIME = "[%2$7s] %3$6s - %4$s - %5$s%6$s";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final long myLogCreation;
    private final boolean myWithDateTime;

    public IdeaLogRecordFormatter() {
        this(true);
    }

    public IdeaLogRecordFormatter(boolean withDateTime) {
        this(withDateTime, null);
    }

    public IdeaLogRecordFormatter(boolean withDateTime, @Nullable IdeaLogRecordFormatter copyFrom) {
        this.myWithDateTime = withDateTime;
        this.myLogCreation = copyFrom != null ? copyFrom.getStartedMillis() : System.currentTimeMillis();
    }

    protected long getStartedMillis() {
        return this.myLogCreation;
    }

    @Override
    public String format(LogRecord record) {
        long startedMillis;
        String loggerName = record.getLoggerName();
        if (loggerName != null) {
            loggerName = IdeaLogRecordFormatter.smartAbbreviate(loggerName);
        }
        String relativeToStartedMillis = (startedMillis = this.getStartedMillis()) == 0L ? "-------" : String.valueOf(record.getMillis() - startedMillis);
        String result2 = String.format(this.myWithDateTime ? FORMAT_WITH_DATE_TIME : FORMAT_WITHOUT_DATE_TIME, record.getMillis(), relativeToStartedMillis, LogLevel.getPrettyLevelName(record.getLevel()), loggerName, this.formatMessage(record), LINE_SEPARATOR);
        if (record.getThrown() != null) {
            return result2 + IdeaLogRecordFormatter.formatThrowable(record.getThrown());
        }
        return result2;
    }

    private static String smartAbbreviate(String loggerName) {
        StringBuilder result2 = new StringBuilder();
        int pos = 0;
        if (loggerName.startsWith("#")) {
            result2.append('#');
            ++pos;
        }
        if (!(loggerName.startsWith("com.intellij", pos) || loggerName.startsWith("com.jetbrains", pos) || loggerName.startsWith("org.jetbrains", pos))) {
            return loggerName;
        }
        while (true) {
            int nextDot;
            if ((nextDot = loggerName.indexOf(46, pos)) < 0) {
                result2.append(loggerName.substring(pos));
                return result2.toString();
            }
            result2.append(loggerName.charAt(pos)).append('.');
            pos = nextDot + 1;
        }
    }

    public static String formatThrowable(Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        String[] lines = StringUtil.splitByLines(sw.toString());
        int maxStackSize = 1024;
        int maxExtraSize = 256;
        if (lines.length > maxStackSize + maxExtraSize) {
            String[] res = new String[maxStackSize + maxExtraSize + 1];
            System.arraycopy(lines, 0, res, 0, maxStackSize);
            res[maxStackSize] = "\t...";
            System.arraycopy(lines, lines.length - maxExtraSize, res, maxStackSize + 1, maxExtraSize);
            return StringUtil.join(res, LINE_SEPARATOR);
        }
        return sw.toString();
    }
}

