/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0013H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0018H\u0007J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010 \u001a\u00020\u0018H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R!\u0010\t\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\b\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "()V", "md5", "Ljava/security/MessageDigest;", "getMd5", "()Ljava/security/MessageDigest;", "md5$delegate", "Lkotlin/Lazy;", "random", "Ljava/security/SecureRandom;", "getRandom$annotations", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "sha1", "getSha1", "sha1$delegate", "digestToHash", "", "digest", "randomToken", "sha1Hex", "input", "", "sha256", "sha256Hex", "sha512", "updateContentHash", "", "inputStream", "Ljava/io/InputStream;", "buffer", "file", "Ljava/nio/file/Path;", "intellij.platform.util"})
public final class DigestUtil {
    @NotNull
    public static final DigestUtil INSTANCE = new DigestUtil();
    @NotNull
    private static final Lazy random$delegate = LazyKt.lazy(random.2.INSTANCE);
    @NotNull
    private static final Lazy md5$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)md5.2.INSTANCE);
    @NotNull
    private static final Lazy sha1$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)sha1.2.INSTANCE);

    private DigestUtil() {
    }

    @NotNull
    public static final SecureRandom getRandom() {
        Lazy lazy = random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getRandom$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String randomToken() {
        String string2 = new BigInteger(130, INSTANCE.getRandom()).toString(32);
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return DigestUtilKt.access$cloneDigest(INSTANCE.getMd5());
    }

    private final MessageDigest getMd5() {
        Lazy lazy = md5$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return DigestUtilKt.access$cloneDigest(INSTANCE.getSha1());
    }

    private final MessageDigest getSha1() {
        Lazy lazy = sha1$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return DigestUtilKt.access$cloneDigest(DigestUtilKt.access$getSha2_256());
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha512() {
        return DigestUtilKt.sha2_512();
    }

    @JvmStatic
    @NotNull
    public static final String digestToHash(@NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return DigestUtilKt.bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha256Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter(input, "input");
        byte[] byArray = INSTANCE.sha256().digest(input);
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return DigestUtilKt.bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha1Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return DigestUtilKt.hashToHexString(input, INSTANCE.sha1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file2, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                DigestUtil.updateContentHash(digest, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to read " + file2 + ". " + e2.getMessage(), e2);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, Path path, byte[] byArray, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, path, byArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        try {
            int sz;
            while ((sz = inputStream.read(buffer)) > 0) {
                digest.update(buffer, 0, sz);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to read stream. " + e2.getMessage(), e2);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, InputStream inputStream, byte[] byArray, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, inputStream, byArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(file2, "file");
        DigestUtil.updateContentHash$default(digest, file2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        DigestUtil.updateContentHash$default(digest, inputStream, null, 4, null);
    }
}

