/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.MethodHandleCache;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u001a#\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\b\u001a&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002\u001a$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002\u001aa\u0010\u0016\u001a\u0004\u0018\u00010\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00052\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\u0010\u001d\u001aY\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00052\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010#\u001a\u00020\u00012\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010&\u001a/\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00012\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010)\u001a\u0010\u0010*\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a7\u0010+\u001a\u00020(2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010,\u001a\u00020-2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010.\u001a\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"NA", "", "clearSubscriberCacheOnConnectionTerminated", "", "topicAndHandlerPairs", "", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "([Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageBusImpl;)Z", "deliverImmediately", "", "Lcom/intellij/util/messages/impl/Message;", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "jobs", "Ljava/util/Deque;", "deliverMessage", "", "job", "jobQueue", "Lcom/intellij/util/messages/impl/MessageQueue;", "prevError", "executeOrAddToQueue", "topic", "Lcom/intellij/util/messages/Topic;", "method", "Ljava/lang/reflect/Method;", "args", "handlers", "(Lcom/intellij/util/messages/Topic;Ljava/lang/reflect/Method;[Ljava/lang/Object;[Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageQueue;Ljava/lang/Throwable;Lcom/intellij/util/messages/impl/MessageBusImpl;)Ljava/lang/Throwable;", "invokeListener", "methodHandle", "Ljava/lang/invoke/MethodHandle;", "methodName", "", "handler", "messageDeliveryListener", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;[Ljava/lang/Object;Lcom/intellij/util/messages/Topic;Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageDeliveryListener;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "invokeMethod", "", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/invoke/MethodHandle;)V", "pumpWaiting", "removeDisposedHandlers", "index", "", "([Ljava/lang/Object;ILcom/intellij/util/messages/Topic;Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "throwError", "error", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,719:1\n1#2:720\n37#3,2:721\n1282#4,2:723\n*S KotlinDebug\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImplKt\n*L\n638#1:721,2\n707#1:723,2\n*E\n"})
public final class MessageBusImplKt {
    @NotNull
    private static final Object NA = new Object();

    private static final void pumpWaiting(MessageQueue jobQueue) {
        block5: {
            Throwable error = null;
            Message job = jobQueue.current;
            if (job != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                } else {
                    error = MessageBusImplKt.deliverMessage(job, jobQueue, null);
                }
            }
            while (jobQueue.queue.pollFirst() != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                    continue;
                }
                error = MessageBusImplKt.deliverMessage(job, jobQueue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block5;
            Throwable p0 = throwable;
            boolean bl2 = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Throwable deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        AutoCloseable autoCloseable = ClientId.Companion.withClientId(job.clientId);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl2 = false;
            jobQueue.current = job;
            Object[] handlers2 = job.handlers;
            Throwable error = prevError;
            int index = job.currentHandlerIndex;
            int size = handlers2.length;
            int lastIndex = size - 1;
            while (index < size) {
                if (index == lastIndex) {
                    jobQueue.current = null;
                }
                int n2 = job.currentHandlerIndex;
                job.currentHandlerIndex = n2 + 1;
                Object handler = handlers2[index];
                if (handler != null) {
                    error = MessageBusImplKt.invokeListener(job.method, job.methodName, job.args, job.topic, handler, job.bus.messageDeliveryListener, error);
                }
                if (++index == job.currentHandlerIndex) continue;
                Throwable throwable2 = error;
                return throwable2;
            }
            Throwable throwable3 = error;
            return throwable3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static final Throwable executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, @Nullable Object[] args2, @NotNull Object[] handlers2, @Nullable MessageQueue jobQueue, @Nullable Throwable prevError, @NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(handlers2, "handlers");
        Intrinsics.checkNotNullParameter(bus, "bus");
        MethodHandle methodHandle = MethodHandleCache.compute(method, args2);
        Intrinsics.checkNotNullExpressionValue(methodHandle, "compute(...)");
        MethodHandle methodHandle2 = methodHandle;
        if (jobQueue == null) {
            Throwable error = prevError;
            for (Object handler : handlers2) {
                String string2 = method.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                Object object = handler;
                if (object == null) continue;
                error = MessageBusImplKt.invokeListener(methodHandle2, string2, args2, topic, object, bus.messageDeliveryListener, error);
            }
            return error;
        }
        ArrayDeque<Message> arrayDeque = jobQueue.queue;
        String string3 = method.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        arrayDeque.offerLast(new Message(topic, methodHandle2, string3, args2, handlers2, bus));
        return prevError;
    }

    private static final boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        boolean isChildClearingNeeded = false;
        int i2 = 0;
        while (i2 < topicAndHandlerPairs.length) {
            Topic.BroadcastDirection direction;
            Object object = topicAndHandlerPairs[i2];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.intellij.util.messages.Topic<*>");
            Topic topic = (Topic)object;
            MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i2, topic, bus);
            Intrinsics.checkNotNullExpressionValue(topic.getBroadcastDirection(), "getBroadcastDirection(...)");
            if (direction != Topic.BroadcastDirection.TO_CHILDREN) {
                i2 += 2;
                continue;
            }
            MessageBusImpl parentBus = bus;
            while (true) {
                CompositeMessageBus compositeMessageBus = parentBus.parentBus;
                if (compositeMessageBus == null) {
                    break;
                }
                parentBus = compositeMessageBus;
                MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i2, topic, parentBus);
            }
            if (bus.hasChildren$intellij_platform_core()) {
                isChildClearingNeeded = true;
            }
            i2 += 2;
        }
        return isChildClearingNeeded;
    }

    private static final void removeDisposedHandlers(Object[] topicAndHandlerPairs, int index, Topic<?> topic, MessageBusImpl bus) {
        Object[] objectArray = (Object[])bus.subscriberCache.remove(topic);
        if (objectArray == null) {
            return;
        }
        Object[] cachedHandlers = objectArray;
        Object handler = topicAndHandlerPairs[index + 1];
        if (topic.isImmediateDelivery()) {
            int length = cachedHandlers.length;
            for (int i2 = 0; i2 < length; ++i2) {
                if (cachedHandlers[i2] != handler) continue;
                cachedHandlers[i2] = null;
            }
        }
        bus.rootBus.removeDisposedHandlers(topic, handler);
    }

    private static final List<Message> deliverImmediately(MessageBusConnectionImpl connection, Deque<Message> jobs) {
        List newJobs = null;
        Iterator<Message> iterator2 = jobs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Message> jobIterator = iterator2;
        while (jobIterator.hasNext()) {
            Message job = jobIterator.next();
            List handlers2 = null;
            Object[] allHandlers = job.handlers;
            int length = allHandlers.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Object handler = allHandlers[i2];
                if (handler == null || connection.bus != job.bus || !connection.isMyHandler(job.topic, handler)) continue;
                allHandlers[i2] = null;
                if (handlers2 == null) {
                    handlers2 = new ArrayList();
                }
                handlers2.add(handler);
            }
            if (handlers2 == null) continue;
            if (allHandlers.length == handlers2.size()) {
                jobIterator.remove();
            }
            Collection $this$toTypedArray$iv = handlers2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Message filteredJob = new Message(job.topic, job.method, job.methodName, job.args, thisCollection$iv.toArray(new Object[0]), job.bus);
            if (newJobs == null) {
                newJobs = new ArrayList();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    private static final Throwable invokeListener(MethodHandle methodHandle, String methodName, Object[] args2, Topic<?> topic, Object handler, MessageDeliveryListener messageDeliveryListener, Throwable prevError) {
        try {
            if (handler instanceof MessageHandler) {
                MessageHandler messageHandler = (MessageHandler)handler;
                Object[] objectArray = args2;
                if (args2 == null) {
                    objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray2 = objectArray;
                messageHandler.handle(methodHandle, Arrays.copyOf(objectArray2, objectArray2.length));
            } else if (messageDeliveryListener == null) {
                MessageBusImplKt.invokeMethod(handler, args2, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImplKt.invokeMethod(handler, args2, methodHandle);
                messageDeliveryListener.messageDelivered(topic, methodName, handler, System.nanoTime() - startTime);
            }
        }
        catch (AbstractMethodError startTime) {
        }
        catch (Throwable e2) {
            Throwable error;
            Throwable throwable = error = e2 instanceof ProcessCanceledException || e2 instanceof AssertionError || e2 instanceof CancellationException ? e2 : (Throwable)new RuntimeException("Cannot invoke (class=" + handler.getClass().getSimpleName() + ", method=" + methodName + ", topic=" + topic.getDisplayName() + ')', e2);
            if (prevError == null) {
                return error;
            }
            ExceptionsKt.addSuppressed(prevError, error);
            return prevError;
        }
        return prevError;
    }

    private static final void invokeMethod(Object handler, Object[] args2, MethodHandle methodHandle) {
        if (args2 == null) {
            methodHandle.invoke(handler);
        } else {
            methodHandle.bindTo(handler).invokeExact(args2);
        }
    }

    public static final void throwError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(error, "error");
        Throwable[] suppressed = error.getSuppressed();
        if (suppressed.length > 1) {
            Throwable throwable;
            block3: {
                Throwable throwable2;
                Intrinsics.checkNotNull(suppressed);
                Throwable[] $this$firstOrNull$iv = suppressed;
                boolean $i$f$firstOrNull = false;
                int n2 = $this$firstOrNull$iv.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Throwable element$iv;
                    Throwable it = element$iv = $this$firstOrNull$iv[i2];
                    boolean bl2 = false;
                    if (!(it instanceof ProcessCanceledException || it instanceof CancellationException)) continue;
                    throwable2 = element$iv;
                    break block3;
                }
                throwable2 = throwable = null;
            }
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl3 = false;
                throw it;
            }
        }
        throw error;
    }

    public static final /* synthetic */ boolean access$clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        return MessageBusImplKt.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, bus);
    }

    public static final /* synthetic */ List access$deliverImmediately(MessageBusConnectionImpl connection, Deque jobs) {
        return MessageBusImplKt.deliverImmediately(connection, jobs);
    }

    public static final /* synthetic */ Throwable access$deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        return MessageBusImplKt.deliverMessage(job, jobQueue, prevError);
    }

    public static final /* synthetic */ Object access$getNA$p() {
        return NA;
    }

    public static final /* synthetic */ void access$pumpWaiting(MessageQueue jobQueue) {
        MessageBusImplKt.pumpWaiting(jobQueue);
    }
}

