/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import kotlinx.coroutines.repackaged.net.bytebuddy.ByteBuddy;
import kotlinx.coroutines.repackaged.net.bytebuddy.asm.MemberRemoval;
import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.modifier.Visibility;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.PackageDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.DynamicType;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.scaffold.TypeValidation;
import kotlinx.coroutines.repackaged.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.FixedValue;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.MethodCall;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.ElementMatchers;
import kotlinx.coroutines.repackaged.net.bytebuddy.utility.JavaModule;
import kotlinx.coroutines.repackaged.net.bytebuddy.utility.JavaType;
import kotlinx.coroutines.repackaged.net.bytebuddy.utility.RandomString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ClassInjector {
    public static final Permission SUPPRESS_ACCESS_CHECKS = new ReflectPermission("suppressAccessChecks");
    public static final boolean ALLOW_EXISTING_TYPES = false;

    public boolean isAlive();

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public Map<String, Class<?>> injectRaw(Map<? extends String, byte[]> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingInstrumentation
    extends AbstractBase {
        private static final String JAR = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        protected UsingInstrumentation(File folder, Target target, Instrumentation instrumentation, RandomString randomString) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = randomString;
        }

        public static ClassInjector of(File folder, Target target, Instrumentation instrumentation) {
            return new UsingInstrumentation(folder, target, instrumentation, new RandomString());
        }

        @Override
        public boolean isAlive() {
            return UsingInstrumentation.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Class<?>> injectRaw(Map<? extends String, byte[]> types) {
            File file2 = new File(this.folder, JAR + this.randomString.nextString() + "." + JAR);
            if (!file2.createNewFile()) {
                throw new IllegalStateException("Cannot create file " + file2);
            }
            try {
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
                try {
                    for (Map.Entry<? extends String, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().replace('.', '/') + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                JarFile jarFile = new JarFile(file2, false);
                try {
                    this.target.inject(this.instrumentation, jarFile);
                }
                finally {
                    jarFile.close();
                }
                HashMap result2 = new HashMap();
                for (String string2 : types.keySet()) {
                    result2.put(string2, Class.forName(string2, false, this.target.getClassLoader()));
                }
                HashMap<String, Class<?>> hashMap = result2;
                if (!file2.delete()) {
                    file2.deleteOnExit();
                }
                return hashMap;
            }
            catch (Throwable throwable) {
                try {
                    if (!file2.delete()) {
                        file2.deleteOnExit();
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Cannot write jar file to disk", exception);
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Cannot load injected class", exception);
                }
            }
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAlive();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.target.equals((Object)((UsingInstrumentation)object).target)) {
                return false;
            }
            if (!this.instrumentation.equals(((UsingInstrumentation)object).instrumentation)) {
                return false;
            }
            if (!this.folder.equals(((UsingInstrumentation)object).folder)) {
                return false;
            }
            return this.randomString.equals(((UsingInstrumentation)object).randomString);
        }

        public int hashCode() {
            return (((17 * 31 + this.instrumentation.hashCode()) * 31 + this.target.hashCode()) * 31 + this.folder.hashCode()) * 31 + this.randomString.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Target {
            BOOTSTRAP(null){

                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    DISPATCHER.appendToBootstrapClassLoaderSearch(instrumentation, jarFile);
                }
            }
            ,
            SYSTEM(ClassLoader.getSystemClassLoader()){

                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    DISPATCHER.appendToSystemClassLoaderSearch(instrumentation, jarFile);
                }
            };

            private final ClassLoader classLoader;

            private Target(ClassLoader classLoader) {
                this.classLoader = classLoader;
            }

            protected ClassLoader getClassLoader() {
                return this.classLoader;
            }

            protected abstract void inject(Instrumentation var1, JarFile var2);
        }

        protected static interface Dispatcher {
            public boolean isAlive();

            public void appendToBootstrapClassLoaderSearch(Instrumentation var1, JarFile var2);

            public void appendToSystemClassLoaderSearch(Instrumentation var1, JarFile var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava6CapableVm
            implements Dispatcher {
                private final Method appendToBootstrapClassLoaderSearch;
                private final Method appendToSystemClassLoaderSearch;

                protected ForJava6CapableVm(Method appendToBootstrapClassLoaderSearch, Method appendToSystemClassLoaderSearch) {
                    this.appendToBootstrapClassLoaderSearch = appendToBootstrapClassLoaderSearch;
                    this.appendToSystemClassLoaderSearch = appendToSystemClassLoaderSearch;
                }

                public boolean isAlive() {
                    return true;
                }

                public void appendToBootstrapClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
                    try {
                        this.appendToBootstrapClassLoaderSearch.invoke((Object)instrumentation, jarFile);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#appendToBootstrapClassLoaderSearch", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#appendToBootstrapClassLoaderSearch", exception.getCause());
                    }
                }

                public void appendToSystemClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
                    try {
                        this.appendToSystemClassLoaderSearch.invoke((Object)instrumentation, jarFile);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#appendToSystemClassLoaderSearch", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#appendToSystemClassLoaderSearch", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.appendToBootstrapClassLoaderSearch.equals(((ForJava6CapableVm)object).appendToBootstrapClassLoaderSearch)) {
                        return false;
                    }
                    return this.appendToSystemClassLoaderSearch.equals(((ForJava6CapableVm)object).appendToSystemClassLoaderSearch);
                }

                public int hashCode() {
                    return (17 * 31 + this.appendToBootstrapClassLoaderSearch.hashCode()) * 31 + this.appendToSystemClassLoaderSearch.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public boolean isAlive() {
                    return false;
                }

                @Override
                public void appendToBootstrapClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
                    throw new UnsupportedOperationException("The current JVM does not support appending to the bootstrap loader");
                }

                @Override
                public void appendToSystemClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
                    throw new UnsupportedOperationException("The current JVM does not support appending to the system class loader");
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                public Dispatcher run() {
                    try {
                        Class<?> instrumentation = Class.forName("java.lang.instrument.Instrumentation");
                        return new ForJava6CapableVm(instrumentation.getMethod("appendToBootstrapClassLoaderSearch", JarFile.class), instrumentation.getMethod("appendToSystemClassLoaderSearch", JarFile.class));
                    }
                    catch (ClassNotFoundException ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                    catch (NoSuchMethodException ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingUnsafe
    extends AbstractBase {
        public static final String SAFE_PROPERTY = "kotlinx.coroutines.repackaged.net.bytebuddy.safe";
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private static final Object BOOTSTRAP_LOADER_LOCK = new Object();
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ClassLoader classLoader;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;
        private final Dispatcher.Initializable dispatcher;

        public UsingUnsafe(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingUnsafe(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this(classLoader, protectionDomain, DISPATCHER);
        }

        protected UsingUnsafe(ClassLoader classLoader, ProtectionDomain protectionDomain, Dispatcher.Initializable dispatcher) {
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.dispatcher = dispatcher;
        }

        @Override
        public boolean isAlive() {
            return this.dispatcher.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Class<?>> injectRaw(Map<? extends String, byte[]> types) {
            Dispatcher dispatcher = this.dispatcher.initialize();
            HashMap result2 = new HashMap();
            Object object = this.classLoader == null ? BOOTSTRAP_LOADER_LOCK : this.classLoader;
            synchronized (object) {
                for (Map.Entry<? extends String, byte[]> entry : types.entrySet()) {
                    try {
                        result2.put(entry.getKey(), Class.forName(entry.getKey(), false, this.classLoader));
                    }
                    catch (ClassNotFoundException ignored) {
                        result2.put(entry.getKey(), dispatcher.defineClass(this.classLoader, entry.getKey(), entry.getValue(), this.protectionDomain));
                    }
                }
            }
            return result2;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofSystemLoader() {
            return new UsingUnsafe(ClassLoader.getSystemClassLoader());
        }

        public static ClassInjector ofPlatformLoader() {
            return new UsingUnsafe(ClassLoader.getSystemClassLoader().getParent());
        }

        public static ClassInjector ofBootLoader() {
            return new UsingUnsafe(ClassLoadingStrategy.BOOTSTRAP_LOADER);
        }

        public boolean equals(Object object) {
            block18: {
                block17: {
                    Object object2;
                    block16: {
                        Object object3;
                        Object object4;
                        block15: {
                            block14: {
                                ClassLoader classLoader;
                                block13: {
                                    if (this == object) {
                                        return true;
                                    }
                                    if (object == null) {
                                        return false;
                                    }
                                    if (this.getClass() != object.getClass()) {
                                        return false;
                                    }
                                    object4 = ((UsingUnsafe)object).classLoader;
                                    object3 = this.classLoader;
                                    classLoader = object3;
                                    if (object4 == null) break block13;
                                    if (classLoader == null) break block14;
                                    if (!object3.equals(object4)) {
                                        return false;
                                    }
                                    break block15;
                                }
                                if (classLoader == null) break block15;
                            }
                            return false;
                        }
                        object4 = ((UsingUnsafe)object).protectionDomain;
                        object2 = object3 = this.protectionDomain;
                        if (object4 == null) break block16;
                        if (object2 == null) break block17;
                        if (!object3.equals(object4)) {
                            return false;
                        }
                        break block18;
                    }
                    if (object2 == null) break block18;
                }
                return false;
            }
            return this.dispatcher.equals(((UsingUnsafe)object).dispatcher);
        }

        public int hashCode() {
            int n2 = 17 * 31;
            Object object = this.classLoader;
            if (object != null) {
                n2 = n2 + object.hashCode();
            }
            int n3 = n2 * 31;
            object = this.protectionDomain;
            if (object != null) {
                n3 = n3 + object.hashCode();
            }
            return n3 * 31 + this.dispatcher.hashCode();
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Factory {
            private final Dispatcher.Initializable dispatcher;

            public Factory() {
                this(AccessResolver.Default.INSTANCE);
            }

            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception is captured to trigger lazy error upon use.")
            public Factory(AccessResolver accessResolver) {
                Dispatcher.Initializable dispatcher;
                if (DISPATCHER.isAvailable()) {
                    dispatcher = DISPATCHER;
                } else {
                    try {
                        Class<?> unsafeType = Class.forName("jdk.internal.misc.Unsafe");
                        Field theUnsafe = unsafeType.getDeclaredField("theUnsafe");
                        accessResolver.apply(theUnsafe);
                        Object unsafe = theUnsafe.get(null);
                        Method defineClass = unsafeType.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                        accessResolver.apply(defineClass);
                        dispatcher = new Dispatcher.Enabled(unsafe, defineClass);
                    }
                    catch (Exception exception) {
                        dispatcher = new Dispatcher.Unavailable(exception.getMessage());
                    }
                }
                this.dispatcher = dispatcher;
            }

            protected Factory(Dispatcher.Initializable dispatcher) {
                this.dispatcher = dispatcher;
            }

            public static Factory resolve(Instrumentation instrumentation) {
                return Factory.resolve(instrumentation, false);
            }

            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception intends to trigger disabled injection strategy.")
            public static Factory resolve(Instrumentation instrumentation, boolean local) {
                if (UsingUnsafe.isAvailable() || !JavaModule.isSupported()) {
                    return new Factory();
                }
                try {
                    Class<?> type2 = Class.forName("jdk.internal.misc.Unsafe");
                    PackageDescription.ForLoadedPackage packageDescription = new PackageDescription.ForLoadedPackage(type2.getPackage());
                    JavaModule source = JavaModule.ofType(type2);
                    JavaModule target = JavaModule.ofType(UsingUnsafe.class);
                    if (source.isOpened(packageDescription, target)) {
                        return new Factory();
                    }
                    if (local) {
                        JavaModule module = JavaModule.ofType(AccessResolver.Default.class);
                        source.modify(instrumentation, Collections.singleton(module), Collections.<String, Set<JavaModule>>emptyMap(), Collections.singletonMap(packageDescription.getName(), Collections.singleton(module)), Collections.<Class<?>>emptySet(), Collections.<Class<?>, List<Class<?>>>emptyMap());
                        return new Factory();
                    }
                    Class resolver = new ByteBuddy().subclass(AccessResolver.class).method(ElementMatchers.named("apply")).intercept(MethodCall.invoke(AccessibleObject.class.getMethod("setAccessible", Boolean.TYPE)).onArgument(0).with(true)).make().load(AccessResolver.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER.with(AccessResolver.class.getProtectionDomain())).getLoaded();
                    JavaModule module = JavaModule.ofType(resolver);
                    source.modify(instrumentation, Collections.singleton(module), Collections.<String, Set<JavaModule>>emptyMap(), Collections.singletonMap(packageDescription.getName(), Collections.singleton(module)), Collections.<Class<?>>emptySet(), Collections.<Class<?>, List<Class<?>>>emptyMap());
                    return new Factory((AccessResolver)resolver.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    return new Factory(new Dispatcher.Unavailable(exception.getMessage()));
                }
            }

            public boolean isAvailable() {
                return this.dispatcher.isAvailable();
            }

            public ClassInjector make(ClassLoader classLoader) {
                return this.make(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
            }

            public ClassInjector make(ClassLoader classLoader, ProtectionDomain protectionDomain) {
                return new UsingUnsafe(classLoader, protectionDomain, this.dispatcher);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.dispatcher.equals(((Factory)object).dispatcher);
            }

            public int hashCode() {
                return 17 * 31 + this.dispatcher.hashCode();
            }

            public static interface AccessResolver {
                public void apply(AccessibleObject var1);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum Default implements AccessResolver
                {
                    INSTANCE;


                    @Override
                    public void apply(AccessibleObject accessibleObject) {
                        accessibleObject.setAccessible(true);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Unavailable
            implements Dispatcher,
            Initializable {
                private final String message;

                protected Unavailable(String message) {
                    this.message = message;
                }

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Dispatcher initialize() {
                    throw new UnsupportedOperationException("Could not access Unsafe class: " + this.message);
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    throw new UnsupportedOperationException("Could not access Unsafe class: " + this.message);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.message.equals(((Unavailable)object).message);
                }

                public int hashCode() {
                    return 17 * 31 + this.message.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Enabled
            implements Dispatcher,
            Initializable {
                private final Object unsafe;
                private final Method defineClass;

                protected Enabled(Object unsafe, Method defineClass) {
                    this.unsafe = unsafe;
                    this.defineClass = defineClass;
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(SUPPRESS_ACCESS_CHECKS);
                        }
                        catch (Exception exception) {
                            return new Unavailable(exception.getMessage());
                        }
                    }
                    return this;
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.unsafe, name, binaryRepresentation, 0, binaryRepresentation.length, classLoader, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access Unsafe::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking Unsafe::defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.unsafe.equals(((Enabled)object).unsafe)) {
                        return false;
                    }
                    return this.defineClass.equals(((Enabled)object).defineClass);
                }

                public int hashCode() {
                    return (17 * 31 + this.unsafe.hashCode()) * 31 + this.defineClass.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    if (Boolean.getBoolean(UsingUnsafe.SAFE_PROPERTY)) {
                        return new Unavailable("Use of Unsafe was disabled by system property");
                    }
                    try {
                        Class<?> unsafeType = Class.forName("sun.misc.Unsafe");
                        Field theUnsafe = unsafeType.getDeclaredField("theUnsafe");
                        theUnsafe.setAccessible(true);
                        Object unsafe = theUnsafe.get(null);
                        try {
                            Method defineClass = unsafeType.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                            defineClass.setAccessible(true);
                            return new Enabled(unsafe, defineClass);
                        }
                        catch (Exception exception) {
                            try {
                                Field override;
                                try {
                                    override = AccessibleObject.class.getDeclaredField("override");
                                }
                                catch (NoSuchFieldException ignored) {
                                    override = new ByteBuddy().redefine(AccessibleObject.class).name("kotlinx.coroutines.repackaged.net.bytebuddy.mirror." + AccessibleObject.class.getSimpleName()).noNestMate().visit(new MemberRemoval().stripInvokables(ElementMatchers.any())).make().load(AccessibleObject.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded().getDeclaredField("override");
                                }
                                long offset = (Long)unsafeType.getMethod("objectFieldOffset", Field.class).invoke(unsafe, override);
                                Method putBoolean = unsafeType.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                                Class<?> internalUnsafe = Class.forName("jdk.internal.misc.Unsafe");
                                Field theUnsafeInternal = internalUnsafe.getDeclaredField("theUnsafe");
                                putBoolean.invoke(unsafe, theUnsafeInternal, offset, true);
                                Method defineClassInternal = internalUnsafe.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                                putBoolean.invoke(unsafe, defineClassInternal, offset, true);
                                return new Enabled(theUnsafeInternal.get(null), defineClassInternal);
                            }
                            catch (Exception ignored) {
                                throw exception;
                            }
                        }
                    }
                    catch (Exception exception) {
                        return new Unavailable(exception.getMessage());
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingLookup
    extends AbstractBase {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.Creator.INSTANCE);
        private static final int PACKAGE_LOOKUP = 8;
        private final Object lookup;

        protected UsingLookup(Object lookup) {
            this.lookup = lookup;
        }

        public static UsingLookup of(Object lookup) {
            if (!DISPATCHER.isAlive()) {
                throw new IllegalStateException("The current VM does not support class definition via method handle lookups");
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.isInstance(lookup)) {
                throw new IllegalArgumentException("Not a method handle lookup: " + lookup);
            }
            if ((DISPATCHER.lookupModes(lookup) & 8) == 0) {
                throw new IllegalArgumentException("Lookup does not imply package-access: " + lookup);
            }
            return new UsingLookup(lookup);
        }

        public Class<?> lookupType() {
            return DISPATCHER.lookupType(this.lookup);
        }

        public UsingLookup in(Class<?> type2) {
            return new UsingLookup(DISPATCHER.resolve(this.lookup, type2));
        }

        @Override
        public boolean isAlive() {
            return UsingLookup.isAvailable();
        }

        @Override
        public Map<String, Class<?>> injectRaw(Map<? extends String, byte[]> types) {
            String expectedPackage = TypeDescription.ForLoadedType.of(this.lookupType()).getPackage().getName();
            HashMap result2 = new HashMap();
            for (Map.Entry<? extends String, byte[]> entry : types.entrySet()) {
                int index = entry.getKey().lastIndexOf(46);
                if (!expectedPackage.equals(index == -1 ? "" : entry.getKey().substring(0, index))) {
                    throw new IllegalArgumentException(entry.getKey() + " must be defined in the same package as " + this.lookup);
                }
                result2.put(entry.getKey(), DISPATCHER.defineClass(this.lookup, entry.getValue()));
            }
            return result2;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAlive();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.lookup.equals(((UsingLookup)object).lookup);
        }

        public int hashCode() {
            return 17 * 31 + this.lookup.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public boolean isAlive();

            public Class<?> lookupType(Object var1);

            public int lookupModes(Object var1);

            public Object resolve(Object var1, Class<?> var2);

            public Class<?> defineClass(Object var1, byte[] var2);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava9CapableVm
            implements Dispatcher {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                private final Method privateLookupIn;
                private final Method lookupClass;
                private final Method lookupModes;
                private final Method defineClass;

                protected ForJava9CapableVm(Method privateLookupIn, Method lookupClass, Method lookupModes, Method defineClass) {
                    this.privateLookupIn = privateLookupIn;
                    this.lookupClass = lookupClass;
                    this.lookupModes = lookupModes;
                    this.defineClass = defineClass;
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    try {
                        return (Class)this.lookupClass.invoke(lookup, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupClass", exception.getCause());
                    }
                }

                @Override
                public int lookupModes(Object lookup) {
                    try {
                        return (Integer)this.lookupModes.invoke(lookup, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupModes", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupModes", exception.getCause());
                    }
                }

                @Override
                public Object resolve(Object lookup, Class<?> type2) {
                    try {
                        return this.privateLookupIn.invoke(null, type2, lookup);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles#privateLookupIn", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles#privateLookupIn", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    try {
                        return (Class)this.defineClass.invoke(lookup, new Object[]{binaryRepresentation});
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.privateLookupIn.equals(((ForJava9CapableVm)object).privateLookupIn)) {
                        return false;
                    }
                    if (!this.lookupClass.equals(((ForJava9CapableVm)object).lookupClass)) {
                        return false;
                    }
                    if (!this.lookupModes.equals(((ForJava9CapableVm)object).lookupModes)) {
                        return false;
                    }
                    return this.defineClass.equals(((ForJava9CapableVm)object).defineClass);
                }

                public int hashCode() {
                    return (((17 * 31 + this.privateLookupIn.hashCode()) * 31 + this.lookupClass.hashCode()) * 31 + this.lookupModes.hashCode()) * 31 + this.defineClass.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public boolean isAlive() {
                    return false;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public int lookupModes(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public Object resolve(Object lookup, Class<?> type2) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles");
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Creator implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> lookup = JavaType.METHOD_HANDLES_LOOKUP.load();
                        return new ForJava9CapableVm(JavaType.METHOD_HANDLES.load().getMethod("privateLookupIn", Class.class, lookup), lookup.getMethod("lookupClass", new Class[0]), lookup.getMethod("lookupModes", new Class[0]), lookup.getMethod("defineClass", byte[].class));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingReflection
    extends AbstractBase {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final ClassLoader classLoader;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;
        private final PackageDefinitionStrategy packageDefinitionStrategy;
        private final boolean forbidExisting;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this(classLoader, protectionDomain, PackageDefinitionStrategy.Trivial.INSTANCE, false);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.forbidExisting = forbidExisting;
        }

        @Override
        public boolean isAlive() {
            return UsingReflection.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Class<?>> injectRaw(Map<? extends String, byte[]> types) {
            Dispatcher dispatcher = DISPATCHER.initialize();
            HashMap result2 = new HashMap();
            for (Map.Entry<? extends String, byte[]> entry : types.entrySet()) {
                Object object = dispatcher.getClassLoadingLock(this.classLoader, entry.getKey());
                synchronized (object) {
                    Class<?> type2 = dispatcher.findClass(this.classLoader, entry.getKey());
                    if (type2 == null) {
                        String packageName;
                        PackageDefinitionStrategy.Definition definition;
                        int packageIndex = entry.getKey().lastIndexOf(46);
                        if (packageIndex != -1 && (definition = this.packageDefinitionStrategy.define(this.classLoader, packageName = entry.getKey().substring(0, packageIndex), entry.getKey())).isDefined()) {
                            Package definedPackage = dispatcher.getPackage(this.classLoader, packageName);
                            if (definedPackage == null) {
                                dispatcher.definePackage(this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                            } else if (!definition.isCompatibleTo(definedPackage)) {
                                throw new SecurityException("Sealing violation for package " + packageName);
                            }
                        }
                        type2 = dispatcher.defineClass(this.classLoader, entry.getKey(), entry.getValue(), this.protectionDomain);
                    } else if (this.forbidExisting) {
                        throw new IllegalStateException("Cannot inject already loaded type: " + type2);
                    }
                    result2.put(entry.getKey(), type2);
                }
            }
            return result2;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofSystemClassLoader() {
            return new UsingReflection(ClassLoader.getSystemClassLoader());
        }

        public boolean equals(Object object) {
            block12: {
                block11: {
                    ProtectionDomain protectionDomain;
                    block10: {
                        ProtectionDomain protectionDomain2;
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.forbidExisting != ((UsingReflection)object).forbidExisting) {
                            return false;
                        }
                        if (!this.classLoader.equals(((UsingReflection)object).classLoader)) {
                            return false;
                        }
                        ProtectionDomain protectionDomain3 = ((UsingReflection)object).protectionDomain;
                        protectionDomain = protectionDomain2 = this.protectionDomain;
                        if (protectionDomain3 == null) break block10;
                        if (protectionDomain == null) break block11;
                        if (!protectionDomain2.equals(protectionDomain3)) {
                            return false;
                        }
                        break block12;
                    }
                    if (protectionDomain == null) break block12;
                }
                return false;
            }
            return this.packageDefinitionStrategy.equals(((UsingReflection)object).packageDefinitionStrategy);
        }

        public int hashCode() {
            int n2 = (17 * 31 + this.classLoader.hashCode()) * 31;
            ProtectionDomain protectionDomain = this.protectionDomain;
            if (protectionDomain != null) {
                n2 = n2 + protectionDomain.hashCode();
            }
            return (n2 * 31 + this.packageDefinitionStrategy.hashCode()) * 31 + this.forbidExisting;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public static final Class<?> UNDEFINED = null;

            public Object getClassLoadingLock(ClassLoader var1, String var2);

            public Class<?> findClass(ClassLoader var1, String var2);

            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            public Package getPackage(ClassLoader var1, String var2);

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Unavailable
            implements Dispatcher {
                private final String message;

                protected Unavailable(String message) {
                    this.message = message;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    return classLoader;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException ignored) {
                        return UNDEFINED;
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    throw new UnsupportedOperationException("Cannot define class using reflection: " + this.message);
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    throw new UnsupportedOperationException("Cannot get package using reflection: " + this.message);
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    throw new UnsupportedOperationException("Cannot define package using injection: " + this.message);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.message.equals(((Unavailable)object).message);
                }

                public int hashCode() {
                    return 17 * 31 + this.message.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class UsingUnsafeOverride
            implements Dispatcher,
            Initializable {
                protected final Method findLoadedClass;
                protected final Method defineClass;
                protected final Method getPackage;
                protected final Method definePackage;

                protected UsingUnsafeOverride(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                protected static Initializable make() throws Exception {
                    Method getPackage;
                    Field override;
                    if (Boolean.getBoolean("kotlinx.coroutines.repackaged.net.bytebuddy.safe")) {
                        return new Initializable.Unavailable("Use of Unsafe was disabled by system property");
                    }
                    Class<?> unsafeType = Class.forName("sun.misc.Unsafe");
                    Field theUnsafe = unsafeType.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    Object unsafe = theUnsafe.get(null);
                    try {
                        override = AccessibleObject.class.getDeclaredField("override");
                    }
                    catch (NoSuchFieldException ignored) {
                        override = new ByteBuddy().redefine(AccessibleObject.class).name("kotlinx.coroutines.repackaged.net.bytebuddy.mirror." + AccessibleObject.class.getSimpleName()).noNestMate().visit(new MemberRemoval().stripInvokables(ElementMatchers.any())).make().load(AccessibleObject.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded().getDeclaredField("override");
                    }
                    long offset = (Long)unsafeType.getMethod("objectFieldOffset", Field.class).invoke(unsafe, override);
                    Method putBoolean = unsafeType.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                    if (JavaModule.isSupported()) {
                        try {
                            getPackage = ClassLoader.class.getMethod("getDefinedPackage", String.class);
                        }
                        catch (NoSuchMethodException ignored) {
                            getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                            putBoolean.invoke(unsafe, getPackage, offset, true);
                        }
                    } else {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                        putBoolean.invoke(unsafe, getPackage, offset, true);
                    }
                    Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                    Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    Method definePackage = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                    putBoolean.invoke(unsafe, defineClass, offset, true);
                    putBoolean.invoke(unsafe, findLoadedClass, offset, true);
                    putBoolean.invoke(unsafe, definePackage, offset, true);
                    try {
                        Method getClassLoadingLock = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
                        putBoolean.invoke(unsafe, getClassLoadingLock, offset, true);
                        return new ForJava7CapableVm(findLoadedClass, defineClass, getPackage, definePackage, getClassLoadingLock);
                    }
                    catch (NoSuchMethodException ignored) {
                        return new ForLegacyVm(findLoadedClass, defineClass, getPackage, definePackage);
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(SUPPRESS_ACCESS_CHECKS);
                        }
                        catch (Exception exception) {
                            return new Unavailable(exception.getMessage());
                        }
                    }
                    return this;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke((Object)classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#definePackage", exception.getCause());
                    }
                }

                protected static class ForLegacyVm
                extends UsingUnsafeOverride {
                    protected ForLegacyVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                    }

                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                protected static class ForJava7CapableVm
                extends UsingUnsafeOverride {
                    private final Method getClassLoadingLock;

                    protected ForJava7CapableVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                        this.getClassLoadingLock = getClassLoadingLock;
                    }

                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        try {
                            return this.getClassLoadingLock.invoke((Object)classLoader, name);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Could not access java.lang.ClassLoader#getClassLoadingLock", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.ClassLoader#getClassLoadingLock", exception.getCause());
                        }
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.getClassLoadingLock.equals(((ForJava7CapableVm)object).getClassLoadingLock);
                    }

                    public int hashCode() {
                        return 17 * 31 + this.getClassLoadingLock.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class UsingUnsafeInjection
            implements Dispatcher,
            Initializable {
                private final Object accessor;
                private final Method findLoadedClass;
                private final Method defineClass;
                private final Method getPackage;
                private final Method definePackage;
                private final Method getClassLoadingLock;

                protected UsingUnsafeInjection(Object accessor, Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                    this.accessor = accessor;
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                    this.getClassLoadingLock = getClassLoadingLock;
                }

                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                protected static Initializable make() throws Exception {
                    Method getPackage;
                    if (Boolean.getBoolean("kotlinx.coroutines.repackaged.net.bytebuddy.safe")) {
                        return new Initializable.Unavailable("Use of Unsafe was disabled by system property");
                    }
                    Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                    Field theUnsafe = unsafe.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    Object unsafeInstance = theUnsafe.get(null);
                    if (JavaModule.isSupported()) {
                        try {
                            getPackage = ClassLoader.class.getDeclaredMethod("getDefinedPackage", String.class);
                        }
                        catch (NoSuchMethodException ignored) {
                            getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                        }
                    } else {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    }
                    getPackage.setAccessible(true);
                    DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with(TypeValidation.DISABLED).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(ClassLoader.class.getName() + "$ByteBuddyAccessor$" + RandomString.make()).defineMethod("findLoadedClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class)).onArgument(0).withArgument(1)).defineMethod("defineClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class)).onArgument(0).withArgument(1, 2, 3, 4, 5)).defineMethod("getPackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(getPackage).onArgument(0).withArgument(1)).defineMethod("definePackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class)).onArgument(0).withArgument(1, 2, 3, 4, 5, 6, 7, 8));
                    try {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class)).onArgument(0).withArgument(1));
                    }
                    catch (NoSuchMethodException ignored) {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(FixedValue.argument(0));
                    }
                    Class type2 = builder.make().load(ClassLoadingStrategy.BOOTSTRAP_LOADER, new ClassLoadingStrategy.ForUnsafeInjection()).getLoaded();
                    return new UsingUnsafeInjection(unsafe.getMethod("allocateInstance", Class.class).invoke(unsafeInstance, type2), type2.getMethod("findLoadedClass", ClassLoader.class, String.class), type2.getMethod("defineClass", ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), type2.getMethod("getPackage", ClassLoader.class, String.class), type2.getMethod("definePackage", ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), type2.getMethod("getClassLoadingLock", ClassLoader.class, String.class));
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(SUPPRESS_ACCESS_CHECKS);
                        }
                        catch (Exception exception) {
                            return new Unavailable(exception.getMessage());
                        }
                    }
                    return this;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    try {
                        return this.getClassLoadingLock.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getClassLoadingLock", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getClassLoadingLock", exception.getCause());
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::findLoadedClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::findLoadedClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.accessor, classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke(this.accessor, classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::definePackage", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.accessor.equals(((UsingUnsafeInjection)object).accessor)) {
                        return false;
                    }
                    if (!this.findLoadedClass.equals(((UsingUnsafeInjection)object).findLoadedClass)) {
                        return false;
                    }
                    if (!this.defineClass.equals(((UsingUnsafeInjection)object).defineClass)) {
                        return false;
                    }
                    if (!this.getPackage.equals(((UsingUnsafeInjection)object).getPackage)) {
                        return false;
                    }
                    if (!this.definePackage.equals(((UsingUnsafeInjection)object).definePackage)) {
                        return false;
                    }
                    return this.getClassLoadingLock.equals(((UsingUnsafeInjection)object).getClassLoadingLock);
                }

                public int hashCode() {
                    return (((((17 * 31 + this.accessor.hashCode()) * 31 + this.findLoadedClass.hashCode()) * 31 + this.defineClass.hashCode()) * 31 + this.getPackage.hashCode()) * 31 + this.definePackage.hashCode()) * 31 + this.getClassLoadingLock.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class Direct
            implements Dispatcher,
            Initializable {
                protected final Method findLoadedClass;
                protected final Method defineClass;
                protected final Method getPackage;
                protected final Method definePackage;

                protected Direct(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                protected static Initializable make() throws Exception {
                    Method getPackage;
                    if (JavaModule.isSupported()) {
                        try {
                            getPackage = ClassLoader.class.getMethod("getDefinedPackage", String.class);
                        }
                        catch (NoSuchMethodException ignored) {
                            getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                            getPackage.setAccessible(true);
                        }
                    } else {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                        getPackage.setAccessible(true);
                    }
                    Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                    findLoadedClass.setAccessible(true);
                    Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    defineClass.setAccessible(true);
                    Method definePackage = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                    definePackage.setAccessible(true);
                    try {
                        Method getClassLoadingLock = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
                        getClassLoadingLock.setAccessible(true);
                        return new ForJava7CapableVm(findLoadedClass, defineClass, getPackage, definePackage, getClassLoadingLock);
                    }
                    catch (NoSuchMethodException ignored) {
                        return new ForLegacyVm(findLoadedClass, defineClass, getPackage, definePackage);
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(SUPPRESS_ACCESS_CHECKS);
                        }
                        catch (Exception exception) {
                            return new Unavailable(exception.getMessage());
                        }
                    }
                    return this;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke((Object)classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#definePackage", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.findLoadedClass.equals(((Direct)object).findLoadedClass)) {
                        return false;
                    }
                    if (!this.defineClass.equals(((Direct)object).defineClass)) {
                        return false;
                    }
                    if (!this.getPackage.equals(((Direct)object).getPackage)) {
                        return false;
                    }
                    return this.definePackage.equals(((Direct)object).definePackage);
                }

                public int hashCode() {
                    return (((17 * 31 + this.findLoadedClass.hashCode()) * 31 + this.defineClass.hashCode()) * 31 + this.getPackage.hashCode()) * 31 + this.definePackage.hashCode();
                }

                protected static class ForLegacyVm
                extends Direct {
                    protected ForLegacyVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                    }

                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                protected static class ForJava7CapableVm
                extends Direct {
                    private final Method getClassLoadingLock;

                    protected ForJava7CapableVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                        this.getClassLoadingLock = getClassLoadingLock;
                    }

                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        try {
                            return this.getClassLoadingLock.invoke((Object)classLoader, name);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Could not access java.lang.ClassLoader#getClassLoadingLock", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.ClassLoader#getClassLoadingLock", exception.getCause());
                        }
                    }

                    public boolean equals(Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.getClassLoadingLock.equals(((ForJava7CapableVm)object).getClassLoadingLock);
                    }

                    public int hashCode() {
                        return super.hashCode() * 31 + this.getClassLoadingLock.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        if (JavaModule.isSupported()) {
                            return UsingUnsafe.isAvailable() ? UsingUnsafeInjection.make() : UsingUnsafeOverride.make();
                        }
                        return Direct.make();
                    }
                    catch (InvocationTargetException exception) {
                        return new Initializable.Unavailable(exception.getCause().getMessage());
                    }
                    catch (Exception exception) {
                        return new Initializable.Unavailable(exception.getMessage());
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Unavailable
                implements Dispatcher,
                Initializable {
                    private final String message;

                    protected Unavailable(String message) {
                        this.message = message;
                    }

                    @Override
                    public boolean isAvailable() {
                        return false;
                    }

                    @Override
                    public Dispatcher initialize() {
                        return this;
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }

                    @Override
                    public Class<?> findClass(ClassLoader classLoader, String name) {
                        try {
                            return classLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException ignored) {
                            return UNDEFINED;
                        }
                    }

                    @Override
                    public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                        throw new UnsupportedOperationException("Cannot define class using reflection: " + this.message);
                    }

                    @Override
                    public Package getPackage(ClassLoader classLoader, String name) {
                        throw new UnsupportedOperationException("Cannot get package using reflection: " + this.message);
                    }

                    @Override
                    public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                        throw new UnsupportedOperationException("Cannot define package using injection: " + this.message);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.message.equals(((Unavailable)object).message);
                    }

                    public int hashCode() {
                        return 17 * 31 + this.message.hashCode();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    implements ClassInjector {
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            LinkedHashMap<String, byte[]> binaryRepresentations = new LinkedHashMap<String, byte[]>();
            for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                binaryRepresentations.put(entry.getKey().getName(), entry.getValue());
            }
            Map<String, Class<?>> loadedTypes = this.injectRaw(binaryRepresentations);
            LinkedHashMap result2 = new LinkedHashMap();
            for (TypeDescription typeDescription : types.keySet()) {
                result2.put(typeDescription, loadedTypes.get(typeDescription.getName()));
            }
            return result2;
        }
    }
}

