/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.Arrays;
import org.jdom.output.EscapeStrategy;
import org.jdom.output.Format;

final class FormatStack {
    private int capacity = 16;
    private int depth = 0;
    private final Format.TextMode defaultMode;
    private final String indent;
    private final String encoding;
    private final String lineSeparator;
    private final boolean omitDeclaration;
    private final boolean omitEncoding;
    private final boolean expandEmptyElements;
    private final EscapeStrategy escapeStrategy;
    private String[] levelIndent = new String[this.capacity];
    private String[] levelEOL = new String[this.capacity];
    private String[] levelEOLIndent = new String[this.capacity];
    private String[] termEOLIndent = new String[this.capacity];
    private boolean[] ignoreTrAXEscapingPIs = new boolean[this.capacity];
    private Format.TextMode[] mode = new Format.TextMode[this.capacity];
    private boolean[] escapeOutput = new boolean[this.capacity];

    FormatStack(Format format) {
        this.indent = format.getIndent();
        this.lineSeparator = format.getLineSeparator();
        this.encoding = format.getEncoding();
        this.omitDeclaration = format.getOmitDeclaration();
        this.omitEncoding = format.getOmitEncoding();
        this.expandEmptyElements = format.getExpandEmptyElements();
        this.escapeStrategy = format.getEscapeStrategy();
        this.defaultMode = format.getTextMode();
        this.mode[this.depth] = format.getTextMode();
        if (this.mode[this.depth] == Format.TextMode.PRESERVE) {
            this.levelIndent[this.depth] = null;
            this.levelEOL[this.depth] = null;
            this.levelEOLIndent[this.depth] = null;
            this.termEOLIndent[this.depth] = null;
        } else {
            this.levelIndent[this.depth] = format.getIndent() == null ? null : "";
            this.levelEOL[this.depth] = format.getLineSeparator();
            this.levelEOLIndent[this.depth] = this.levelIndent[this.depth] == null ? null : this.levelEOL[this.depth];
            this.termEOLIndent[this.depth] = this.levelEOLIndent[this.depth];
        }
        this.ignoreTrAXEscapingPIs[this.depth] = format.getIgnoreTrAXEscapingPIs();
        this.escapeOutput[this.depth] = true;
    }

    private void resetReusableIndents() {
        for (int d2 = this.depth + 1; d2 < this.levelIndent.length && this.levelIndent[d2] != null; ++d2) {
            this.levelIndent[d2] = null;
        }
    }

    public String getIndent() {
        return this.indent;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    boolean isOmitDeclaration() {
        return this.omitDeclaration;
    }

    boolean isOmitEncoding() {
        return this.omitEncoding;
    }

    boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    boolean getEscapeOutput() {
        return this.escapeOutput[this.depth];
    }

    Format.TextMode getDefaultMode() {
        return this.defaultMode;
    }

    String getPadBetween() {
        return this.levelEOLIndent[this.depth];
    }

    String getPadLast() {
        return this.termEOLIndent[this.depth];
    }

    String getLevelEOL() {
        return this.levelEOL[this.depth];
    }

    Format.TextMode getTextMode() {
        return this.mode[this.depth];
    }

    void setTextMode(Format.TextMode mode) {
        if (this.mode[this.depth] == mode) {
            return;
        }
        this.mode[this.depth] = mode;
        if (mode == Format.TextMode.PRESERVE) {
            this.levelEOL[this.depth] = null;
            this.levelIndent[this.depth] = null;
            this.levelEOLIndent[this.depth] = null;
            this.termEOLIndent[this.depth] = null;
        } else {
            this.levelEOL[this.depth] = this.lineSeparator;
            if (this.indent == null || this.lineSeparator == null) {
                this.levelEOLIndent[this.depth] = null;
                this.termEOLIndent[this.depth] = null;
            } else {
                if (this.depth > 0) {
                    StringBuilder sb = new StringBuilder(this.indent.length() * this.depth);
                    for (int i2 = 1; i2 < this.depth; ++i2) {
                        sb.append(this.indent);
                    }
                    this.termEOLIndent[this.depth] = this.lineSeparator + sb;
                    sb.append(this.indent);
                    this.levelIndent[this.depth] = sb.toString();
                } else {
                    this.termEOLIndent[this.depth] = this.lineSeparator;
                    this.levelIndent[this.depth] = "";
                }
                this.levelEOLIndent[this.depth] = this.lineSeparator + this.levelIndent[this.depth];
            }
        }
        this.resetReusableIndents();
    }

    public void push() {
        int prev = this.depth++;
        if (this.depth >= this.capacity) {
            this.capacity *= 2;
            this.levelIndent = Arrays.copyOf(this.levelIndent, this.capacity);
            this.levelEOL = Arrays.copyOf(this.levelEOL, this.capacity);
            this.levelEOLIndent = Arrays.copyOf(this.levelEOLIndent, this.capacity);
            this.termEOLIndent = Arrays.copyOf(this.termEOLIndent, this.capacity);
            this.ignoreTrAXEscapingPIs = Arrays.copyOf(this.ignoreTrAXEscapingPIs, this.capacity);
            this.mode = Arrays.copyOf(this.mode, this.capacity);
            this.escapeOutput = Arrays.copyOf(this.escapeOutput, this.capacity);
        }
        this.ignoreTrAXEscapingPIs[this.depth] = this.ignoreTrAXEscapingPIs[prev];
        this.mode[this.depth] = this.mode[prev];
        this.escapeOutput[this.depth] = this.escapeOutput[prev];
        if (this.levelIndent[prev] == null || this.levelEOL[prev] == null) {
            this.levelIndent[this.depth] = null;
            this.levelEOL[this.depth] = null;
            this.levelEOLIndent[this.depth] = null;
            this.termEOLIndent[this.depth] = null;
        } else if (this.levelIndent[this.depth] == null) {
            this.levelEOL[this.depth] = this.levelEOL[prev];
            this.termEOLIndent[this.depth] = this.levelEOL[this.depth] + this.levelIndent[prev];
            this.levelIndent[this.depth] = this.levelIndent[prev] + this.indent;
            this.levelEOLIndent[this.depth] = this.levelEOL[this.depth] + this.levelIndent[this.depth];
        }
    }

    public void pop() {
        --this.depth;
    }
}

