/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.languagetool.markup.AnnotatedText;

public class SentenceRange {
    private final int fromPos;
    private final int toPos;

    SentenceRange(int fromPos, int toPos) {
        this.fromPos = fromPos;
        this.toPos = toPos;
    }

    public static List<SentenceRange> getRangesFromSentences(AnnotatedText annotatedText, List<String> sentences2) {
        ArrayList<SentenceRange> sentenceRanges = new ArrayList<SentenceRange>();
        int pos = 0;
        int diff = annotatedText.getTextWithMarkup().length() - annotatedText.getPlainText().length();
        for (String sentence : sentences2) {
            if (sentence.trim().isEmpty()) {
                pos += sentence.length();
                continue;
            }
            String sentenceNoBeginnWhitespace = sentence.replaceFirst("^\\s*", "");
            String sentenceNoEndWhitespace = sentence.replaceFirst("\\s++$", "");
            int fromPos = pos + (sentence.length() - sentenceNoBeginnWhitespace.length());
            int toPos = pos + sentenceNoEndWhitespace.length();
            int fromPosOrig = fromPos + diff;
            int toPosOrig = toPos + diff;
            if (fromPosOrig != annotatedText.getTextWithMarkup().length()) {
                fromPosOrig = annotatedText.getOriginalTextPositionFor(fromPos, false);
            }
            if (toPosOrig != annotatedText.getTextWithMarkup().length()) {
                toPosOrig = annotatedText.getOriginalTextPositionFor(toPos, true);
            }
            sentenceRanges.add(new SentenceRange(fromPosOrig, toPosOrig));
            pos += sentence.length();
        }
        return sentenceRanges;
    }

    public int getFromPos() {
        return this.fromPos;
    }

    public int getToPos() {
        return this.toPos;
    }

    public String toString() {
        return this.fromPos + "-" + this.toPos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentenceRange range = (SentenceRange)o;
        return this.fromPos == range.fromPos && this.toPos == range.toPos;
    }

    public int hashCode() {
        return Objects.hash(this.fromPos, this.toPos);
    }
}

