/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.languagetool.JLanguageTool;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.spelling.hunspell.DumontsHunspellDictionary;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;

public final class Hunspell {
    private static final Map<LanguageAndPath, HunspellDictionary> map = new HashMap<LanguageAndPath, HunspellDictionary>();
    private static BiFunction<Path, Path, HunspellDictionary> hunspellDictionaryFactory = DumontsHunspellDictionary::new;

    public static void setHunspellDictionaryFactory(BiFunction<Path, Path, HunspellDictionary> factory) {
        hunspellDictionaryFactory = factory;
    }

    public static synchronized HunspellDictionary getDictionary(Path dictionary, Path affix) {
        LanguageAndPath key2 = new LanguageAndPath(dictionary, affix);
        HunspellDictionary hunspell = map.get(key2);
        if (hunspell != null) {
            return hunspell;
        }
        HunspellDictionary newHunspell = hunspellDictionaryFactory.apply(dictionary, affix);
        map.put(key2, newHunspell);
        return newHunspell;
    }

    public static HunspellDictionary forDictionaryInResources(String language, String resourcePath) {
        try {
            ResourceDataBroker broker = JLanguageTool.getDataBroker();
            InputStream dictionaryStream = broker.getAsStream(resourcePath + language + ".dic");
            InputStream affixStream = broker.getAsStream(resourcePath + language + ".aff");
            if (dictionaryStream == null || affixStream == null) {
                throw new RuntimeException("Could not find dictionary for language \"" + language + "\" in classpath");
            }
            Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
            Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
            Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
            return hunspellDictionaryFactory.apply(dictionary, affix);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
        }
    }

    public static HunspellDictionary forDictionaryInResources(String language) {
        return Hunspell.forDictionaryInResources(language, "");
    }

    static class LanguageAndPath {
        private final Path dictionary;
        private final Path affix;

        LanguageAndPath(Path dictionary, Path affix) {
            this.dictionary = Objects.requireNonNull(dictionary);
            this.affix = Objects.requireNonNull(affix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageAndPath that = (LanguageAndPath)o;
            return Objects.equals(this.dictionary, that.dictionary) && Objects.equals(this.affix, that.affix);
        }

        public int hashCode() {
            return Objects.hash(this.dictionary, this.affix);
        }
    }
}

