/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\"\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ssh/PrependingInputStream;", "Ljava/io/InputStream;", "forward", "(Ljava/io/InputStream;)V", "prefix", "Ljava/util/ArrayDeque;", "", "getPrefix", "()Ljava/util/ArrayDeque;", "available", "", "close", "", "read", "b", "", "off", "len", "intellij.platform.ssh"})
final class PrependingInputStream
extends InputStream {
    @NotNull
    private final InputStream forward;
    @NotNull
    private final ArrayDeque<Byte> prefix;

    public PrependingInputStream(@NotNull InputStream forward) {
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        this.forward = forward;
        this.prefix = new ArrayDeque();
    }

    @NotNull
    public final ArrayDeque<Byte> getPrefix() {
        return this.prefix;
    }

    @Override
    public int read() {
        Byte by = this.prefix.pollFirst();
        return by != null ? by.byteValue() : this.forward.read();
    }

    @Override
    public int read(@Nullable byte[] b, int off, int len) {
        byte[] byArray = b;
        if (b == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        int size = 0;
        int pos = off;
        int end = off + len;
        while (pos < end && !((Collection)this.prefix).isEmpty()) {
            Byte by = this.prefix.pollFirst();
            Intrinsics.checkNotNull((Object)by);
            b[pos] = ((Number)by).byteValue();
            ++pos;
            ++size;
        }
        if (pos < end && (size <= 0 || this.forward.available() != 0)) {
            size += this.forward.read(b, pos, end - pos);
        }
        return size;
    }

    @Override
    public void close() {
        this.forward.close();
    }

    @Override
    public int available() {
        return this.prefix.size() + this.forward.available();
    }
}

