/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshConfigManagerBase
implements PersistentStateComponent<State> {
    @NotNull
    private SshConfigManager.ConfigsData myData;
    @Nullable
    protected final com.intellij.openapi.project.Project myProject;
    private final List<Listener> myListeners = new CopyOnWriteArrayList<Listener>();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull String> myInitialMappingNameToIdConfig = new ConcurrentHashMap<String, String>();

    private SshConfigManagerBase(@Nullable com.intellij.openapi.project.Project project2) {
        this.myProject = project2;
        this.myData = new SshConfigManager.ConfigsData();
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        MessageBusConnection busConnection = this.myProject == null ? bus.connect() : bus.connect((Disposable)this.myProject);
        busConnection.subscribe(SshConfigManager.SSH_CONFIG_AUTH, (Object)new SshConfigManager.SshConfigAuthListener(){

            @Override
            public void sshConfigAuthDataChanged(@NotNull SshConfig sshConfig) {
                if (sshConfig == null) {
                    1.$$$reportNull$$$0(0);
                }
                1.reloadAuthForConfig(sshConfig, SshConfigManagerBase.this.myData.getLastSavedData());
                1.reloadAuthForConfig(sshConfig, SshConfigManagerBase.this.myData.getCurrentData());
            }

            private static void reloadAuthForConfig(@NotNull SshConfig sshConfig, List<SshUiData> data) {
                SshUiData savedData;
                if (sshConfig == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((savedData = SshUiData.findById(data, sshConfig.getId())) != null) {
                    savedData.reloadAuthDataFromPasswordSafe();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sshConfig";
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sshConfigAuthDataChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadAuthForConfig";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public State getState() {
        if (this.myData.getLastSavedData().isEmpty()) {
            return null;
        }
        State state = new State();
        for (SshUiData data : this.myData.getLastSavedData()) {
            SshConfig clone = data.getConfig().clone();
            clone.setProjectLevel(false);
            state.configs.add(clone);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SshConfigManagerBase.$$$reportNull$$$0(0);
        }
        List<SshUiData> lastData = this.myData.getCurrentData();
        ArrayList<SshUiData> data = new ArrayList<SshUiData>();
        for (SshConfig config : state.configs) {
            config.setProjectLevel(this.myProject != null);
            data.add(new SshUiData(config));
            this.myInitialMappingNameToIdConfig.putIfAbsent(config.getName(), config.getId());
        }
        this.myData = new SshConfigManager.ConfigsData(data, data);
        this.notifyListeners(new SshConfigManager.ConfigsData(lastData, data));
    }

    public SshConfigManager.ConfigsData getLastSavedAndCurrentData() {
        return this.myData;
    }

    public void setCurrentData(@NotNull List<SshUiData> newData) {
        if (newData == null) {
            SshConfigManagerBase.$$$reportNull$$$0(1);
        }
        List<SshUiData> lastCurrentData = this.myData.getCurrentData();
        this.myData = this.myData.createWithCurrentData(newData);
        this.notifyListeners(new SshConfigManager.ConfigsData(lastCurrentData, newData));
    }

    public void applyData(@NotNull List<SshUiData> data) {
        if (data == null) {
            SshConfigManagerBase.$$$reportNull$$$0(2);
        }
        List<SshUiData> lastCurrentData = this.myData.getCurrentData();
        for (SshUiData item : this.myData.getLastSavedData()) {
            String id = item.getConfig().getId();
            SshUiData newData = SshUiData.findById(data, id);
            if (newData != null) continue;
            item.getConfig().eraseAuthDataFromPasswordSafe();
        }
        for (SshUiData item : data) {
            item.saveAuthDataToPasswordSafe();
        }
        this.myData = new SshConfigManager.ConfigsData(data, data);
        this.notifyListeners(new SshConfigManager.ConfigsData(lastCurrentData, data));
    }

    public void applyLastSavedData() {
        List<SshUiData> lastCurrentData = this.myData.getCurrentData();
        @NotNull List<SshUiData> data = this.myData.getLastSavedData();
        for (SshUiData item : data) {
            item.saveAuthDataToPasswordSafe();
        }
        this.myData = new SshConfigManager.ConfigsData(data, data);
        this.notifyListeners(new SshConfigManager.ConfigsData(lastCurrentData, data));
    }

    public void addToSavedAndCurrent(SshUiData data) {
        List<SshUiData> lastCurrentData = this.myData.getCurrentData();
        this.myData = this.myData.createMerged(new SshConfigManager.ConfigsData(data));
        this.notifyListeners(new SshConfigManager.ConfigsData(lastCurrentData, this.myData.getCurrentData()));
    }

    @Nullable
    public SshUiData findExistingData(String host2, String port2, String username, AuthType type) {
        if (StringUtil.isEmpty((String)host2) || StringUtil.isEmpty((String)port2) || SshConfig.parseSshPort(port2) < 0) {
            return null;
        }
        for (SshUiData data : this.myData.getCurrentData()) {
            SshConfig config = data.getConfig();
            if (type != config.getAuthType() || !Objects.equals(host2, config.getHost()) || !Objects.equals(port2, config.getLiteralPort()) || !Objects.equals(StringUtil.nullize((String)username, (boolean)true), StringUtil.nullize((String)config.getUsername(), (boolean)true))) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataName(@NotNull String name) {
        if (name == null) {
            SshConfigManagerBase.$$$reportNull$$$0(3);
        }
        for (SshUiData data : this.myData.getCurrentData()) {
            SshConfig config = data.getConfig();
            if (!Objects.equals(name, config.getName())) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByData(@NotNull PresentableId presentableId) {
        String id;
        if (presentableId == null) {
            SshConfigManagerBase.$$$reportNull$$$0(4);
        }
        if ((id = presentableId.getId()) == null) {
            return null;
        }
        for (SshUiData data : this.myData.getCurrentData()) {
            SshConfig config = data.getConfig();
            if (!Objects.equals(id, config.getId())) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataId(@NotNull String id) {
        if (id == null) {
            SshConfigManagerBase.$$$reportNull$$$0(5);
        }
        for (SshUiData data : this.myData.getCurrentData()) {
            SshConfig config = data.getConfig();
            if (!Objects.equals(id, config.getId())) continue;
            return data;
        }
        return null;
    }

    public void removeFromSavedAndCurrent(SshUiData data) {
        List<SshUiData> lastCurrentData = this.myData.getCurrentData();
        Condition condition = other -> !other.getConfig().getId().equals(data.getConfig().getId());
        List saved = ContainerUtil.findAll(this.myData.getLastSavedData(), (Condition)condition);
        List current = ContainerUtil.findAll(this.myData.getCurrentData(), (Condition)condition);
        this.myData = new SshConfigManager.ConfigsData(saved, current);
        this.notifyListeners(new SshConfigManager.ConfigsData(lastCurrentData, current));
    }

    public void addChangeListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private void notifyListeners(@NotNull SshConfigManager.ConfigsData data) {
        if (data == null) {
            SshConfigManagerBase.$$$reportNull$$$0(6);
        }
        for (Listener listener : this.myListeners) {
            listener.changed(data);
        }
    }

    public String getIdFromInitialName(@NotNull String initialName) {
        if (initialName == null) {
            SshConfigManagerBase.$$$reportNull$$$0(7);
        }
        return this.myInitialMappingNameToIdConfig.get(initialName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyListeners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdFromInitialName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        @XCollection(style=XCollection.Style.v2, propertyElementName="configs")
        public List<SshConfig> configs = new ArrayList<SshConfig>();
    }

    static interface Listener {
        public void changed(@NotNull SshConfigManager.ConfigsData var1);
    }

    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")}, category=SettingsCategory.TOOLS)
    static final class App
    extends SshConfigManagerBase {
        App() {
            super(null);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")}, category=SettingsCategory.TOOLS)
    static final class Project
    extends SshConfigManagerBase {
        Project(@NotNull com.intellij.openapi.project.Project project2) {
            if (project2 == null) {
                Project.$$$reportNull$$$0(0);
            }
            super(project2);
        }

        public com.intellij.openapi.project.Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ssh/config/unified/SshConfigManagerBase$Project", "<init>"));
        }
    }
}

