/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.common.ThreadLeakTracker;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class LeakHunter {
    @TestOnly
    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        if (project2 == null) {
            LeakHunter.$$$reportNull$$$0(0);
        }
        String creationTrace = project2 instanceof ProjectEx ? ((ProjectEx)project2).getCreationTrace() : null;
        String string = project2 + " " + (creationTrace == null ? " " : creationTrace);
        if (string == null) {
            LeakHunter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @TestOnly
    public static void checkProjectLeak() throws AssertionError {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault() && !project2.isLight());
    }

    @TestOnly
    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault());
    }

    @TestOnly
    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(2);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(3);
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(4);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(5);
        }
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String message = LeakHunter.getLeakedObjectDetails(leaked, backLink, true);
            System.out.println(message);
            System.out.println(";-----");
            ThreadUtil.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    @TestOnly
    public static <T> void processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(6);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            LeakHunter.$$$reportNull$$$0(8);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorCache.clearCacheForTests();
        Runnable runnable2 = () -> {
            try (AccessToken ignored = ProhibitAWTEvents.start((String)"checking for leaks");){
                DebugReflectionUtil.walkObjects((int)10000, (Map)((Map)rootsSupplier.get()), (Class)suspectClass, __ -> true, (leaked, backLink) -> {
                    if (isReallyLeak == null || isReallyLeak.test(leaked)) {
                        return processor.process(leaked, backLink);
                    }
                    return true;
                });
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            runnable2.run();
        } else {
            application.runReadAction(runnable2);
        }
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(9);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(10);
        }
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @TestOnly
    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        Supplier<Map<Object, String>> supplier = () -> {
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Collection allLoadedClasses = (Collection)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
            LaterInvocator.purgeExpiredItems();
            IdentityHashMap<Object, String> result2 = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result2.put(application, "ApplicationManager.getApplication()");
            }
            result2.put(Disposer.getTree(), "Disposer.getTree()");
            result2.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result2.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result2.put(ThreadLeakTracker.getThreads().values(), "all live threads");
            if (allLoadedClasses != null) {
                result2.put(allLoadedClasses, "all loaded classes statics");
            }
            return result2;
        };
        if (supplier == null) {
            LeakHunter.$$$reportNull$$$0(11);
        }
        return supplier;
    }

    @TestOnly
    @NotNull
    public static String getLeakedObjectDetails(@NotNull Object leaked, @Nullable Object backLink, boolean detailedErrorDescription) {
        String creationPlace;
        if (leaked == null) {
            LeakHunter.$$$reportNull$$$0(12);
        }
        int hashCode = System.identityHashCode(leaked);
        String result2 = "Found a leaked instance of " + leaked.getClass() + "\nInstance: " + leaked + "\nHashcode: " + hashCode;
        if (detailedErrorDescription) {
            result2 = result2 + "\n" + LeakHunter.getLeakedObjectErrorDescription(null);
        }
        if (backLink != null) {
            result2 = result2 + "\nExisting strong reference path to the instance:\n" + backLink.toString().indent(2);
        }
        String string = creationPlace = leaked instanceof Project ? LeakHunter.getCreationPlace((Project)leaked) : null;
        if (creationPlace != null) {
            result2 = result2 + "\nThe instance was created at: " + creationPlace;
        }
        String string2 = result2;
        if (string2 == null) {
            LeakHunter.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @TestOnly
    @NotNull
    public static String getLeakedObjectErrorDescription(@Nullable String knownHeapDumpPath) {
        Object result2 = "Error description:\n  This error means that the object is expected to be collected by the garbage collector by this time, but it was not.\n  Please make sure you dispose your resources properly. See https://plugins.jetbrains.com/docs/intellij/disposers.html";
        if (TeamCityLogger.isUnderTC) {
            result2 = (String)result2 + "\n  You can find a memory snapshot `leakedProjects.hproof.zip` in the \"Artifacts\" tab of the build run.";
            result2 = (String)result2 + "\n  If you suspect a particular test, you can reproduce the problem locally calling TestApplicationManager.testProjectLeak() after the test.";
        } else {
            result2 = knownHeapDumpPath != null ? (String)result2 + "\n  Please see ``" + knownHeapDumpPath + "` for a memory dump" : (String)result2 + "\n  Try looking for 'Heap dump is published to ' line in the system output log below. It contains a path to a collected memory snapshot";
        }
        Object object = result2;
        if (object == null) {
            LeakHunter.$$$reportNull$$$0(14);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaked";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationPlace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeakedObjectDetails";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeakedObjectErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCreationPlace";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLeakedObjectDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

