/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.EmmetPreviewUtil;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewTypedHandler
extends TypedActionHandlerBase {
    public EmmetPreviewTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            EmmetPreviewTypedHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            EmmetPreviewTypedHandler.$$$reportNull$$$0(1);
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
        if (EmmetOptions.getInstance().isEmmetEnabled() && EmmetOptions.getInstance().isPreviewEnabled()) {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return;
            }
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
            if (file == null) {
                return;
            }
            EmmetPreviewHint existingBalloon = EmmetPreviewHint.getExistingHint(editor);
            if (existingBalloon != null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            ReadAction.nonBlocking(() -> {
                if (editor.isDisposed() || EmmetPreviewHint.getExistingHint(editor) != null) {
                    return null;
                }
                return EmmetPreviewUtil.calculateTemplateText(editor, file, true);
            }).finishOnUiThread(ModalityState.current(), templateText -> {
                if (StringUtil.isNotEmpty((String)templateText)) {
                    EmmetPreviewHint.createHint((EditorEx)editor, templateText, file.getFileType()).showHint();
                    EmmetPreviewUtil.addEmmetPreviewListeners(editor, file, false);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewTypedHandler";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

