/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    public static SuppressQuickFix @NotNull [] getSuppressFixes(@NotNull String toolId) {
        if (toolId == null) {
            XmlSuppressableInspectionTool.$$$reportNull$$$0(0);
        }
        return XmlSuppressableInspectionTool.getSuppressFixes(toolId, new DefaultXmlSuppressionProvider());
    }

    public static SuppressQuickFix @NotNull [] getSuppressFixes(@NotNull String toolId, @NotNull XmlSuppressionProvider provider2) {
        if (toolId == null) {
            XmlSuppressableInspectionTool.$$$reportNull$$$0(1);
        }
        if (provider2 == null) {
            XmlSuppressableInspectionTool.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressTagStatic(toolId, provider2), new SuppressForFile(toolId, provider2), new SuppressAllForFile(provider2)};
        if (suppressQuickFixArray == null) {
            XmlSuppressableInspectionTool.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/XmlSuppressableInspectionTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/XmlSuppressableInspectionTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressFixes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }

    public static class SuppressTagStatic
    extends XmlSuppressFix {
        public SuppressTagStatic(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressTagStatic(String id) {
            super(id);
        }

        @NotNull
        public String getName() {
            String string2 = XmlPsiBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string2 == null) {
                SuppressTagStatic.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                SuppressTagStatic.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SuppressTagStatic.$$$reportNull$$$0(2);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), XmlTag.class) == null) {
                return;
            }
            this.myProvider.suppressForTag(element, this.myId);
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    public static class SuppressForFile
    extends XmlSuppressFix {
        public SuppressForFile(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressForFile(String id) {
            super(id);
        }

        @NotNull
        public String getName() {
            String string2 = XmlPsiBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string2 == null) {
                SuppressForFile.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                SuppressForFile.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SuppressForFile.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            this.myProvider.suppressForFile(element, this.myId);
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return context == null || !context.isValid() ? null : context.getContainingFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile(XmlSuppressionProvider provider2) {
            super(XmlSuppressableInspectionTool.ALL, provider2);
        }

        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = XmlPsiBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string2 == null) {
                SuppressAllForFile.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile", "getName"));
        }
    }

    public static abstract class XmlSuppressFix
    implements InjectionAwareSuppressQuickFix,
    ContainerBasedSuppressQuickFix {
        protected final String myId;
        @FileModifier.SafeFieldForPreview
        protected final XmlSuppressionProvider myProvider;
        private ThreeState myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;

        protected XmlSuppressFix(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            this.myId = inspectionId;
            this.myProvider = suppressionProvider;
        }

        protected XmlSuppressFix(String id) {
            this(id, new DefaultXmlSuppressionProvider());
        }

        public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
            if (project2 == null) {
                XmlSuppressFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                XmlSuppressFix.$$$reportNull$$$0(1);
            }
            return context.isValid() && this.getContainer(context) != null;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = this.getName();
            if (string2 == null) {
                XmlSuppressFix.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return null;
        }

        @NotNull
        public ThreeState isShouldBeAppliedToInjectionHost() {
            ThreeState threeState = this.myShouldBeAppliedToInjectionHost;
            if (threeState == null) {
                XmlSuppressFix.$$$reportNull$$$0(3);
            }
            return threeState;
        }

        public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
            if (shouldBeAppliedToInjectionHost == null) {
                XmlSuppressFix.$$$reportNull$$$0(4);
            }
            this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
        }

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldBeAppliedToInjectionHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isShouldBeAppliedToInjectionHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setShouldBeAppliedToInjectionHost";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

