/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.json;

import com.intellij.collaboration.api.HttpApiHelper;
import com.intellij.collaboration.api.HttpApiHelperKt;
import com.intellij.collaboration.api.httpclient.ByteArrayProducingBodyPublisher;
import com.intellij.collaboration.api.httpclient.HttpClientUtil;
import com.intellij.collaboration.api.json.HttpJsonDeserializationException;
import com.intellij.collaboration.api.json.JsonDataDeserializer;
import com.intellij.collaboration.api.json.JsonDataSerializer;
import com.intellij.collaboration.api.json.JsonHttpApiHelper;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0096A\u00a2\u0006\u0002\u0010\u0016J8\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00190\u00180\u0012\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ2\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u0012\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ:\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010\u00180\u0012\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ4\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00190\u0012\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJZ\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H!0\u0012\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010!2\u0006\u0010\u0014\u001a\u00020\u00152\u0016\b\u0004\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0019\u0012\u0004\u0012\u0002H!0#2\u0016\b\u0004\u0010$\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u0001H\u00190#H\u0082H\u00a2\u0006\u0002\u0010&J\u0011\u0010\u0014\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0001J\u0011\u0010\u0014\u001a\u00020'2\u0006\u0010\r\u001a\u00020(H\u0096\u0001J\u001e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0096A\u00a2\u0006\u0002\u0010\u0016J2\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u0012\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u00190,H\u0096A\u00a2\u0006\u0002\u0010-R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/collaboration/api/json/JsonHttpApiHelperImpl;", "Lcom/intellij/collaboration/api/json/JsonHttpApiHelper;", "Lcom/intellij/collaboration/api/HttpApiHelper;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "httpHelper", "serializer", "Lcom/intellij/collaboration/api/json/JsonDataSerializer;", "deserializer", "Lcom/intellij/collaboration/api/json/JsonDataDeserializer;", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/collaboration/api/HttpApiHelper;Lcom/intellij/collaboration/api/json/JsonDataSerializer;Lcom/intellij/collaboration/api/json/JsonDataDeserializer;)V", "jsonBodyPublisher", "Ljava/net/http/HttpRequest$BodyPublisher;", "uri", "Ljava/net/URI;", "body", "", "loadImage", "Ljava/net/http/HttpResponse;", "Ljava/awt/Image;", "request", "Ljava/net/http/HttpRequest;", "(Ljava/net/http/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadJsonListByClass", "", "T", "clazz", "Ljava/lang/Class;", "(Ljava/net/http/HttpRequest;Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadJsonValueByClass", "loadOptionalJsonListByClass", "loadOptionalJsonValueByClass", "loadWithMapperAndLogErrors", "R", "map", "Lkotlin/Function1;", "load", "Ljava/io/Reader;", "(Ljava/net/http/HttpRequest;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/net/http/HttpRequest$Builder;", "", "sendAndAwaitCancellable", "", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "(Ljava/net/http/HttpRequest;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nJsonHttpApiHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonHttpApiHelper.kt\ncom/intellij/collaboration/api/json/JsonHttpApiHelperImpl\n*L\n1#1,109:1\n71#1:110\n82#1:111\n71#1:112\n82#1:113\n71#1:114\n82#1:115\n71#1:116\n82#1:117\n*S KotlinDebug\n*F\n+ 1 JsonHttpApiHelper.kt\ncom/intellij/collaboration/api/json/JsonHttpApiHelperImpl\n*L\n96#1:110\n96#1:111\n99#1:112\n99#1:113\n103#1:114\n103#1:115\n107#1:116\n107#1:117\n*E\n"})
final class JsonHttpApiHelperImpl
implements JsonHttpApiHelper,
HttpApiHelper {
    @NotNull
    private final Logger logger;
    @NotNull
    private final HttpApiHelper httpHelper;
    @NotNull
    private final JsonDataSerializer serializer;
    @NotNull
    private final JsonDataDeserializer deserializer;

    public JsonHttpApiHelperImpl(@NotNull Logger logger, @NotNull HttpApiHelper httpHelper, @NotNull JsonDataSerializer serializer2, @NotNull JsonDataDeserializer deserializer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)httpHelper, (String)"httpHelper");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)deserializer, (String)"deserializer");
        this.logger = logger;
        this.httpHelper = httpHelper;
        this.serializer = serializer2;
        this.deserializer = deserializer;
    }

    @Override
    @Nullable
    public Object loadImage(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Image>> $completion) {
        return this.httpHelper.loadImage(request, $completion);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @Nullable
    public Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Unit>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, $completion);
    }

    @Override
    @Nullable
    public <T> Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<T> bodyHandler2, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, bodyHandler2, $completion);
    }

    private final <T, R> Object loadWithMapperAndLogErrors(HttpRequest request, Function1<? super T, ? extends R> map2, Function1<? super Reader, ? extends T> load2, Continuation<? super HttpResponse<? extends R>> $completion) {
        boolean $i$f$loadWithMapperAndLogErrors = false;
        HttpResponse.BodyHandler bodyHandler2 = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, R>(load2, this, request, map2){
            final /* synthetic */ Function1<Reader, T> $load;
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ Function1<T, R> $map;
            {
                this.$load = $load;
                this.this$0 = $receiver;
                this.$request = $request;
                this.$map = $map;
                super(2);
            }

            public final R invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    object = this.$load.invoke((Object)reader);
                }
                catch (Throwable e) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                Object result2 = object;
                return (R)this.$map.invoke(result2);
            }
        });
        InlineMarker.mark((int)0);
        Object object = this.httpHelper.sendAndAwaitCancellable(request, bodyHandler2, $completion);
        InlineMarker.mark((int)1);
        return object;
    }

    @Override
    @NotNull
    public HttpRequest.BodyPublisher jsonBodyPublisher(@NotNull URI uri, @NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new ByteArrayProducingBodyPublisher((Function0<byte[]>)((Function0)new Function0<byte[]>(this, body, uri){
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ Object $body;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$body = $body;
                this.$uri = $uri;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                byte[] jsonBytes = JsonHttpApiHelperImpl.access$getSerializer$p(this.this$0).toJsonBytes(this.$body);
                if (JsonHttpApiHelperImpl.access$getLogger$p(this.this$0).isTraceEnabled()) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0).trace("Request POST " + this.$uri + " : Request body: " + new String(jsonBytes, Charsets.UTF_8));
                }
                return jsonBytes;
            }
        }));
    }

    @Override
    @Nullable
    public <T> Object loadJsonValueByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        JsonHttpApiHelperImpl this_$iv = this;
        boolean $i$f$loadWithMapperAndLogErrors = false;
        HttpResponse.BodyHandler bodyHandler$iv = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this_$iv.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, T>(this_$iv, request, this, clazz){
            final /* synthetic */ JsonHttpApiHelperImpl this$0$inline_fun;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ Class $clazz$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = jsonHttpApiHelperImpl;
                this.$clazz$inlined = clazz;
                super(2);
            }

            public final T invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                T result2;
                T t;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    Reader reader2 = reader;
                    boolean bl = false;
                    t = JsonHttpApiHelperImpl.access$getDeserializer$p(this.this$0).fromJson(reader2, this.$clazz$inlined);
                }
                catch (Throwable e) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0$inline_fun).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                T it = result2 = t;
                boolean bl = false;
                T t2 = it;
                if (t2 == null) {
                    throw new IllegalStateException("Empty response".toString());
                }
                return t2;
            }
        });
        return this_$iv.httpHelper.sendAndAwaitCancellable(request, bodyHandler$iv, $completion);
    }

    @Override
    @Nullable
    public <T> Object loadOptionalJsonValueByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        JsonHttpApiHelperImpl this_$iv = this;
        boolean $i$f$loadWithMapperAndLogErrors = false;
        HttpResponse.BodyHandler bodyHandler$iv = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this_$iv.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, T>(this_$iv, request, this, clazz){
            final /* synthetic */ JsonHttpApiHelperImpl this$0$inline_fun;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ Class $clazz$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = jsonHttpApiHelperImpl;
                this.$clazz$inlined = clazz;
                super(2);
            }

            public final T invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                T result2;
                T t;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    Reader reader2 = reader;
                    boolean bl = false;
                    t = JsonHttpApiHelperImpl.access$getDeserializer$p(this.this$0).fromJson(reader2, this.$clazz$inlined);
                }
                catch (Throwable e) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0$inline_fun).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                T it = result2 = t;
                boolean bl = false;
                return it;
            }
        });
        return this_$iv.httpHelper.sendAndAwaitCancellable(request, bodyHandler$iv, $completion);
    }

    @Override
    @Nullable
    public <T> Object loadJsonListByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull Continuation<? super HttpResponse<? extends List<? extends T>>> $completion) {
        JsonHttpApiHelperImpl this_$iv = this;
        boolean $i$f$loadWithMapperAndLogErrors = false;
        HttpResponse.BodyHandler bodyHandler$iv = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this_$iv.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, List<? extends T>>(this_$iv, request, this, clazz){
            final /* synthetic */ JsonHttpApiHelperImpl this$0$inline_fun;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ Class $clazz$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = jsonHttpApiHelperImpl;
                this.$clazz$inlined = clazz;
                super(2);
            }

            public final List<? extends T> invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                List result2;
                List list2;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    Reader reader2 = reader;
                    boolean bl = false;
                    Class[] classArray = new Class[]{this.$clazz$inlined};
                    List list3 = JsonHttpApiHelperImpl.access$getDeserializer$p(this.this$0).fromJson(reader2, List.class, classArray);
                    list2 = list3 instanceof List ? list3 : null;
                }
                catch (Throwable e) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0$inline_fun).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                List it = result2 = list2;
                boolean bl = false;
                List list4 = it;
                if (list4 == null) {
                    throw new IllegalStateException("Empty response".toString());
                }
                return list4;
            }
        });
        return this_$iv.httpHelper.sendAndAwaitCancellable(request, bodyHandler$iv, $completion);
    }

    @Override
    @Nullable
    public <T> Object loadOptionalJsonListByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull Continuation<? super HttpResponse<? extends List<? extends T>>> $completion) {
        JsonHttpApiHelperImpl this_$iv = this;
        boolean $i$f$loadWithMapperAndLogErrors = false;
        HttpResponse.BodyHandler bodyHandler$iv = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this_$iv.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, List<? extends T>>(this_$iv, request, this, clazz){
            final /* synthetic */ JsonHttpApiHelperImpl this$0$inline_fun;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ JsonHttpApiHelperImpl this$0;
            final /* synthetic */ Class $clazz$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = jsonHttpApiHelperImpl;
                this.$clazz$inlined = clazz;
                super(2);
            }

            public final List<? extends T> invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                List result2;
                List list2;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    Reader reader2 = reader;
                    boolean bl = false;
                    Class[] classArray = new Class[]{this.$clazz$inlined};
                    List list3 = JsonHttpApiHelperImpl.access$getDeserializer$p(this.this$0).fromJson(reader2, List.class, classArray);
                    list2 = list3 instanceof List ? list3 : null;
                }
                catch (Throwable e) {
                    JsonHttpApiHelperImpl.access$getLogger$p(this.this$0$inline_fun).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                List it = result2 = list2;
                boolean bl = false;
                return it;
            }
        });
        return this_$iv.httpHelper.sendAndAwaitCancellable(request, bodyHandler$iv, $completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(JsonHttpApiHelperImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ JsonDataSerializer access$getSerializer$p(JsonHttpApiHelperImpl $this) {
        return $this.serializer;
    }

    public static final /* synthetic */ JsonDataDeserializer access$getDeserializer$p(JsonHttpApiHelperImpl $this) {
        return $this.deserializer;
    }
}

