/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEditorAnnotatorImpl;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEngine {
    public static final ExtensionPointName<CoverageEngine> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageEngine");

    @NlsActions.ActionText
    public abstract String getPresentableText();

    public abstract boolean isApplicableTo(@NotNull RunConfigurationBase<?> var1);

    @NotNull
    public abstract CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> var1);

    @Nullable
    public final CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project2, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            CoverageEngine.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(2);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(3);
        }
        return this.createCoverageSuite(runner, name, fileProvider, null, timestamp, null, false, false, false, project2);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageEnabledConfiguration config) {
        CoverageRunner runner;
        if (config == null) {
            CoverageEngine.$$$reportNull$$$0(4);
        }
        if ((runner = config.getCoverageRunner()) == null) {
            return null;
        }
        return this.createCoverageSuite(runner, config.createSuiteName(), config.createFileProvider(), config);
    }

    @Deprecated
    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, String @Nullable [] var4, long var5, @Nullable String var7, boolean var8, boolean var9, boolean var10, Project var11);

    @Deprecated
    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, @NotNull CoverageEnabledConfiguration var4);

    @Nullable
    public abstract CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner var1);

    @NotNull
    public abstract CoverageAnnotator getCoverageAnnotator(Project var1);

    public abstract boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile var1);

    public abstract boolean acceptedByFilters(@NotNull PsiFile var1, @NotNull CoverageSuitesBundle var2);

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite2) {
        VirtualFile virtualFile;
        if (srcFile == null) {
            CoverageEngine.$$$reportNull$$$0(5);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(6);
        }
        Set<File> set = (virtualFile = srcFile.getVirtualFile()) == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (set == null) {
            CoverageEngine.$$$reportNull$$$0(7);
        }
        return set;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite2, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            CoverageEngine.$$$reportNull$$$0(8);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(9);
        }
        if (chooseSuiteAction == null) {
            CoverageEngine.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Nullable
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(11);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(12);
        }
        return null;
    }

    @NotNull
    public abstract Set<String> getQualifiedNames(@NotNull PsiFile var1);

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite2) {
        if (qualifiedName == null) {
            CoverageEngine.$$$reportNull$$$0(13);
        }
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(14);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(15);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(16);
        }
        return false;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite2) {
        if (classFile == null) {
            CoverageEngine.$$$reportNull$$$0(17);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(18);
        }
        return null;
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile2, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(19);
        }
        if (psiFile2 == null) {
            CoverageEngine.$$$reportNull$$$0(20);
        }
        int hits2 = lineData == null ? 0 : lineData.getHits();
        return CoverageBundle.message("hits.title", hits2);
    }

    public String generateBriefReport(@NotNull CoverageSuitesBundle bundle, @NotNull Editor editor, @NotNull PsiFile psiFile2, @NotNull TextRange range, @Nullable LineData lineData) {
        if (bundle == null) {
            CoverageEngine.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(22);
        }
        if (psiFile2 == null) {
            CoverageEngine.$$$reportNull$$$0(23);
        }
        if (range == null) {
            CoverageEngine.$$$reportNull$$$0(24);
        }
        int lineNumber = editor.getDocument().getLineNumber(range.getStartOffset());
        return this.generateBriefReport(editor, psiFile2, lineNumber, range.getStartOffset(), range.getEndOffset(), lineData);
    }

    public boolean isReportGenerationAvailable(@NotNull Project project2, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project2 == null) {
            CoverageEngine.$$$reportNull$$$0(25);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(26);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(27);
        }
        return false;
    }

    public void generateReport(@NotNull Project project2, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project2 == null) {
            CoverageEngine.$$$reportNull$$$0(28);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(29);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(30);
        }
    }

    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project2, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        String path2;
        VirtualFile file;
        if (project2 == null) {
            CoverageEngine.$$$reportNull$$$0(31);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(32);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(33);
        }
        ExportToHTMLDialog dialog = new ExportToHTMLDialog(project2, true);
        dialog.setTitle(CoverageBundle.message("generate.coverage.report.for", currentSuite.getPresentableName()));
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project2);
        if (StringUtil.isEmpty((String)settings.OUTPUT_DIRECTORY) && (file = ProjectUtil.guessProjectDir((Project)project2)) != null && (path2 = file.getCanonicalPath()) != null) {
            settings.OUTPUT_DIRECTORY = FileUtil.toSystemDependentName((String)path2) + File.separator + "htmlReport";
        }
        ExportToHTMLDialog exportToHTMLDialog = dialog;
        if (exportToHTMLDialog == null) {
            CoverageEngine.$$$reportNull$$$0(34);
        }
        return exportToHTMLDialog;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return false;
    }

    public Object @NotNull [] postProcessExecutableLines(Object @NotNull [] lines, @NotNull Editor editor) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(35);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(36);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(37);
        }
        return lines;
    }

    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(38);
        }
        if (coverageSuite == null) {
            CoverageEngine.$$$reportNull$$$0(39);
        }
        return CoverageLineMarkerRenderer.getRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public boolean shouldHighlightFullLines() {
        return false;
    }

    public boolean isGeneratedCode(Project project2, String qualifiedName, Object lineData) {
        return false;
    }

    @ApiStatus.Experimental
    @NotNull
    public CoverageEditorAnnotator createSrcFileAnnotator(PsiFile file, Editor editor) {
        return new CoverageEditorAnnotatorImpl(file, editor);
    }

    @NlsContexts.TabTitle
    public static String getEditorTitle() {
        return CoverageBundle.message("coverage.tab.title", new Object[0]);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project2, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return null;
    }

    public boolean isInLibraryClasses(Project project2, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibraryClasses(file) && !projectFileIndex.isInSource(file));
    }

    public boolean isInLibrarySource(Project project2, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibrarySource(file));
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase<?> conf) {
        if (conf == null) {
            CoverageEngine.$$$reportNull$$$0(40);
        }
        return false;
    }

    public Set<String> getTestsForLine(Project project2, CoverageSuitesBundle bundle, String classFQName, int lineNumber) {
        return Collections.emptySet();
    }

    public boolean wasTestDataCollected(Project project2, CoverageSuitesBundle bundle) {
        return false;
    }

    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project2) {
        if (project2 == null) {
            CoverageEngine.$$$reportNull$$$0(41);
        }
        if (testNames == null) {
            CoverageEngine.$$$reportNull$$$0(42);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            CoverageEngine.$$$reportNull$$$0(43);
        }
        if (testProxy == null) {
            CoverageEngine.$$$reportNull$$$0(44);
        }
        return null;
    }

    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite2, Map<String, Set<Integer>> trace) {
    }

    protected void deleteAssociatedTraces(CoverageSuite suite2) {
    }

    @Deprecated(forRemoval=true)
    public Set<String> getTestsForLine(Project ignoredProject, String ignoredClassFQName, int ignoredLineNumber) {
        return Collections.emptySet();
    }

    @Deprecated(forRemoval=true)
    public boolean wasTestDataCollected(Project ignoredProject) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String @Nullable [] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean bl) {
        void trackTestFolders;
        if (covRunner == null) {
            CoverageEngine.$$$reportNull$$$0(45);
        }
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(46);
        }
        if (coverageDataFileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(47);
        }
        return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, suiteToMerge, coverageByTestEnabled, branchCoverage, (boolean)trackTestFolders, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 34, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 25: 
            case 28: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 7: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 19: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessExecutableLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 7: 
            case 34: 
            case 37: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "postProcessExecutableLines";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canHavePerTestCoverage";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 34, 37 -> new IllegalStateException(string2);
        };
    }
}

