/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitListPanel
extends JPanel
implements DataProvider {
    private final List<VcsFullCommitDetails> myCommits;
    private final TableView<VcsFullCommitDetails> myTable;

    public CommitListPanel(@NotNull List<? extends VcsFullCommitDetails> commits2, @Nullable @NlsContexts.Label String emptyText) {
        if (commits2 == null) {
            CommitListPanel.$$$reportNull$$$0(0);
        }
        this.myCommits = new ArrayList<VcsFullCommitDetails>(commits2);
        this.myTable = new TableView();
        this.updateModel();
        this.myTable.setSelectionMode(2);
        this.myTable.setStriped(true);
        if (emptyText != null) {
            this.myTable.getEmptyText().setText(emptyText);
        }
        this.setLayout(new BorderLayout());
        this.add(ScrollPaneFactory.createScrollPane(this.myTable));
    }

    public void addListSelectionListener(final @NotNull Consumer<? super VcsFullCommitDetails> listener2) {
        if (listener2 == null) {
            CommitListPanel.$$$reportNull$$$0(1);
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int i = lsm.getMaxSelectionIndex();
                int j = lsm.getMinSelectionIndex();
                if (i >= 0 && i == j) {
                    listener2.consume((Object)CommitListPanel.this.myCommits.get(i));
                }
            }
        });
    }

    public void addListMultipleSelectionListener(final @NotNull Consumer<? super List<Change>> listener2) {
        if (listener2 == null) {
            CommitListPanel.$$$reportNull$$$0(2);
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List commits2 = CommitListPanel.this.myTable.getSelectedObjects();
                ArrayList<Change> changes2 = new ArrayList<Change>();
                ListIterator iterator = commits2.listIterator(commits2.size());
                while (iterator.hasPrevious()) {
                    changes2.addAll(((VcsFullCommitDetails)iterator.previous()).getChanges());
                }
                listener2.consume(CommittedChangesTreeBrowser.zipChanges(changes2));
            }
        });
    }

    public void registerDiffAction(@NotNull AnAction diffAction) {
        if (diffAction == null) {
            CommitListPanel.$$$reportNull$$$0(3);
        }
        diffAction.registerCustomShortcutSet(diffAction.getShortcutSet(), this.myTable);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            CommitListPanel.$$$reportNull$$$0(4);
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            int[] rows = this.myTable.getSelectedRows();
            if (rows.length != 1) {
                return null;
            }
            int row2 = rows[0];
            VcsFullCommitDetails commit2 = this.myCommits.get(row2);
            return commit2.getChanges().toArray(Change.EMPTY_CHANGE_ARRAY);
        }
        return null;
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        TableView<VcsFullCommitDetails> tableView = this.myTable;
        if (tableView == null) {
            CommitListPanel.$$$reportNull$$$0(5);
        }
        return tableView;
    }

    public void clearSelection() {
        this.myTable.clearSelection();
    }

    public void setCommits(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        if (commits2 == null) {
            CommitListPanel.$$$reportNull$$$0(6);
        }
        this.myCommits.clear();
        this.myCommits.addAll(commits2);
        this.updateModel();
        this.myTable.repaint();
    }

    private void updateModel() {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(this.generateColumnsInfo(this.myCommits), this.myCommits, 0));
    }

    private ColumnInfo @NotNull [] generateColumnsInfo(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        if (commits2 == null) {
            CommitListPanel.$$$reportNull$$$0(7);
        }
        ItemAndWidth hash2 = new ItemAndWidth("", 0);
        ItemAndWidth author = new ItemAndWidth("", 0);
        ItemAndWidth time = new ItemAndWidth("", 0);
        for (VcsFullCommitDetails vcsFullCommitDetails : commits2) {
            hash2 = this.getMax(hash2, CommitListPanel.getHash(vcsFullCommitDetails));
            author = this.getMax(author, CommitListPanel.getAuthor(vcsFullCommitDetails));
            time = this.getMax(time, CommitListPanel.getTime(vcsFullCommitDetails));
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new CommitColumnInfo(DvcsBundle.message("column.commit.list.hash", new Object[0]), hash2.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getHash(commit2);
            }
        }, new ColumnInfo<VcsFullCommitDetails, String>(DvcsBundle.message("column.commit.list.subject", new Object[0])){

            public String valueOf(VcsFullCommitDetails commit2) {
                return commit2.getSubject();
            }
        }, new CommitColumnInfo(DvcsBundle.message("column.commit.list.author", new Object[0]), author.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getAuthor(commit2);
            }
        }, new CommitColumnInfo(DvcsBundle.message("column.commit.list.author.time", new Object[0]), time.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getTime(commit2);
            }
        }};
        if (columnInfoArray == null) {
            CommitListPanel.$$$reportNull$$$0(8);
        }
        return columnInfoArray;
    }

    private ItemAndWidth getMax(ItemAndWidth current, String candidate) {
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(candidate);
        if (width > current.myWidth) {
            return new ItemAndWidth(candidate, width);
        }
        return current;
    }

    private static String getHash(VcsFullCommitDetails commit2) {
        return DvcsUtil.getShortHash(((Hash)commit2.getId()).toString());
    }

    private static String getAuthor(VcsFullCommitDetails commit2) {
        return VcsUserUtil.getShortPresentation(commit2.getAuthor());
    }

    private static String getTime(VcsFullCommitDetails commit2) {
        return DateFormatUtil.formatPrettyDateTime((long)commit2.getAuthorTime());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CommitListPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CommitListPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateColumnsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListSelectionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListMultipleSelectionListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerDiffAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCommits";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateColumnsInfo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8 -> new IllegalStateException(string2);
        };
    }

    private static final class ItemAndWidth {
        private final String myItem;
        private final int myWidth;

        private ItemAndWidth(String item2, int width) {
            this.myItem = item2;
            this.myWidth = width;
        }
    }

    private static abstract class CommitColumnInfo
    extends ColumnInfo<VcsFullCommitDetails, String> {
        @NotNull
        private final String myMaxString;

        CommitColumnInfo(@NotNull @NlsContexts.ColumnName String name, @NotNull String maxString) {
            if (name == null) {
                CommitColumnInfo.$$$reportNull$$$0(0);
            }
            if (maxString == null) {
                CommitColumnInfo.$$$reportNull$$$0(1);
            }
            super(name);
            this.myMaxString = maxString;
        }

        public String getMaxStringValue() {
            return this.myMaxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "maxString";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/ui/CommitListPanel$CommitColumnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

