/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.inspectopedia.extractor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionMetaInformationService;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.MetaInformation;
import com.intellij.codeInspection.ex.MetaInformationState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.options.LocMessage;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptComponent;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptDescribedComponent;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptExpandableString;
import com.intellij.codeInspection.options.OptGroup;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptSettingLink;
import com.intellij.codeInspection.options.OptString;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptTab;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.inspectopedia.extractor.data.Inspection;
import com.intellij.inspectopedia.extractor.data.OptionsPanelInfo;
import com.intellij.inspectopedia.extractor.data.Plugin;
import com.intellij.inspectopedia.extractor.data.Plugins;
import com.intellij.inspectopedia.extractor.utils.HtmlUtils;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InspectopediaExtractor
implements ApplicationStarter {
    private static final Logger LOG = Logger.getInstance(InspectopediaExtractor.class);
    private static final Map<String, ObjectMapper> ASSETS = new HashMap<String, ObjectMapper>();

    InspectopediaExtractor() {
    }

    public void main(@NotNull List<String> args) {
        if (args == null) {
            InspectopediaExtractor.$$$reportNull$$$0(0);
        }
        if (args.size() != 2) {
            LOG.error("Usage: %s <output directory>".formatted("inspectopedia-generator"));
            System.exit(-1);
        }
        JsonMapper jsonMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
        ASSETS.put("json", (ObjectMapper)jsonMapper);
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        String IDE_CODE = appInfo.getBuild().getProductCode().toLowerCase(Locale.getDefault());
        String IDE_NAME = appInfo.getVersionName();
        String IDE_VERSION = appInfo.getShortVersion();
        String ASSET_FILENAME = IDE_CODE + "-inspections.";
        String outputDirectory = args.get(1);
        Path rootOutputPath = Path.of(outputDirectory, new String[0]).toAbsolutePath();
        Path outputPath = rootOutputPath.resolve(IDE_CODE);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Output directory does not exist and could not be created");
            System.exit(-1);
        }
        if (!(Files.exists(outputPath, new LinkOption[0]) && Files.isDirectory(outputPath, new LinkOption[0]) && Files.isWritable(outputPath))) {
            LOG.error("Output path is invalid");
            System.exit(-1);
        }
        try {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            LOG.info("Using project " + project2.getName() + ", default: " + project2.isDefault());
            InspectionProjectProfileManager inspectionManager = InspectionProjectProfileManager.getInstance((Project)project2);
            List scopeToolStates = inspectionManager.getCurrentProfile().getAllTools();
            Map<String, Plugin> availablePlugins = Arrays.stream(PluginManager.getPlugins()).map(pluginDescriptor -> new Plugin(pluginDescriptor.getPluginId().getIdString(), pluginDescriptor.getName(), pluginDescriptor.getVersion())).distinct().collect(Collectors.toMap(Plugin::getId, plugin -> plugin));
            availablePlugins.put(IDE_NAME, new Plugin(IDE_NAME, IDE_NAME, IDE_VERSION));
            InspectionMetaInformationService service = (InspectionMetaInformationService)ApplicationManager.getApplication().getService(InspectionMetaInformationService.class);
            MetaInformationState inspectionsExtraState = service == null ? null : (MetaInformationState)service.getState(null);
            for (ScopeToolState scopeToolState : scopeToolStates) {
                String[] stringArray;
                InspectionToolWrapper wrapper = scopeToolState.getTool();
                InspectionEP extension = wrapper.getExtension();
                String pluginId = extension == null ? IDE_NAME : extension.getPluginDescriptor().getPluginId().getIdString();
                String originalDescription = wrapper.loadDescription();
                if (originalDescription == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    stringArray = originalDescription.split("<!-- tooltip end -->");
                }
                String[] description2 = stringArray;
                List<OptionsPanelInfo> panelInfo = null;
                try {
                    InspectionProfileEntry tool = wrapper.getTool();
                    OptPane panel2 = tool.getOptionsPane();
                    if (!panel2.equals((Object)OptPane.EMPTY)) {
                        LOG.info("Saving options panel for " + wrapper.getShortName());
                        panelInfo = InspectopediaExtractor.retrievePanelStructure(panel2, tool.getOptionController());
                    }
                }
                catch (Throwable t) {
                    LOG.info("Cannot create options panel " + wrapper.getShortName(), t);
                }
                MetaInformation metaInformation = inspectionsExtraState == null ? null : (MetaInformation)inspectionsExtraState.getInspections().get(wrapper.getID());
                List cweIds = metaInformation == null ? null : metaInformation.getCweIds();
                String language = wrapper.getLanguage();
                String briefDescription = HtmlUtils.cleanupHtml(description2[0], language);
                String extendedDescription = description2.length > 1 ? HtmlUtils.cleanupHtml(description2[1], language) : null;
                Inspection inspection = new Inspection(wrapper.getShortName(), wrapper.getDisplayName(), wrapper.getDefaultLevel().getName(), language, briefDescription, extendedDescription, Arrays.asList(wrapper.getGroupPath()), wrapper.applyToDialects(), wrapper.isCleanupTool(), wrapper.isEnabledByDefault(), panelInfo, cweIds);
                availablePlugins.get(pluginId).addInspection(inspection);
            }
            List<Plugin> sortedPlugins = availablePlugins.values().stream().sorted(Comparator.comparing(Plugin::getId)).peek(plugin -> plugin.inspections.sort(null)).toList();
            Plugins pluginsData = new Plugins(sortedPlugins, IDE_CODE, IDE_NAME, IDE_VERSION);
            for (String ext : ASSETS.keySet()) {
                String data2 = "";
                try {
                    data2 = ASSETS.get(ext).writeValueAsString((Object)pluginsData);
                }
                catch (JsonProcessingException e) {
                    LOG.error("Cannot serialize " + ext.toUpperCase(Locale.getDefault()), (Throwable)e);
                    System.exit(-1);
                }
                Path outPath = outputPath.resolve(ASSET_FILENAME + ext);
                try {
                    Files.writeString(outPath, (CharSequence)data2, new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.error("Cannot write " + outPath, (Throwable)e);
                    System.exit(-1);
                }
                LOG.info("Inspections info saved in " + outPath);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    @Nullable
    private static LocMessage getMyText(@NotNull OptComponent cmp) {
        if (cmp == null) {
            InspectopediaExtractor.$$$reportNull$$$0(1);
        }
        if (cmp instanceof OptCheckbox) {
            OptCheckbox checkbox = (OptCheckbox)cmp;
            return checkbox.label();
        }
        if (cmp instanceof OptString) {
            OptString string2 = (OptString)cmp;
            return string2.splitLabel();
        }
        if (cmp instanceof OptNumber) {
            OptNumber number = (OptNumber)cmp;
            return number.splitLabel();
        }
        if (cmp instanceof OptExpandableString) {
            OptExpandableString expandableString = (OptExpandableString)cmp;
            return expandableString.label();
        }
        if (cmp instanceof OptStringList) {
            OptStringList list2 = (OptStringList)cmp;
            return list2.label();
        }
        if (cmp instanceof OptTable) {
            OptTable table = (OptTable)cmp;
            return table.label();
        }
        if (cmp instanceof OptTableColumn) {
            OptTableColumn column = (OptTableColumn)cmp;
            return column.name();
        }
        if (cmp instanceof OptTab) {
            OptTab tab = (OptTab)cmp;
            return tab.label();
        }
        if (cmp instanceof OptDropdown) {
            OptDropdown dropdown = (OptDropdown)cmp;
            return dropdown.splitLabel();
        }
        if (cmp instanceof OptGroup) {
            OptGroup group2 = (OptGroup)cmp;
            return group2.label();
        }
        if (cmp instanceof OptSettingLink) {
            OptSettingLink link2 = (OptSettingLink)cmp;
            return link2.displayName();
        }
        return null;
    }

    @NotNull
    private static @NotNull List<@NotNull OptionsPanelInfo> retrievePanelStructure(@NotNull OptPane pane2, @NotNull OptionController controller) {
        if (pane2 == null) {
            InspectopediaExtractor.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            InspectopediaExtractor.$$$reportNull$$$0(3);
        }
        ArrayList<OptionsPanelInfo> children = new ArrayList<OptionsPanelInfo>();
        for (OptRegularComponent component2 : pane2.components()) {
            children.add(InspectopediaExtractor.retrievePanelStructure((OptComponent)component2, controller));
        }
        ArrayList<OptionsPanelInfo> arrayList = children;
        if (arrayList == null) {
            InspectopediaExtractor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static OptionsPanelInfo retrievePanelStructure(@NotNull OptComponent component2, @NotNull OptionController controller) {
        LocMessage text2;
        if (component2 == null) {
            InspectopediaExtractor.$$$reportNull$$$0(5);
        }
        if (controller == null) {
            InspectopediaExtractor.$$$reportNull$$$0(6);
        }
        OptionsPanelInfo result2 = new OptionsPanelInfo();
        result2.type = component2.getClass().getSimpleName();
        if (component2 instanceof OptControl) {
            OptControl control = (OptControl)component2;
            v0 = controller.getOption(control.bindId());
        } else {
            v0 = result2.value = null;
        }
        if (component2 instanceof OptDropdown) {
            OptDropdown dropdown = (OptDropdown)component2;
            if (result2.value != null) {
                OptDropdown.Option option = dropdown.findOption(result2.value);
                result2.value = option == null ? null : option.label().label();
            }
            result2.content = ContainerUtil.map((Collection)dropdown.options(), opt -> opt.label().label());
        }
        String string2 = result2.text = (text2 = InspectopediaExtractor.getMyText(component2)) == null ? null : text2.label();
        if (component2 instanceof OptDescribedComponent) {
            OptDescribedComponent describedComponent = (OptDescribedComponent)component2;
            HtmlChunk description2 = describedComponent.description();
            result2.description = description2 == null ? null : description2.toString();
        }
        ArrayList<OptionsPanelInfo> children = new ArrayList<OptionsPanelInfo>();
        for (OptComponent child : component2.children()) {
            children.add(InspectopediaExtractor.retrievePanelStructure(child, controller));
        }
        if (!children.isEmpty()) {
            result2.children = children;
        }
        OptionsPanelInfo optionsPanelInfo = result2;
        if (optionsPanelInfo == null) {
            InspectopediaExtractor.$$$reportNull$$$0(7);
        }
        return optionsPanelInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/inspectopedia/extractor/InspectopediaExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/inspectopedia/extractor/InspectopediaExtractor";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrievePanelStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMyText";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelStructure";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 7 -> new IllegalStateException(string2);
        };
    }
}

