/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.find.FindModel;
import com.intellij.find.impl.livePreview.EditorSearchAreaProvider;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.SearchInDiffChangesProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010\f\u001a\u0004\u0018\u00010\r\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00042\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u0015H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u0004*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/diff/impl/SearchInDiffChangesProvider;", "Lcom/intellij/find/impl/livePreview/EditorSearchAreaProvider;", "()V", "notSkippedChanges", "", "Lcom/intellij/diff/tools/fragmented/UnifiedDiffChange;", "Lcom/intellij/diff/tools/fragmented/UnifiedDiffViewer;", "getNotSkippedChanges", "(Lcom/intellij/diff/tools/fragmented/UnifiedDiffViewer;)Ljava/util/List;", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "(Lcom/intellij/diff/tools/simple/SimpleDiffViewer;)Ljava/util/List;", "buildSearchArea", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchArea;", "Change", "document", "Lcom/intellij/openapi/editor/Document;", "changes", "startLine", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "endLine", "getSearchArea", "editor", "Lcom/intellij/openapi/editor/Editor;", "findModel", "Lcom/intellij/find/FindModel;", "isEnabled", "", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nSearchInDiffChangesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchInDiffChangesProvider.kt\ncom/intellij/openapi/diff/impl/SearchInDiffChangesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n819#2:70\n847#2,2:71\n819#2:73\n847#2,2:74\n*S KotlinDebug\n*F\n+ 1 SearchInDiffChangesProvider.kt\ncom/intellij/openapi/diff/impl/SearchInDiffChangesProvider\n*L\n45#1:70\n45#1:71,2\n48#1:73\n48#1:74,2\n*E\n"})
public final class SearchInDiffChangesProvider
implements EditorSearchAreaProvider {
    public boolean isEnabled(@NotNull Editor editor, @NotNull FindModel findModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        if (editor.isDisposed()) {
            return false;
        }
        if (findModel.isReplaceState()) {
            return false;
        }
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        Object dataContext = editorEx != null ? editorEx.getDataContext() : null;
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null || (dataContext2 = (DiffContext)dataContext2.getData(DiffDataKeys.DIFF_CONTEXT)) == null) {
            return false;
        }
        DataContext diffContext = dataContext2;
        UserDataHolder[] userDataHolderArray = new UserDataHolder[]{diffContext};
        return DiffUtil.isUserDataFlagSet((Key)DiffUserDataKeys.ENABLE_SEARCH_IN_CHANGES, (UserDataHolder[])userDataHolderArray);
    }

    @Nullable
    public SearchResults.SearchArea getSearchArea(@NotNull Editor editor, @NotNull FindModel findModel) {
        SearchResults.SearchArea searchArea;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        FrameDiffTool.DiffViewer viewer = (FrameDiffTool.DiffViewer)editor.getUserData(DiffUserDataKeys.DIFF_VIEWER);
        if (viewer instanceof SimpleDiffViewer) {
            Side side = Intrinsics.areEqual((Object)((SimpleDiffViewer)viewer).getEditor1(), (Object)editor) ? Side.LEFT : Side.RIGHT;
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            searchArea = this.buildSearchArea(document2, this.getNotSkippedChanges((SimpleDiffViewer)viewer), (Function1)new Function1<SimpleDiffChange, Integer>(side){
                final /* synthetic */ Side $side;
                {
                    this.$side = $side;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull SimpleDiffChange $this$buildSearchArea) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildSearchArea, (String)"$this$buildSearchArea");
                    return $this$buildSearchArea.getStartLine(this.$side);
                }
            }, (Function1)new Function1<SimpleDiffChange, Integer>(side){
                final /* synthetic */ Side $side;
                {
                    this.$side = $side;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull SimpleDiffChange $this$buildSearchArea) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildSearchArea, (String)"$this$buildSearchArea");
                    return $this$buildSearchArea.getEndLine(this.$side);
                }
            });
        } else if (viewer instanceof UnifiedDiffViewer) {
            Document document3 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            searchArea = this.buildSearchArea(document3, this.getNotSkippedChanges((UnifiedDiffViewer)viewer), getSearchArea.3.INSTANCE, getSearchArea.4.INSTANCE);
        } else if (viewer instanceof MergeThreesideViewer) {
            Document document4 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document4, (String)"getDocument(...)");
            List list2 = ((MergeThreesideViewer)viewer).getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChanges(...)");
            searchArea = this.buildSearchArea(document4, list2, getSearchArea.5.INSTANCE, getSearchArea.6.INSTANCE);
        } else {
            searchArea = null;
        }
        return searchArea;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleDiffChange> getNotSkippedChanges(SimpleDiffViewer $this$notSkippedChanges) {
        void $this$filterNotTo$iv$iv;
        List list2 = $this$notSkippedChanges.getDiffChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDiffChanges(...)");
        Iterable $this$filterNot$iv = list2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SimpleDiffChange p0 = (SimpleDiffChange)element$iv$iv;
            boolean bl = false;
            if (p0.isSkipped()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnifiedDiffChange> getNotSkippedChanges(UnifiedDiffViewer $this$notSkippedChanges) {
        List list2;
        List list3;
        List list4 = $this$notSkippedChanges.getDiffChanges();
        if (list4 != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = list4;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                UnifiedDiffChange p0 = (UnifiedDiffChange)element$iv$iv;
                boolean bl = false;
                if (p0.isSkipped()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final <Change> SearchResults.SearchArea buildSearchArea(Document document2, List<? extends Change> changes2, Function1<? super Change, Integer> startLine, Function1<? super Change, Integer> endLine) {
        if (changes2.isEmpty()) {
            return null;
        }
        int[] starts = new int[changes2.size()];
        int[] ends = new int[changes2.size()];
        int n = changes2.size();
        for (int index = 0; index < n; ++index) {
            Change change = changes2.get(index);
            TextRange changeRange = DiffUtil.getLinesRange((Document)document2, (int)((Number)startLine.invoke(change)).intValue(), (int)((Number)endLine.invoke(change)).intValue());
            starts[index] = changeRange.getStartOffset();
            ends[index] = changeRange.getEndOffset();
        }
        return SearchResults.SearchArea.create((int[])starts, (int[])ends);
    }
}

