/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VcsFreezingProcess {
    private static final Logger LOG = Logger.getInstance(VcsFreezingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final ChangeListManagerEx myChangeListManager;

    public VcsFreezingProcess(@NotNull Project project2, @NotNull @Nls String operationTitle, @NotNull Runnable runnable) {
        if (project2 == null) {
            VcsFreezingProcess.$$$reportNull$$$0(0);
        }
        if (operationTitle == null) {
            VcsFreezingProcess.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            VcsFreezingProcess.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myOperationTitle = operationTitle;
        this.myRunnable = runnable;
        this.myChangeListManager = ChangeListManagerEx.getInstanceEx(project2);
    }

    public void execute() {
        LOG.debug("starting");
        try {
            LOG.debug("saving documents, blocking project autosync");
            this.saveAndBlockInAwt();
            try {
                LOG.debug("freezing the ChangeListManager");
                this.freeze();
                LOG.debug("running the operation");
                this.myRunnable.run();
                LOG.debug("operation completed.");
            }
            finally {
                LOG.debug("unfreezing the ChangeListManager");
                this.unfreeze();
            }
        }
        finally {
            LOG.debug("unblocking project autosync");
            this.unblockInAwt();
        }
        LOG.debug("finished.");
    }

    private void saveAndBlockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            StoreReloadManager.Companion.getInstance(this.myProject).blockReloadingProjectOnExternalChanges();
            FileDocumentManager.getInstance().saveAllDocuments();
            SaveAndSyncHandler saveAndSyncHandler = SaveAndSyncHandler.getInstance();
            saveAndSyncHandler.blockSaveOnFrameDeactivation();
            saveAndSyncHandler.blockSyncOnFrameActivation();
        });
    }

    private void unblockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            StoreReloadManager.Companion.getInstance(this.myProject).unblockReloadingProjectOnExternalChanges();
            SaveAndSyncHandler saveAndSyncHandler = SaveAndSyncHandler.getInstance();
            saveAndSyncHandler.unblockSaveOnFrameDeactivation();
            saveAndSyncHandler.unblockSyncOnFrameActivation();
        });
    }

    private void freeze() {
        ((Listener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, Listener.TOPIC)).onFreeze();
        this.myChangeListManager.freeze(VcsBundle.message("local.changes.freeze.message", this.myOperationTitle));
    }

    private void unfreeze() {
        ((Listener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, Listener.TOPIC)).onUnfreeze();
        this.myChangeListManager.unfreeze();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "operationTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/VcsFreezingProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public static final Topic<Listener> TOPIC = Topic.create((String)"Change List Manager Freeze", Listener.class);

        default public void onFreeze() {
        }

        default public void onUnfreeze() {
        }
    }
}

